/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.data.legacy;

import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import net.minecraft.core.world.biome.Biome;
import net.minecraft.core.world.biome.Biomes;

public abstract class LegacyBiomes {
    private static final Int2ObjectMap<Biome> idToBiomeMap = new Int2ObjectArrayMap<Biome>();
    private static final Object2IntMap<Biome> biomeToIdMap = new Object2IntArrayMap<Biome>();

    private static void register(Biome biome, int id) {
        idToBiomeMap.put(id, biome);
        biomeToIdMap.put(biome, id);
    }

    public static Biome getBiomeById(int id) {
        return (Biome)idToBiomeMap.get(id);
    }

    public static int getBiomeId(Biome biome) {
        return biomeToIdMap.getInt(biome);
    }

    static {
        LegacyBiomes.register(Biomes.OVERWORLD_RAINFOREST, 0);
        LegacyBiomes.register(Biomes.OVERWORLD_SWAMPLAND, 1);
        LegacyBiomes.register(Biomes.OVERWORLD_SEASONAL_FOREST, 2);
        LegacyBiomes.register(Biomes.OVERWORLD_FOREST, 3);
        LegacyBiomes.register(Biomes.OVERWORLD_GRASSLANDS, 4);
        LegacyBiomes.register(Biomes.OVERWORLD_OUTBACK, 5);
        LegacyBiomes.register(Biomes.OVERWORLD_SHRUBLAND, 6);
        LegacyBiomes.register(Biomes.OVERWORLD_TAIGA, 7);
        LegacyBiomes.register(Biomes.OVERWORLD_BOREAL_FOREST, 8);
        LegacyBiomes.register(Biomes.OVERWORLD_DESERT, 9);
        LegacyBiomes.register(Biomes.OVERWORLD_PLAINS, 10);
        LegacyBiomes.register(Biomes.OVERWORLD_GLACIER, 11);
        LegacyBiomes.register(Biomes.OVERWORLD_TUNDRA, 12);
        LegacyBiomes.register(Biomes.OVERWORLD_MEADOW, 13);
        LegacyBiomes.register(Biomes.NETHER_CRAG, 14);
        LegacyBiomes.register(Biomes.DRIFT_DRIFT, 15);
        LegacyBiomes.register(Biomes.OVERWORLD_BIRCH_FOREST, 16);
        LegacyBiomes.register(Biomes.OVERWORLD_RETRO, 17);
        LegacyBiomes.register(Biomes.OVERWORLD_HELL, 18);
        LegacyBiomes.register(Biomes.OVERWORLD_SWAMPLAND_MUDDY, 19);
        LegacyBiomes.register(Biomes.OVERWORLD_OUTBACK_GRASSY, 20);
    }
}

