/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.net.command.helpers;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.core.net.command.exceptions.CommandExceptions;
import org.jetbrains.annotations.Nullable;

public class IntegerCoordinate {
    private final boolean isRelative;
    private final int coordinate;

    public IntegerCoordinate(boolean isRelative, int coordinate) {
        this.isRelative = isRelative;
        this.coordinate = coordinate;
    }

    public int get(@Nullable Integer sourceCoordinate) throws CommandSyntaxException {
        if (this.isRelative) {
            if (sourceCoordinate != null) {
                return sourceCoordinate + this.coordinate;
            }
            throw CommandExceptions.notInWorld().create();
        }
        return this.coordinate;
    }

    public static IntegerCoordinate parse(StringReader reader) throws CommandSyntaxException {
        if (!reader.canRead()) {
            throw CommandExceptions.incomplete().createWithContext(reader);
        }
        char peak = reader.peek();
        if (peak == '~' || peak == '#') {
            reader.skip();
            if (reader.canRead() && reader.peek() != ' ') {
                int coordinate = reader.readInt();
                return new IntegerCoordinate(true, coordinate);
            }
            return new IntegerCoordinate(true, 0);
        }
        if (reader.peek() != ' ') {
            int coordinate = reader.readInt();
            return new IntegerCoordinate(false, coordinate);
        }
        throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.readerExpectedInt().createWithContext(reader);
    }

    public boolean isRelative() {
        return this.isRelative;
    }
}

