/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.generate.chunk;

import java.util.Random;
import net.minecraft.core.world.World;
import net.minecraft.core.world.chunk.Chunk;
import net.minecraft.core.world.generate.chunk.PositionSelector;
import net.minecraft.core.world.generate.feature.WorldFeature;
import net.minecraft.core.world.generate.feature.WorldFeatureInterface;
import net.minecraft.core.world.pos.TilePos;
import org.jetbrains.annotations.NotNull;

public class PlaceableFeature {
    @NotNull
    private final PositionSelector positionSelector;
    @NotNull
    private final WorldFeatureInterface feature;
    private final int minY;
    private final int maxY;
    private final int rangeY;

    public PlaceableFeature(@NotNull WorldFeatureInterface feature, @NotNull PositionSelector positionSelector, int minY, int maxY, int rangeY) {
        this.feature = feature;
        this.positionSelector = positionSelector;
        this.minY = minY;
        this.maxY = maxY;
        this.rangeY = rangeY;
    }

    public void placeFeature(@NotNull World world, @NotNull Chunk chunk, @NotNull Random random) {
        TilePos tilePosition = this.positionSelector.getValue(world, chunk, random, this.minY, this.maxY, this.rangeY);
        if (this.feature instanceof WorldFeature) {
            ((WorldFeature)this.feature).init(1.0, 1.0, 1.0);
        }
        this.feature.place(world, random, tilePosition);
    }
}

