/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.generate.feature.weatherable;

import java.util.Random;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.world.World;
import net.minecraft.core.world.generate.feature.MethodParametersAnnotation;
import net.minecraft.core.world.generate.feature.WorldFeatureInterface;
import net.minecraft.core.world.generate.feature.weatherable.Operation;
import net.minecraft.core.world.generate.feature.weatherable.operation.BlastOperation;
import net.minecraft.core.world.generate.feature.weatherable.operation.CollapseOperation;
import net.minecraft.core.world.generate.feature.weatherable.operation.CrumbleOperation;
import net.minecraft.core.world.generate.feature.weatherable.operation.FallOperation;
import net.minecraft.core.world.generate.feature.weatherable.operation.HoleOperation;
import net.minecraft.core.world.generate.feature.weatherable.operation.MossOperation;
import net.minecraft.core.world.generate.feature.weatherable.operation.RotOperation;
import net.minecraft.core.world.generate.feature.weatherable.operation.SinkOperation;
import net.minecraft.core.world.pos.TilePosc;
import net.minecraft.core.world.structure.EditableStructure;
import net.minecraft.core.world.structure.SavedStructure;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3ic;

public class WorldFeatureWeatherable
implements WorldFeatureInterface {
    private static final int MIN_OPERATIONS_TO_APPLY = 100;
    private static final int MAX_OPERATIONS_TO_APPLY = 500;
    @NotNull
    private static final @NotNull Operation @NotNull [] OPERATIONS = new Operation[]{new RotOperation(), new CrumbleOperation(), new SinkOperation(), new HoleOperation(), new CollapseOperation(), new BlastOperation()};
    private final int age;
    @NotNull
    private final String id;

    @MethodParametersAnnotation(names={"age", "id"})
    public WorldFeatureWeatherable(int age, @NotNull String id) {
        this.age = age;
        this.id = id;
    }

    @Override
    public boolean place(@NotNull World world, @NotNull Random random, @NotNull TilePosc tilePos) {
        if (world.getBlockType(tilePos) != Blocks.GRASS) {
            return false;
        }
        @Nullable SavedStructure structure = SavedStructure.load(this.id);
        if (structure == null) {
            return false;
        }
        @NotNull EditableStructure editableStructure = new EditableStructure(structure);
        Vector3ic size = editableStructure.getSize();
        int maxOperations = size.x() * size.z() * this.age;
        int minOperations = maxOperations / 2;
        int operations = minOperations + random.nextInt(maxOperations - minOperations);
        for (int i = 0; i < operations; ++i) {
            OPERATIONS[random.nextInt(OPERATIONS.length)].apply(editableStructure, random);
        }
        new FallOperation().apply(editableStructure, random);
        @NotNull MossOperation mossOperation = new MossOperation();
        int mossOperations = this.age * 100;
        for (int i = 0; i < mossOperations; ++i) {
            mossOperation.apply(editableStructure, random);
        }
        editableStructure.place(world, tilePos);
        return true;
    }
}

