/*
 * Decompiled with CFR 0.152.
 */
package org.useless.dragonfly.data.entity.mojang;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.useless.dragonfly.data.entity.mojang.Cube;
import org.useless.util.GsonHelper;

public class Bone {
    @NotNull
    public final String name;
    @Nullable
    public final String parent;
    public final double @NotNull [] pivot;
    public final double @NotNull [] rotation;
    @NotNull
    public final @NotNull Cube @NotNull [] cubes;
    public final double inflate;

    protected Bone(@NotNull String name, @Nullable String parent, double @NotNull [] pivot, double @NotNull [] rotation, double inflate, @NotNull Collection<Cube.Builder> cubes) {
        this.name = name;
        this.parent = parent;
        this.pivot = pivot;
        this.rotation = rotation;
        this.cubes = new Cube[cubes.size()];
        this.inflate = inflate;
        int i = 0;
        for (Cube.Builder builder : cubes) {
            this.cubes[i] = builder.build();
            ++i;
        }
    }

    public static class Builder {
        @NotNull
        private final String name;
        @Nullable
        private String parent;
        private final double @NotNull [] pivot;
        private final double @NotNull [] rotation;
        private double inflate;
        @NotNull
        private final @NotNull List<@NotNull Cube.Builder> cubes = new ArrayList<Cube.Builder>();
        private boolean mirror;

        public Builder(@NotNull String name) {
            this.name = name;
            this.parent = null;
            this.pivot = new double[]{0.0, 0.0, 0.0};
            this.rotation = new double[]{0.0, 0.0, 0.0};
            this.inflate = 0.0;
            this.mirror = false;
        }

        @NotNull
        public Builder setParent(@NotNull String parent) {
            this.parent = parent;
            return this;
        }

        @NotNull
        public Builder setPivot(double x, double y, double z) {
            this.pivot[0] = x;
            this.pivot[1] = y;
            this.pivot[2] = z;
            return this;
        }

        @NotNull
        public Builder setRotation(double x, double y, double z) {
            this.rotation[0] = x;
            this.rotation[1] = y;
            this.rotation[2] = z;
            return this;
        }

        @NotNull
        public Builder setInflation(double inflation) {
            this.inflate = inflation;
            return this;
        }

        @NotNull
        public Builder setMirror(boolean mirror) {
            this.mirror = mirror;
            return this;
        }

        @NotNull
        public Builder addCube(@NotNull Cube.Builder cube) {
            this.cubes.add(cube);
            return this;
        }

        @NotNull
        protected Bone build() {
            if (this.mirror) {
                for (Cube.Builder builder : this.cubes) {
                    builder.setMirror();
                }
            }
            return new Bone(this.name, this.parent, this.pivot, this.rotation, this.inflate, this.cubes);
        }

        public static class Serializer
        implements JsonSerializer<Builder>,
        JsonDeserializer<Builder> {
            @Override
            public Builder deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                JsonObject object = json.getAsJsonObject();
                Builder builder = new Builder(object.get("name").getAsString());
                if (object.has("parent")) {
                    builder.setParent(object.get("parent").getAsString());
                }
                if (object.has("pivot")) {
                    double[] pivot = GsonHelper.getAsDoubleArray(object.get("pivot"), 3);
                    builder.setPivot(pivot[0], pivot[1], pivot[2]);
                }
                if (object.has("rotation")) {
                    double[] rotation = GsonHelper.getAsDoubleArray(object.get("rotation"), 3);
                    builder.setRotation(rotation[0], rotation[1], rotation[2]);
                }
                if (object.has("inflate")) {
                    builder.setInflation(object.get("inflate").getAsDouble());
                }
                if (object.has("mirror")) {
                    builder.setMirror(object.get("mirror").getAsBoolean());
                }
                if (object.has("cubes")) {
                    JsonArray cubes = object.getAsJsonArray("cubes");
                    for (JsonElement e : cubes) {
                        builder.addCube((Cube.Builder)context.deserialize(e, (Type)((Object)Cube.Builder.class)));
                    }
                }
                return builder;
            }

            @Override
            public JsonElement serialize(Builder src, Type typeOfSrc, JsonSerializationContext context) {
                throw new UnsupportedOperationException();
            }
        }
    }
}

