/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.player.inventory.container;

import net.minecraft.core.entity.player.Player;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.player.inventory.InventorySorter;
import net.minecraft.core.player.inventory.container.Container;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ContainerSimple
implements Container {
    @NotNull
    private final String name;
    private final @Nullable ItemStack @NotNull [] items;

    public ContainerSimple(@NotNull String name, int size) {
        this.name = name;
        this.items = new ItemStack[size];
    }

    @Override
    @Nullable
    public ItemStack getItem(int slot) {
        return this.items[slot];
    }

    @Override
    @Nullable
    public ItemStack removeItem(int slot, int takeAmount) {
        @Nullable ItemStack stack = this.items[slot];
        if (stack != null) {
            if (stack.stackSize <= takeAmount) {
                ItemStack currentStack = stack;
                this.items[slot] = null;
                return currentStack;
            }
            @NotNull ItemStack otherHalf = stack.splitStack(takeAmount);
            if (stack.stackSize <= 0) {
                this.items[slot] = null;
            }
            return otherHalf;
        }
        return null;
    }

    @Override
    public void setItem(int slot, @Nullable ItemStack stack) {
        this.items[slot] = stack;
        if (stack != null && stack.stackSize > this.getMaxStackSize()) {
            stack.stackSize = this.getMaxStackSize();
        }
    }

    @Override
    public int getContainerSize() {
        return this.items.length;
    }

    @Override
    @NotNull
    public String getNameTranslationKey() {
        return this.name;
    }

    @Override
    public int getMaxStackSize() {
        return 64;
    }

    @Override
    public void setChanged() {
    }

    @Override
    public boolean stillValid(@NotNull Player player) {
        return true;
    }

    @Override
    public void sort() {
        InventorySorter.sortInventory(this.items);
    }
}

