/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.generate;

import java.util.Random;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.World;
import net.minecraft.core.world.biome.Biome;
import net.minecraft.core.world.biome.Biomes;
import net.minecraft.core.world.generate.LargeFeature;
import net.minecraft.core.world.generate.chunk.ChunkGeneratorResult;
import net.minecraft.core.world.noise.FractalNoise2D;
import net.minecraft.core.world.noise.ImprovedPerlinNoise;
import net.minecraft.core.world.noise.Noise2D;
import net.minecraft.core.world.noise.WorleyNoise;
import net.minecraft.core.world.noise.operator.Normalize2D;
import net.minecraft.core.world.pos.TilePos;
import net.minecraft.core.world.type.WorldType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LavaFloeLargeFeature
extends LargeFeature {
    @Nullable
    private WorleyNoise chunkNoise = null;
    @Nullable
    private Noise2D gapNoise = null;
    @Nullable
    private Noise2D heightNoise = null;
    @Nullable
    private Noise2D scaleNoise = null;
    @Nullable
    private World lastWorld = null;

    @Override
    protected void doGeneration(@NotNull World world, @NotNull Random random, int chunkX, int chunkZ, int baseChunkX, int baseChunkZ, @NotNull ChunkGeneratorResult result) {
        if (this.chunkNoise == null || this.gapNoise == null || this.heightNoise == null || this.scaleNoise == null || this.lastWorld != world) {
            this.chunkNoise = new WorleyNoise(new Random(world.getRandomSeed()));
            this.gapNoise = new FractalNoise2D((Noise2D[])ImprovedPerlinNoise.genOctaves(world.getRandomSeed(), 4));
            this.heightNoise = new FractalNoise2D((Noise2D[])ImprovedPerlinNoise.genOctaves(world.getRandomSeed(), 4));
            this.scaleNoise = new Normalize2D<FractalNoise2D>(new FractalNoise2D((Noise2D[])ImprovedPerlinNoise.genOctaves(world.getRandomSeed(), 2)));
            this.lastWorld = world;
        }
        @NotNull WorldType worldType = world.getWorldType();
        int oceanY = worldType.getMinY(world) + worldType.getOceanY();
        @NotNull TilePos tilePos = new TilePos();
        @NotNull WorleyNoise.Result worleyResult = new WorleyNoise.Result();
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                tilePos.set(16 * baseChunkX + x, oceanY, 16 * baseChunkZ + z);
                @NotNull Biome biome = world.getBlockBiome(tilePos);
                if (biome != Biomes.NETHER_VOLCANIC_ISLANDS) continue;
                this.chunkNoise.getValue((double)((float)baseChunkX + (float)x / 16.0f), (double)((float)baseChunkZ + (float)z / 16.0f), worleyResult);
                float lineScale = 5.0f;
                float lineWidth = (float)(this.gapNoise.getValue((float)(baseChunkX * 16 + x) / 5.0f, (float)(baseChunkZ * 16 + z) / 5.0f) / 2.0 + 0.5);
                int heightMod = worleyResult.getRandom().nextInt(3) + 1;
                float height = (float)(this.heightNoise.getValue((float)(baseChunkX * 16 + x) / 5.0f, (float)(baseChunkZ * 16 + z) / 5.0f) / 2.0 + 0.5) * (float)heightMod;
                if (MathHelper.unsignedMod(worleyResult.index, 15.0) == 0.0 || worleyResult.distance > (double)(0.9f + lineWidth * 0.01f)) continue;
                int y = oceanY - 3;
                while ((float)y < (float)oceanY + (height - 2.0f)) {
                    if (random.nextInt(20) == 0) {
                        this.trySetBlock(result, x, y, z, Blocks.PUMICE_WET.id());
                    } else {
                        this.trySetBlock(result, x, y, z, Blocks.COBBLE_NETHERRACK.id());
                    }
                    ++y;
                }
                y = oceanY + (int)(height - 2.0f);
                while ((float)y < (float)oceanY + (height + 1.0f)) {
                    this.trySetBlock(result, x, y, z, Blocks.BRIMSAND.id());
                    ++y;
                }
            }
        }
    }

    private void trySetBlock(@NotNull ChunkGeneratorResult result, int x, int y, int z, int id) {
        int current = result.getBlock(x, y, z);
        if (current == Blocks.FLUID_LAVA_STILL.id() || current == 0) {
            result.setBlock(x, y, z, id);
        }
    }

    @Override
    public int getRadiusChunk() {
        return 0;
    }
}

