/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.material.Materials;
import net.minecraft.core.block.tag.BlockTags;
import net.minecraft.core.entity.EntityFallingBlock;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;
import net.minecraft.core.world.pos.TilePos;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.primitives.AABBd;
import org.joml.primitives.AABBdc;

public class BlockLogicFlowstone
extends BlockLogic {
    public BlockLogicFlowstone(@NotNull Block<?> block) {
        super(block, Materials.STONE);
    }

    @Override
    public int getPlacedData(@Nullable Player player, @NotNull ItemStack itemStack, @NotNull World world, @NotNull TilePosc tilePos, @NotNull Side side, double xHit, double yHit) {
        return itemStack.getMetadata();
    }

    @Override
    @NotNull
    public AABBdc getBoundsFromState(@NotNull WorldSource source, @NotNull TilePosc tilePos) {
        int data = source.getBlockData(tilePos);
        if (data == 0 || data > 3) {
            return new AABBd(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        }
        double offset = 2.0 * (double)data;
        return new AABBd(offset / 16.0, 0.0, offset / 16.0, (16.0 - offset) / 16.0, 1.0, (16.0 - offset) / 16.0);
    }

    @Override
    public boolean isSolidRender() {
        return false;
    }

    @Override
    public boolean isCubeShaped() {
        return false;
    }

    @Override
    public void onPlacedByWorld(@NotNull World world, @NotNull TilePosc tilePos) {
        world.scheduleBlockUpdate(tilePos, this.block, this.tickDelay());
    }

    @Override
    public void onNeighborChanged(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Block<?> block) {
        world.scheduleBlockUpdate(tilePos, this.block, this.tickDelay());
    }

    @Override
    public void updateTick(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Random rand, boolean isRandomTick) {
        this.tryToFall(world, tilePos);
    }

    private void tryToFall(@NotNull World world, @NotNull TilePosc tilePos) {
        int y;
        boolean topCanFall = false;
        boolean bottomCanFall = false;
        int y1 = -1;
        int y0 = -1;
        @NotNull TilePos queryPos = new TilePos();
        for (y = tilePos.y(); y < world.getHeightBlocks(); ++y) {
            queryPos.set(tilePos.x(), y + 1, tilePos.z());
            if (BlockLogicFlowstone.canFall(world, queryPos)) {
                topCanFall = true;
                y1 = y;
                break;
            }
            if (world.getBlockType(queryPos).getLogic() == this) continue;
            return;
        }
        if (!topCanFall) {
            return;
        }
        for (y = tilePos.y(); y > 0; --y) {
            queryPos.set(tilePos.x(), y - 1, tilePos.z());
            if (BlockLogicFlowstone.canFall(world, queryPos)) {
                bottomCanFall = true;
                y0 = y;
                break;
            }
            if (world.getBlockType(queryPos).getLogic() == this) continue;
            return;
        }
        if (!bottomCanFall) {
            return;
        }
        for (y = y0; y <= y1; ++y) {
            queryPos.set(tilePos.x(), y, tilePos.z());
            int data = world.getBlockData(queryPos);
            @NotNull EntityFallingBlock entity = new EntityFallingBlock(world, (float)tilePos.x() + 0.5f, (float)y + 0.5f, (float)tilePos.z() + 0.5f, this.block.id(), data, null);
            world.entityJoinedWorld(entity);
        }
    }

    @Override
    public int tickDelay() {
        return 3;
    }

    @Override
    public void animationTick(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Random rand) {
        int data = world.getBlockData(tilePos);
        if (world.getBlockType(tilePos.down(new TilePos())) == Blocks.AIR && rand.nextInt(20) == 0) {
            double scale = 1.0 - 0.125 * (double)data;
            double cx = (double)tilePos.x() + 0.5 - scale / 2.0;
            double cz = (double)tilePos.z() + 0.5 - scale / 2.0;
            double dx = rand.nextDouble();
            double dz = rand.nextDouble();
            world.spawnParticle("dripWater", cx + scale * dx, (float)tilePos.y() - 0.05f, cz + scale * dz, 0.0, 0.0, 0.0, 0);
        }
    }

    private static boolean canFall(@NotNull World world, @NotNull TilePosc tilePos) {
        @NotNull Block<?> block = world.getBlockType(tilePos);
        if (block == Blocks.FLOWSTONE) {
            return false;
        }
        return block.hasTag(BlockTags.PLACE_OVERWRITES);
    }
}

