/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.generate;

import java.util.Random;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.world.World;
import net.minecraft.core.world.biome.Biome;
import net.minecraft.core.world.biome.Biomes;
import net.minecraft.core.world.generate.LargeFeature;
import net.minecraft.core.world.generate.chunk.ChunkGeneratorResult;
import net.minecraft.core.world.noise.FractalNoise2D;
import net.minecraft.core.world.noise.ImprovedPerlinNoise;
import net.minecraft.core.world.noise.Noise2D;
import net.minecraft.core.world.noise.WorleyNoise;
import net.minecraft.core.world.noise.operator.Normalize2D;
import net.minecraft.core.world.pos.TilePos;
import net.minecraft.core.world.type.WorldType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShelfLargeFeature
extends LargeFeature {
    @Nullable
    private WorleyNoise chunkNoise = null;
    @Nullable
    private Noise2D gapNoise = null;
    @Nullable
    private Noise2D scaleNoise = null;
    @Nullable
    private World lastWorld = null;

    @Override
    protected void doGeneration(@NotNull World world, @NotNull Random random, int chunkX, int chunkZ, int baseChunkX, int baseChunkZ, @NotNull ChunkGeneratorResult result) {
        if (this.chunkNoise == null || this.gapNoise == null || this.scaleNoise == null || this.lastWorld != world) {
            this.chunkNoise = new WorleyNoise(new Random(world.getRandomSeed()));
            this.gapNoise = new FractalNoise2D((Noise2D[])ImprovedPerlinNoise.genOctaves(world.getRandomSeed(), 4));
            this.scaleNoise = new Normalize2D<FractalNoise2D>(new FractalNoise2D((Noise2D[])ImprovedPerlinNoise.genOctaves(world.getRandomSeed(), 2)));
            this.lastWorld = world;
        }
        @NotNull WorldType worldType = world.getWorldType();
        int oceanY = worldType.getMinY(world) + worldType.getOceanY();
        @NotNull TilePos tilePos = new TilePos();
        @NotNull WorleyNoise.Result worleyResult = new WorleyNoise.Result();
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                tilePos.set(16 * baseChunkX + x, oceanY, 16 * baseChunkZ + z);
                @NotNull Biome biome = world.getBlockBiome(tilePos);
                if (biome != Biomes.NETHER_SHELF) continue;
                this.chunkNoise.getValue((double)((float)baseChunkX + (float)x / 16.0f), (double)((float)baseChunkZ + (float)z / 16.0f), worleyResult);
                int heightMod = worleyResult.getRandom().nextInt(5) + 1;
                for (int y = oceanY - 20; y < oceanY + heightMod; ++y) {
                    this.trySetBlock(result, x, y, z, Blocks.BRIMSAND.id());
                }
            }
        }
    }

    private void trySetBlock(@NotNull ChunkGeneratorResult result, int x, int y, int z, int id) {
        int current = result.getBlock(x, y, z);
        if (current == Blocks.FLUID_WATER_STILL.id() || current == 0) {
            result.setBlock(x, y, z, id);
        }
    }

    @Override
    public int getRadiusChunk() {
        return 0;
    }
}

