/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.generate.chunk;

import java.util.Random;
import net.minecraft.core.world.World;
import net.minecraft.core.world.chunk.Chunk;
import net.minecraft.core.world.generate.chunk.PlaceableFeature;
import org.jetbrains.annotations.NotNull;

public interface PlacementMethod {
    public void placeFeature(@NotNull PlaceableFeature var1, @NotNull World var2, @NotNull Chunk var3, @NotNull Random var4);

    public static class TriesPerChunk
    implements PlacementMethod {
        private final int tries;

        public TriesPerChunk(int tries) {
            this.tries = tries;
        }

        @Override
        public void placeFeature(@NotNull PlaceableFeature feature, @NotNull World world, @NotNull Chunk chunk, @NotNull Random random) {
            for (int i = 0; i < this.tries; ++i) {
                feature.placeFeature(world, chunk, random);
            }
        }
    }

    public static class ChanceToPlace
    implements PlacementMethod {
        private final int chance;

        public ChanceToPlace(int chance) {
            this.chance = chance;
        }

        @Override
        public void placeFeature(@NotNull PlaceableFeature feature, @NotNull World world, @NotNull Chunk chunk, @NotNull Random random) {
            if (random.nextInt(this.chance) == 0) {
                feature.placeFeature(world, chunk, random);
            }
        }
    }
}

