/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.generate.feature.weatherable.operation;

import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.world.generate.feature.weatherable.Operation;
import net.minecraft.core.world.structure.EditableStructure;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3i;
import org.joml.Vector3ic;

public class RotOperation
implements Operation {
    private static final int MAX_ITERATIONS = 100;

    @Override
    public void apply(@NotNull EditableStructure structure, @NotNull Random random) {
        int iterations = 0;
        @NotNull Vector3i queryPos = new Vector3i();
        Vector3ic size = structure.getSize();
        do {
            queryPos.set(random.nextInt(size.x()), random.nextInt(size.y()), random.nextInt(size.z()));
        } while (structure.getBlockType(queryPos) == Blocks.AIR && ++iterations < 100);
        if (iterations >= 100) {
            return;
        }
        if (this.canRot(structure.getBlockType(queryPos))) {
            structure.setBlockType(queryPos, Blocks.AIR);
        }
    }

    private boolean canRot(@NotNull Block<?> block) {
        return block == Blocks.PLANKS_OAK;
    }
}

