/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.entity;

import net.minecraft.client.render.block.model.BlockModel;
import net.minecraft.client.render.block.model.BlockModelDispatcher;
import net.minecraft.client.render.entity.EntityRenderer;
import net.minecraft.client.render.renderer.DrawMode;
import net.minecraft.client.render.renderer.GLRenderer;
import net.minecraft.client.render.renderer.Shaders;
import net.minecraft.client.render.tessellator.TessellatorGeneral;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogicChest;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.entity.vehicle.EntityMinecart;
import net.minecraft.core.util.helper.MathHelper;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3d;
import org.joml.Vector3dc;

public class EntityRendererMinecart
extends EntityRenderer<EntityMinecart> {
    public EntityRendererMinecart() {
        super(0.5f);
    }

    @Override
    public void render(@NotNull TessellatorGeneral tessellator, @NotNull EntityMinecart minecart, double x, double y, double z, float yaw, float partialTick) {
        GLRenderer.pushFrame();
        double lerpX = MathHelper.lerp(minecart.xo, minecart.x, (double)partialTick);
        double lerpY = MathHelper.lerp(minecart.yo, minecart.y, (double)partialTick);
        double lerpZ = MathHelper.lerp(minecart.zo, minecart.z, (double)partialTick);
        Vector3dc pos = minecart.getPos(lerpX, lerpY, lerpZ);
        double lerpXRot = MathHelper.lerp(minecart.xRotO, minecart.xRot, partialTick);
        double renderX = x;
        double renderY = y;
        double renderZ = z;
        double renderYaw = yaw;
        boolean doAFlip = false;
        if (pos != null) {
            Vector3d realVecVec;
            double scalar = 0.3;
            Vector3dc forVec = minecart.getPosOffs(lerpX, lerpY, lerpZ, 0.3);
            Vector3dc backVec = minecart.getPosOffs(lerpX, lerpY, lerpZ, -0.3);
            if (forVec == null) {
                forVec = pos;
            }
            if (backVec == null) {
                backVec = pos;
            }
            renderX += pos.x() - lerpX;
            renderY += (forVec.y() + backVec.y()) / 2.0 - lerpY;
            renderZ += pos.z() - lerpZ;
            Vector3d velVec = backVec.add(-forVec.x(), -forVec.y(), -forVec.z(), new Vector3d());
            if (velVec.length() != 0.0) {
                velVec.normalize();
                renderYaw = Math.toDegrees(Math.atan2(velVec.z, velVec.x));
                lerpXRot = Math.atan(velVec.y) * 73.0;
            }
            doAFlip = velVec.dot(realVecVec = new Vector3d(minecart.xd, minecart.yd, minecart.zd)) < 0.0;
        }
        GLRenderer.modelM4f().translate((float)renderX, (float)renderY, (float)renderZ);
        GLRenderer.modelM4f().rotateY((float)org.joml.Math.toRadians(180.0 - renderYaw));
        GLRenderer.modelM4f().rotateZ((float)org.joml.Math.toRadians(-lerpXRot));
        double hurtAngle = (float)minecart.timeSinceHit - partialTick;
        double currentDamage = (float)minecart.currentDamage - partialTick;
        if (currentDamage < 0.0) {
            currentDamage = 0.0;
        }
        if (hurtAngle > 0.0) {
            GLRenderer.modelM4f().rotateX((float)org.joml.Math.toRadians(Math.sin(hurtAngle) * hurtAngle * currentDamage / 10.0 * (double)minecart.hurtDirection));
        }
        if (minecart.getType() != 0) {
            TextureRegistry.worldAtlas.bind();
            float scale = 0.75f;
            GLRenderer.modelM4f().scale(0.75f, 0.75f, 0.75f);
            GLRenderer.modelM4f().translate(0.0f, 0.3125f, 0.0f);
            GLRenderer.modelM4f().rotateY(1.5707964f);
            GLRenderer.setLightmapCoord1i(minecart.getLightIndex(partialTick));
            GLRenderer.pushFrame();
            if (doAFlip) {
                GLRenderer.modelM4f().rotateY((float)Math.PI);
            }
            switch (minecart.getType()) {
                case 1: {
                    Block<BlockLogicChest> block = (minecart.getMeta() & 1) != 0 ? Blocks.CHEST_PLANKS_OAK_PAINTED : Blocks.CHEST_PLANKS_OAK;
                    ((BlockModel)BlockModelDispatcher.getInstance().getDispatch(block)).renderStandalone(tessellator, minecart.getMeta(), minecart.getLightIndex(partialTick));
                    break;
                }
                case 2: {
                    if (minecart.getFuel() > 0) {
                        ((BlockModel)BlockModelDispatcher.getInstance().getDispatch(Blocks.FURNACE_STONE_ACTIVE)).renderStandalone(tessellator, 0, minecart.getLightIndex(partialTick));
                        break;
                    }
                    ((BlockModel)BlockModelDispatcher.getInstance().getDispatch(Blocks.FURNACE_STONE_IDLE)).renderStandalone(tessellator, 0, minecart.getLightIndex(partialTick));
                }
            }
            GLRenderer.popFrame();
            GLRenderer.modelM4f().rotateY(-1.5707964f);
            GLRenderer.modelM4f().translate(0.0f, -0.3125f, 0.0f);
            GLRenderer.modelM4f().scale(1.3333334f, 1.3333334f, 1.3333334f);
        }
        this.bindTexture("/assets/minecraft/textures/entity/cart.png");
        GLRenderer.modelM4f().scale(0.0625f, 0.0625f, -0.0625f);
        this.getModel("main").render();
        GLRenderer.popFrame();
    }

    private static void drawDebugVec(@NotNull TessellatorGeneral tessellator, @NotNull Vector3dc start, @NotNull Vector3dc end, double scale, float r, float g, float b, float a) {
        GLRenderer.globalSetLightEnabled(false);
        GLRenderer.pushFrame();
        GLRenderer.setShader(Shaders.LINES);
        GLRenderer.setLineWidth(10.0f);
        tessellator.startDrawing(DrawMode.LINES);
        tessellator.setColor4f(r, g, b, a);
        tessellator.addVertex(start.x(), start.y(), start.z());
        tessellator.addVertex(start.x() + end.x() * scale, start.y() + end.y() * scale, start.z() + end.z() * scale);
        tessellator.draw();
        GLRenderer.popFrame();
        GLRenderer.globalSetLightEnabled(true);
    }
}

