/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.texture.stitcher;

import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import net.minecraft.client.render.texture.stitcher.AtlasStitcher;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.core.Global;
import net.minecraft.core.util.HardIllegalArgumentException;
import net.minecraft.core.util.collection.NamespaceID;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class TextureRegistry {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static List<AtlasStitcher> atlases = new ObjectArrayList<AtlasStitcher>();
    public static Map<String, AtlasStitcher> stitcherMap = new Object2ObjectOpenHashMap<String, AtlasStitcher>();
    public static final BufferedImage missingIconImage = new BufferedImage(16, 16, 2);
    public static AtlasStitcher worldAtlas;
    public static AtlasStitcher artAtlas;
    public static AtlasStitcher guiSpriteAtlas;
    public static AtlasStitcher signAtlas;
    private static final DateFormat dateFormat;
    private static final Map<String, String> atlasNameRemappings;

    @NotNull
    public static IconCoordinate getTexture(@NotNull String key) {
        try {
            return TextureRegistry.getTexture(NamespaceID.fromPool(key));
        }
        catch (HardIllegalArgumentException e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    public static IconCoordinate getTexture(@NotNull NamespaceID id) {
        int slashIndex = id.value().indexOf("/");
        String atlasId = id.value().substring(0, slashIndex);
        AtlasStitcher atlas = stitcherMap.get(atlasId);
        if (atlas == null) {
            throw new IllegalArgumentException("Failed to find atlas '" + atlasId + "'! From ID: " + String.valueOf(id));
        }
        return atlas.getTexture(id);
    }

    public static boolean hasTexture(@NotNull String key) {
        try {
            return TextureRegistry.hasTexture(NamespaceID.fromPool(key));
        }
        catch (HardIllegalArgumentException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean hasTexture(@NotNull NamespaceID id) {
        int slashIndex = id.value().indexOf("/");
        String atlasId = id.value().substring(0, slashIndex);
        AtlasStitcher atlas = stitcherMap.get(atlasId);
        if (atlas == null) {
            throw new IllegalArgumentException("Failed to find atlas '" + atlasId + "'! From ID: " + String.valueOf(id));
        }
        return atlas.iconMap.containsKey(id);
    }

    @NotNull
    public static AtlasStitcher register(@NotNull AtlasStitcher atlas) {
        for (String id : atlas.idDirMap.keySet()) {
            stitcherMap.put(id, atlas);
        }
        atlases.add(atlas);
        return atlas;
    }

    public static void initializeAllFiles(@NotNull String namespace, @NotNull AtlasStitcher atlas, boolean subDirectories) throws URISyntaxException, IOException, NullPointerException {
        atlas.initializeAll(namespace, subDirectories);
    }

    public static String[] getFilesAndSubFiles(String directory, boolean searchSubDirectories) throws IOException, URISyntaxException {
        Path myPath;
        URI uri;
        ArrayList<Object> paths = new ArrayList<Object>();
        if (!((String)directory).endsWith("/")) {
            directory = (String)directory + "/";
        }
        String[] dirs = ((String)directory).split("/");
        String currentDir = dirs[dirs.length - 1].replace("/", "");
        ArrayList<CallSite> subDirectories = new ArrayList<CallSite>();
        try {
            uri = Objects.requireNonNull(TextureRegistry.class.getResource((String)directory)).toURI();
        }
        catch (NullPointerException npe) {
            LOGGER.warn("Failed to load directory '{}'! Skipping!", directory);
            return new String[0];
        }
        FileSystem fileSystem = null;
        if (uri.getScheme().equals("jar")) {
            fileSystem = FileSystems.newFileSystem(uri, Collections.emptyMap());
            myPath = fileSystem.getPath((String)directory, new String[0]);
        } else {
            myPath = Paths.get(uri);
        }
        Stream<Path> walk = Files.walk(myPath, 1, new FileVisitOption[0]);
        Iterator it = walk.iterator();
        while (it.hasNext()) {
            Path path = (Path)it.next();
            String name = path.getFileName().toString();
            if (name.contains(".")) {
                if (!name.endsWith(".png")) continue;
                paths.add(name);
                continue;
            }
            if (!searchSubDirectories || name.replace("/", "").equals(currentDir)) continue;
            subDirectories.add((CallSite)((Object)((String)directory + name)));
        }
        walk.close();
        if (fileSystem != null) {
            fileSystem.close();
        }
        if (searchSubDirectories) {
            for (String string : subDirectories) {
                String[] files;
                for (String f : files = TextureRegistry.getFilesAndSubFiles(string, searchSubDirectories)) {
                    paths.add(string.replaceFirst((String)directory, "") + "/" + f);
                }
            }
        }
        return paths.toArray(new String[0]);
    }

    public static void dumpTilesToFolder(@NotNull File folder) {
        for (Map.Entry<String, AtlasStitcher> stitcherEntry : stitcherMap.entrySet()) {
            try {
                AtlasStitcher stitcher = stitcherEntry.getValue();
                File tileFile = new File(folder, atlasNameRemappings.getOrDefault(stitcherEntry.getKey(), stitcherEntry.getKey()) + ".tiles");
                tileFile.createNewFile();
                try (FileWriter writer = new FileWriter(tileFile);){
                    writer.append("# Auto generated tiles mapping for atlas '").append(stitcherEntry.getKey()).append("'\n");
                    writer.append("# generated for version '").append(Global.VERSION).append("' at '").append(dateFormat.format(new Date())).append("'\n");
                    writer.append("size=").append(Integer.toString(stitcher.getAtlasWidth())).append("x").append(Integer.toString(stitcher.getAtlasHeight())).append("\n");
                    for (Map.Entry<NamespaceID, IconCoordinate> entry : stitcher.iconMap.entrySet()) {
                        IconCoordinate coordinate = entry.getValue();
                        writer.append(Integer.toString(coordinate.iconX)).append(",").append(Integer.toString(coordinate.iconY));
                        writer.append("=");
                        writer.append(entry.getKey().value());
                        writer.append(" <").append(Integer.toString(coordinate.width)).append(",").append(Integer.toString(coordinate.height)).append(">");
                        writer.append("\n");
                    }
                }
                catch (IOException e) {
                    LOGGER.error("Failed to write tile map to file '{}'!", (Object)tileFile.getPath(), (Object)e);
                }
            }
            catch (IOException e) {
                LOGGER.error("Failed to create tile map for atlas '{}'!", (Object)stitcherEntry.getKey(), (Object)e);
            }
        }
    }

    static {
        for (int x = 0; x < 16; ++x) {
            for (int y = 0; y < 16; ++y) {
                if ((x / 8 + y / 8 & 1) == 0) {
                    missingIconImage.setRGB(x, y, -65281);
                    continue;
                }
                missingIconImage.setRGB(x, y, -16777216);
            }
        }
        worldAtlas = TextureRegistry.register(new AtlasStitcher(false, true).addDirectory("block", "textures/block").addDirectory("item", "textures/item").addDirectory("particle", "textures/particle").addLayer("maskColor", "cmask", -1).addLayer("emissive", "emiss", 0));
        artAtlas = TextureRegistry.register(new AtlasStitcher(false, true).addDirectory("art", "textures/art"));
        guiSpriteAtlas = TextureRegistry.register(new AtlasStitcher(true, false).addDirectory("gui", "textures/gui/sprites"));
        signAtlas = TextureRegistry.register(new AtlasStitcher(false, false).addDirectory("sign", "textures/gui/sign"));
        try {
            for (AtlasStitcher stitcher : atlases) {
                TextureRegistry.initializeAllFiles("minecraft", stitcher, stitcher != artAtlas);
            }
        }
        catch (Exception e) {
            LOGGER.warn("Failed to fully initialize assets, some issue may occur!", e);
        }
        dateFormat = new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss");
        atlasNameRemappings = new HashMap<String, String>();
        atlasNameRemappings.put("block", "terrain");
        atlasNameRemappings.put("item", "items");
    }
}

