/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.generate.feature.weatherable.operation;

import java.util.Random;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.world.generate.feature.weatherable.Operation;
import net.minecraft.core.world.structure.EditableStructure;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3i;
import org.joml.Vector3ic;

public class CrumbleOperation
implements Operation {
    private static final int MAX_ITERATIONS = 100;

    @Override
    public void apply(@NotNull EditableStructure structure, @NotNull Random random) {
        int iterations = 0;
        @NotNull Vector3i queryPos = new Vector3i();
        Vector3ic size = structure.getSize();
        int x = 0;
        int y = 0;
        int z = 0;
        while (structure.getBlockType(queryPos.set(x = random.nextInt(size.x()), y = random.nextInt(size.y()), z = random.nextInt(size.z()))) == Blocks.AIR && ++iterations < 100) {
        }
        if (iterations >= 100) {
            return;
        }
        int toCrumble = random.nextInt(5);
        int i = 0;
        while (structure.getBlockType(queryPos.set(x, y + toCrumble + i, z)) != Blocks.AIR) {
            structure.setBlockTypeData(new Vector3i(x, y + i, z), structure.getBlockType(queryPos.set(x, y + toCrumble + i, z)), structure.getBlockData(queryPos));
            ++i;
        }
        for (int j = 0; j < toCrumble; ++j) {
            structure.setBlockType(queryPos.set(x, y + i - j, z), Blocks.AIR);
        }
    }
}

