/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.generate.feature.weatherable.operation;

import java.util.Random;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.world.generate.feature.weatherable.Operation;
import net.minecraft.core.world.structure.EditableStructure;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3i;
import org.joml.Vector3ic;

public class FallOperation
implements Operation {
    @Override
    public void apply(@NotNull EditableStructure structure, @NotNull Random random) {
        @NotNull Vector3i queryPos = new Vector3i();
        Vector3ic size = structure.getSize();
        for (int x = 0; x < size.x(); ++x) {
            for (int y = 0; y < size.y(); ++y) {
                for (int z = 0; z < size.z(); ++z) {
                    if (!this.shouldFall(structure, queryPos.set(x, y, z))) continue;
                    this.fall(structure, queryPos);
                }
            }
        }
    }

    private boolean shouldFall(@NotNull EditableStructure structure, @NotNull Vector3ic pos) {
        @NotNull Vector3i queryPos = new Vector3i(pos);
        int total = 0;
        if (structure.getBlockType(pos.add(-1, 0, 0, queryPos)) != Blocks.AIR) {
            ++total;
        }
        if (structure.getBlockType(pos.add(1, 0, 0, queryPos)) != Blocks.AIR) {
            ++total;
        }
        if (structure.getBlockType(pos.add(0, -1, 0, queryPos)) != Blocks.AIR) {
            ++total;
        }
        if (structure.getBlockType(pos.add(0, 1, 0, queryPos)) != Blocks.AIR) {
            ++total;
        }
        if (structure.getBlockType(pos.add(0, 0, -1, queryPos)) != Blocks.AIR) {
            ++total;
        }
        if (structure.getBlockType(pos.add(0, 0, 1, queryPos)) != Blocks.AIR) {
            ++total;
        }
        return total < 3;
    }

    private void fall(@NotNull EditableStructure structure, @NotNull Vector3ic pos) {
        @NotNull Vector3i queryPos = new Vector3i(pos);
        int i = 1;
        while (structure.getBlockType(queryPos.set(pos.x(), pos.y() - i, pos.z())) == Blocks.AIR && pos.y() - i > 0) {
            ++i;
        }
        structure.setBlockTypeData(pos, structure.getBlockType(queryPos.set(pos.x(), pos.y() - i + 1, pos.z())), structure.getBlockData(queryPos));
    }
}

