/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model;

import net.minecraft.client.render.block.model.BlockModelStandard;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.block.BlockLogicChest;
import net.minecraft.core.util.helper.Axis;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.WorldSource;

public class BlockModelChest<T extends BlockLogic>
extends BlockModelStandard<T> {
    protected IconCoordinate chestFrontSingle;
    protected IconCoordinate chestFrontLeft;
    protected IconCoordinate chestFrontRight;
    protected IconCoordinate chestBackLeft;
    protected IconCoordinate chestBackRight;
    protected IconCoordinate chestTopLeft;
    protected IconCoordinate chestTopRight;
    protected IconCoordinate chestSide;
    protected IconCoordinate chestTop;

    public BlockModelChest(Block<T> block, String rootKey) {
        super(block);
        this.chestFrontSingle = TextureRegistry.getTexture(rootKey + "front");
        this.chestFrontLeft = TextureRegistry.getTexture(rootKey + "left_front");
        this.chestFrontRight = TextureRegistry.getTexture(rootKey + "right_front");
        this.chestTopLeft = TextureRegistry.getTexture(rootKey + "top_left");
        this.chestTopRight = TextureRegistry.getTexture(rootKey + "top_right");
        this.chestBackLeft = TextureRegistry.getTexture(rootKey + "left_back");
        this.chestBackRight = TextureRegistry.getTexture(rootKey + "right_back");
        this.chestSide = TextureRegistry.getTexture(rootKey + "side");
        this.chestTop = TextureRegistry.getTexture(rootKey + "top");
    }

    @Override
    public boolean render(Tessellator tessellator, int x, int y, int z) {
        int meta = BlockModelChest.renderBlocks.blockAccess.getBlockMetadata(x, y, z);
        Direction dir = BlockLogicChest.getDirectionFromMeta(meta);
        switch (dir) {
            case NORTH: {
                BlockModelChest.renderBlocks.uvRotateTop = 3;
                break;
            }
            case EAST: {
                BlockModelChest.renderBlocks.uvRotateTop = 2;
                break;
            }
            case WEST: {
                BlockModelChest.renderBlocks.uvRotateTop = 1;
            }
        }
        this.renderStandardBlock(tessellator, this.block.getBlockBoundsFromState(BlockModelChest.renderBlocks.blockAccess, x, y, z), x, y, z);
        this.resetRenderBlocks();
        return true;
    }

    @Override
    public IconCoordinate getBlockTexture(WorldSource blockAccess, int x, int y, int z, Side side) {
        int meta = blockAccess.getBlockMetadata(x, y, z);
        Side facing = BlockLogicChest.getDirectionFromMeta(meta).getSide();
        BlockLogicChest.Type type = BlockLogicChest.getTypeFromMeta(meta);
        if (side == Side.TOP) {
            if (type == BlockLogicChest.Type.RIGHT) {
                return this.chestTopRight;
            }
            if (type == BlockLogicChest.Type.LEFT) {
                return this.chestTopLeft;
            }
            return this.chestTop;
        }
        if (side == Side.BOTTOM) {
            return this.chestTop;
        }
        if (type == BlockLogicChest.Type.SINGLE && side == facing) {
            return this.chestFrontSingle;
        }
        if (type == BlockLogicChest.Type.LEFT) {
            if (side == facing) {
                return this.chestFrontLeft;
            }
            if (side == facing.getOpposite()) {
                return this.chestBackRight;
            }
        }
        if (type == BlockLogicChest.Type.RIGHT) {
            if (side == facing) {
                return this.chestFrontRight;
            }
            if (side == facing.getOpposite()) {
                return this.chestBackLeft;
            }
        }
        if (side.getAxis() != Axis.Y) {
            return this.chestSide;
        }
        return this.chestTop;
    }

    @Override
    public IconCoordinate getBlockTextureFromSideAndMetadata(Side side, int data) {
        if (side == Side.SOUTH) {
            return this.chestFrontSingle;
        }
        if (side.isHorizontal()) {
            return this.chestSide;
        }
        return this.chestTop;
    }
}

