/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.blockentity;

import net.minecraft.client.render.Lighting;
import net.minecraft.client.render.LightmapHelper;
import net.minecraft.client.render.RenderBlocks;
import net.minecraft.client.render.block.model.BlockModel;
import net.minecraft.client.render.block.model.BlockModelDispatcher;
import net.minecraft.client.render.blockentity.TileEntityRenderer;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.Global;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.entity.TileEntityFlowerJar;
import net.minecraft.core.enums.LightLayer;
import net.minecraft.core.world.World;
import org.lwjgl.opengl.GL11;

public class TileEntityRendererFlowerJar
extends TileEntityRenderer<TileEntityFlowerJar> {
    private RenderBlocks renderBlocks;

    @Override
    public void onWorldChanged(World world) {
        this.renderBlocks = new RenderBlocks(world);
    }

    @Override
    public void doRender(Tessellator tessellator, TileEntityFlowerJar tileEntity, double x, double y, double z, float renderPartialTicks) {
        GL11.glPushMatrix();
        Block<?> block = Blocks.getBlock(tileEntity.flowerInPot);
        if (block != null) {
            GL11.glTranslatef((float)((float)x), (float)((float)y), (float)((float)z));
            TextureRegistry.blockAtlas.bind();
            float scaleValue = 0.75f;
            GL11.glScalef((float)scaleValue, (float)scaleValue, (float)scaleValue);
            GL11.glTranslatef((float)0.66f, (float)0.75f, (float)0.66f);
            float lightLevel = this.renderBlocks.getBlockBrightness(tileEntity.worldObj, tileEntity.x, tileEntity.y, tileEntity.z);
            if (Global.accessor.isFullbrightEnabled()) {
                lightLevel = 1.0f;
            }
            BlockModel.setRenderBlocks(this.renderBlocks);
            Integer lmc = null;
            if (LightmapHelper.isLightmapEnabled()) {
                lmc = Global.accessor.isFullbrightEnabled() ? Integer.valueOf(LightmapHelper.getOverbrightLightmapCoord(tileEntity.worldObj.getSavedLightValue(LightLayer.Sky, tileEntity.x, tileEntity.y, tileEntity.z))) : Integer.valueOf(tileEntity.worldObj.getLightmapCoord(tileEntity.x, tileEntity.y, tileEntity.z, 0));
                lightLevel = 1.0f;
            }
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            if (LightmapHelper.isLightmapEnabled()) {
                Lighting.enableInventoryLight();
            }
            ((BlockModel)BlockModelDispatcher.getInstance().getDispatch(block)).renderBlockOnInventory(tessellator, tileEntity.flowerData, lightLevel, lmc);
            GL11.glDisable((int)3042);
            if (LightmapHelper.isLightmapEnabled()) {
                Lighting.disable();
            }
        }
        GL11.glPopMatrix();
    }
}

