/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.worldtype;

import net.minecraft.client.render.colorizer.Colorizers;
import net.minecraft.client.render.worldtype.WorldTypeFX;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.util.phys.Vec3;
import net.minecraft.core.world.World;
import net.minecraft.core.world.type.WorldType;

public class WorldTypeFXNether
extends WorldTypeFX {
    public WorldTypeFXNether(WorldType worldType) {
        super(worldType);
    }

    @Override
    public float[] getSunriseColor(float timeOfDay, float partialTick) {
        return new float[4];
    }

    @Override
    public Vec3 getFogColor(World world, double x, double y, double z, float celestialAngle, float partialTick) {
        if (Colorizers.fog.isEnabled()) {
            int x1 = MathHelper.floor(x);
            int y1 = MathHelper.floor(y);
            int z1 = MathHelper.floor(z);
            int color = Colorizers.fog.getColor(world, x1, y1, z1);
            float r = (float)(color >> 16 & 0xFF) / 255.0f;
            float g = (float)(color >> 8 & 0xFF) / 255.0f;
            float b = (float)(color & 0xFF) / 255.0f;
            return Vec3.getTempVec3(r, g, b);
        }
        return Vec3.getTempVec3(0.0, 0.0, 0.0);
    }
}

