/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.guidebook.trommeling;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.gui.guidebook.GuidebookPage;
import net.minecraft.client.gui.guidebook.GuidebookSection;
import net.minecraft.client.gui.guidebook.SearchableGuidebookSection;
import net.minecraft.client.gui.guidebook.trommeling.RecipePageTrommel;
import net.minecraft.core.data.registry.Registries;
import net.minecraft.core.data.registry.recipe.SearchQuery;
import net.minecraft.core.data.registry.recipe.entry.RecipeEntryTrommel;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.collection.Pair;
import net.minecraft.core.util.helper.MathHelper;

public class GuidebookSectionTrommel
extends SearchableGuidebookSection {
    private final List<GuidebookPage> pages = new ArrayList<GuidebookPage>();
    private Pair<String, List<GuidebookPage>> filteredPages = null;

    public GuidebookSectionTrommel(String translationKey, ItemStack tabIcon, int bgColor, int fgColor) {
        super(translationKey, tabIcon, bgColor, fgColor);
        this.reloadRecipes();
    }

    @Override
    public List<GuidebookPage> searchPages(SearchQuery query) {
        if (this.filteredPages == null || !Objects.equals(this.filteredPages.getLeft(), query.rawQuery)) {
            ArrayList<RecipeEntryTrommel> filteredRecipes = new ArrayList<RecipeEntryTrommel>();
            ArrayList<RecipeEntryTrommel> allRecipes = new ArrayList<RecipeEntryTrommel>(Registries.RECIPES.getAllTrommelRecipes());
            for (RecipeEntryTrommel recipe : allRecipes) {
                if (!recipe.matchesQueryIgnoreExceptions(query)) continue;
                filteredRecipes.add(recipe);
            }
            ArrayList<GuidebookPage> filteredPages = new ArrayList<GuidebookPage>();
            int filteredRecipeSize = filteredRecipes.size();
            int filteredPageCount = MathHelper.ceilInt(filteredRecipeSize, 3);
            for (int i = 0; i < filteredPageCount; ++i) {
                int j = i * 3;
                ArrayList<RecipeEntryTrommel> recipes = new ArrayList<RecipeEntryTrommel>(filteredRecipes.subList(j, Math.min(Math.min(j, filteredRecipeSize) + 3, filteredRecipeSize)));
                if (recipes.size() <= 0) continue;
                filteredPages.add(new RecipePageTrommel(this, recipes));
            }
            this.filteredPages = Pair.of(query.rawQuery, filteredPages);
            return filteredPages;
        }
        return this.filteredPages.getRight();
    }

    public void reloadRecipes() {
        this.pages.clear();
        ArrayList<RecipeEntryTrommel> allRecipes = new ArrayList<RecipeEntryTrommel>(Registries.RECIPES.getAllTrommelRecipes());
        int totalRecipes = allRecipes.size();
        int totalPages = MathHelper.ceilInt(totalRecipes, 3);
        for (int i = 0; i < totalPages; ++i) {
            int j = i * 3;
            ArrayList<RecipeEntryTrommel> recipes = new ArrayList<RecipeEntryTrommel>(allRecipes.subList(Math.min(j, totalRecipes), Math.min(j + 3, totalRecipes)));
            this.pages.add(new RecipePageTrommel(this, recipes));
        }
    }

    @Override
    public List<GuidebookPage> getPages() {
        return this.pages;
    }

    @Override
    public List<GuidebookSection.Index> getIndices() {
        return null;
    }
}

