/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model;

import net.minecraft.client.render.block.color.BlockColor;
import net.minecraft.client.render.block.color.BlockColorDispatcher;
import net.minecraft.client.render.block.model.BlockModelStandard;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.util.phys.AABB;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL11;

public class BlockModelStoneMossy<T extends BlockLogic>
extends BlockModelStandard<T> {
    protected IconCoordinate mossOverlay = TextureRegistry.getTexture("minecraft:block/moss_overlay");

    public BlockModelStoneMossy(Block<T> block) {
        super(block);
    }

    @Override
    public boolean render(Tessellator tessellator, int x, int y, int z) {
        AABB bounds = this.block.getBlockBoundsFromState(BlockModelStoneMossy.renderBlocks.blockAccess, x, y, z);
        this.renderStandardBlock(tessellator, bounds, x, y, z, 1.0f, 1.0f, 1.0f);
        BlockModelStoneMossy.renderBlocks.overrideBlockTexture = this.mossOverlay;
        this.renderStandardBlock(tessellator, bounds, x, y, z);
        BlockModelStoneMossy.renderBlocks.overrideBlockTexture = null;
        return true;
    }

    @Override
    public void renderBlockOnInventory(Tessellator tessellator, int metadata, float brightness, float alpha, @Nullable Integer lightmapCoordinate) {
        BlockModelStoneMossy.renderBlocks.useInventoryTint = false;
        super.renderBlockOnInventory(tessellator, metadata, brightness, alpha, lightmapCoordinate);
        BlockModelStoneMossy.renderBlocks.useInventoryTint = true;
        GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
        int color = ((BlockColor)BlockColorDispatcher.getInstance().getDispatch(this.block)).getFallbackColor(metadata);
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        GL11.glColor4f((float)(r * brightness), (float)(g * brightness), (float)(b * brightness), (float)alpha);
        AABB bounds = this.block.getBounds();
        IconCoordinate mossCoord = this.mossOverlay;
        tessellator.startDrawingQuads();
        tessellator.setNormal(0.0f, -1.0f, 0.0f);
        this.renderBottomFace(tessellator, bounds, 0.0, 0.0, 0.0, mossCoord);
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setNormal(0.0f, 1.0f, 0.0f);
        this.renderTopFace(tessellator, bounds, 0.0, 0.0, 0.0, mossCoord);
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setNormal(0.0f, 0.0f, -1.0f);
        this.renderNorthFace(tessellator, bounds, 0.0, 0.0, 0.0, mossCoord);
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setNormal(0.0f, 0.0f, 1.0f);
        this.renderSouthFace(tessellator, bounds, 0.0, 0.0, 0.0, mossCoord);
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setNormal(-1.0f, 0.0f, 0.0f);
        this.renderWestFace(tessellator, bounds, 0.0, 0.0, 0.0, mossCoord);
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setNormal(1.0f, 0.0f, 0.0f);
        this.renderEastFace(tessellator, bounds, 0.0, 0.0, 0.0, mossCoord);
        tessellator.draw();
        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
    }
}

