/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.terrain;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.render.RenderBlocks;
import net.minecraft.client.render.block.model.BlockModel;
import net.minecraft.client.render.camera.ICamera;
import net.minecraft.client.render.culling.CameraFrustum;
import net.minecraft.client.render.entity.EntityRendererItem;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.world.World;
import org.lwjgl.opengl.GL11;

public abstract class ChunkRenderer {
    public static final int MAX_RENDER_PASSES = 2;
    public static int updates = 0;
    public World world;
    protected final int lists;
    public int posX;
    public int posY;
    public int posZ;
    public int sizeX;
    public int sizeY;
    public int sizeZ;
    public int xRender;
    public int yRender;
    public int zRender;
    public int xRenderOffs;
    public int yRenderOffs;
    public int zRenderOffs;
    public boolean visible = false;
    public boolean[] empty = new boolean[2];
    public int xm;
    public int ym;
    public int zm;
    public float radius;
    public boolean dirty;
    public AABB bb;
    public int id;
    public boolean occlusionVisible = true;
    public boolean occlusionQuerying;
    public int occlusionId;
    public boolean skyLit;
    protected boolean compiled = false;
    public List<TileEntity> renderableBlockEntities = new ArrayList<TileEntity>();
    protected final List<TileEntity> globalRenderableBlockEntities;

    public ChunkRenderer(World world, List<TileEntity> globalRenderableTileEntities, int x, int y, int z, int size, int lists) {
        this.world = world;
        this.globalRenderableBlockEntities = globalRenderableTileEntities;
        this.sizeY = this.sizeZ = size;
        this.sizeX = this.sizeZ;
        this.radius = MathHelper.sqrt_float(this.sizeX * this.sizeX + this.sizeY * this.sizeY + this.sizeZ * this.sizeZ) / 2.0f;
        this.lists = lists;
        this.posX = -999;
        this.setPos(x, y, z);
        this.dirty = false;
    }

    public void setPos(int x, int y, int z) {
        if (x != this.posX || y != this.posY || z != this.posZ) {
            this.reset();
            this.posX = x;
            this.posY = y;
            this.posZ = z;
            this.xm = x + this.sizeX / 2;
            this.ym = y + this.sizeY / 2;
            this.zm = z + this.sizeZ / 2;
            this.xRenderOffs = x & 0x3FF;
            this.yRenderOffs = y;
            this.zRenderOffs = z & 0x3FF;
            this.xRender = x - this.xRenderOffs;
            this.yRender = y - this.yRenderOffs;
            this.zRender = z - this.zRenderOffs;
            float f = 6.0f;
            this.bb = AABB.getPermanentBB((float)x - f, (float)y - f, (float)z - f, (float)(x + this.sizeX) + f, (float)(y + this.sizeY) + f, (float)(z + this.sizeZ) + f);
            GL11.glNewList((int)(this.lists + 2), (int)4864);
            EntityRendererItem.renderFlatAABB(AABB.getTemporaryBB((float)this.xRenderOffs - f, (float)this.yRenderOffs - f, (float)this.zRenderOffs - f, (float)(this.xRenderOffs + this.sizeX) + f, (float)(this.yRenderOffs + this.sizeY) + f, (float)(this.zRenderOffs + this.sizeZ) + f));
            GL11.glEndList();
            this.setDirty();
        }
    }

    public abstract void rebuild();

    public boolean renderBlock(Tessellator tessellator, RenderBlocks renderBlocks, BlockModel<?> model, int x, int y, int z) {
        boolean rendered = false;
        rendered |= model.render(tessellator, x, y, z);
        if (model.hasOverbright()) {
            renderBlocks.overbright = true;
            rendered |= model.render(tessellator, x, y, z);
            renderBlocks.overbright = false;
        }
        return rendered;
    }

    protected void translateToPos() {
        GL11.glTranslatef((float)this.xRenderOffs, (float)this.yRenderOffs, (float)this.zRenderOffs);
    }

    public float distanceToEntitySquared(Entity entity) {
        float dx = (float)(entity.x - (double)this.xm);
        float dy = (float)(entity.y - (double)this.ym);
        float dz = (float)(entity.z - (double)this.zm);
        return dx * dx + dy * dy + dz * dz;
    }

    public float distanceToCameraSquared(ICamera camera) {
        float dx = (float)(camera.getX(1.0f) - (double)this.xm);
        float dy = (float)(camera.getY(1.0f) - (double)this.ym);
        float dz = (float)(camera.getZ(1.0f) - (double)this.zm);
        return dx * dx + dy * dy + dz * dz;
    }

    public void reset() {
        for (int i = 0; i < 2; ++i) {
            this.empty[i] = true;
        }
        this.visible = false;
        this.compiled = false;
    }

    public void delete() {
        this.reset();
        this.world = null;
    }

    public int getList(int layer) {
        if (!this.visible) {
            return -1;
        }
        if (!this.empty[layer]) {
            return this.lists + layer;
        }
        return -1;
    }

    public void cull(CameraFrustum frustum, float partialTick) {
        this.visible = frustum.isVisible(this.bb, partialTick);
    }

    public void renderBB() {
        GL11.glCallList((int)(this.lists + 2));
    }

    public boolean isEmpty() {
        if (!this.compiled) {
            return false;
        }
        return this.empty[0] && this.empty[1];
    }

    public void setDirty() {
        this.dirty = true;
    }
}

