/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import net.minecraft.client.gui.Screen;
import net.minecraft.client.gui.popup.PopupBuilder;
import net.minecraft.client.gui.popup.PopupScreen;
import net.minecraft.core.block.entity.TileEntityMobSpawner;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.EntityDispatcher;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.entity.animal.MobFireflyCluster;
import net.minecraft.core.net.packet.PacketSetMobSpawner;
import net.minecraft.core.util.collection.NamespaceID;

public class ScreenMobPicker
extends Screen {
    private final int x;
    private final int y;
    private final int z;
    private String mobId;
    private boolean shouldClose = false;

    public ScreenMobPicker(String mobId, int x, int y, int z) {
        this.mobId = mobId;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    @Override
    public void init() {
        ArrayList<NamespaceID> monsters = new ArrayList<NamespaceID>();
        for (Class<? extends Entity> clazz : EntityDispatcher.classToIdMap.keySet()) {
            if (clazz == MobFireflyCluster.class || !Mob.class.isAssignableFrom(clazz) || Modifier.isAbstract(clazz.getModifiers())) continue;
            monsters.add(EntityDispatcher.classToIdMap.get(clazz));
        }
        Collections.sort(monsters);
        ArrayList<String> prettyMonsters = new ArrayList<String>();
        for (NamespaceID monster : monsters) {
            StringBuilder sb = new StringBuilder();
            for (char c : monster.value.toCharArray()) {
                if (Character.isUpperCase(c)) {
                    sb.append(' ');
                }
                sb.append(c);
            }
            prettyMonsters.add(sb.toString());
        }
        PopupScreen popup = new PopupBuilder(this, 150).withLabel("gui.pick_monster.label.title").withList("list", 140, prettyMonsters.toArray(new String[0]), null, -1, true).closeOnEsc(0).closeOnClickOut(0).withOnCloseListener((statusCode, results) -> {
            if (statusCode == 1) {
                this.mobId = ((NamespaceID)monsters.get((Integer)results.get("list"))).toString();
                if (!this.mc.currentWorld.isClientSide) {
                    TileEntityMobSpawner spawner = (TileEntityMobSpawner)this.mc.currentWorld.getBlockEntity(this.x, this.y, this.z);
                    if (spawner == null) {
                        return;
                    }
                    spawner.setMobId(this.mobId);
                } else {
                    this.mc.getSendQueue().addToSendQueue(new PacketSetMobSpawner(this.x, this.y, this.z, EntityDispatcher.classForId(this.mobId)));
                }
            }
            this.shouldClose = true;
        }).build();
        this.mc.displayScreen(popup);
    }

    @Override
    public void tick() {
        super.tick();
        if (this.shouldClose) {
            this.mc.displayScreen(null);
        }
    }

    public String getMobId() {
        return this.mobId;
    }
}

