/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.guidebook.crafting.displays;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.client.gui.guidebook.SlotGuidebook;
import net.minecraft.client.gui.guidebook.crafting.displays.RecipeDisplayAdapter;
import net.minecraft.core.data.registry.recipe.RecipeEntryBase;
import net.minecraft.core.data.registry.recipe.RecipeSymbol;
import net.minecraft.core.data.registry.recipe.entry.RecipeEntryCraftingWithTool;
import net.minecraft.core.item.ItemStack;

public class DisplayAdapterTool
implements RecipeDisplayAdapter<RecipeEntryCraftingWithTool> {
    @Override
    public List<SlotGuidebook> getSlots(RecipeEntryCraftingWithTool recipe, int recipeAmount, int xOffset, int yOffset) {
        ArrayList<SlotGuidebook> recipeSlots = new ArrayList<SlotGuidebook>();
        RecipeSymbol[] symbols = new RecipeSymbol[]{recipe.inputSymbol, recipe.toolToUse, null, null, new RecipeSymbol(recipe.output)};
        for (int i = 0; i < 4; ++i) {
            int x = 13 + 18 * (i % 2) + xOffset;
            int y = 10 + 18 * (i / 2 + recipeAmount * 3) + yOffset;
            SlotGuidebook slot = symbols[i] == recipe.toolToUse ? new SlotGuidebookTool(i, x, y, symbols[i], false, recipe) : new SlotGuidebook(i, x, y, symbols[i], false, recipe);
            recipeSlots.add(slot);
        }
        int centerY = (((SlotGuidebook)recipeSlots.get((int)(recipeSlots.size() - 1))).y + ((SlotGuidebook)recipeSlots.get((int)(recipeSlots.size() - 3))).y) / 2;
        recipeSlots.add(new SlotGuidebook(symbols.length - 1, 81 + xOffset, centerY, symbols[4], false, recipe).setAsOutput());
        return recipeSlots;
    }

    public static class SlotGuidebookTool
    extends SlotGuidebook {
        public SlotGuidebookTool(int id, int x, int y, RecipeSymbol symbol, boolean discovered, RecipeEntryBase<?, ?, ?> recipe) {
            super(id, x, y, symbol, discovered, recipe);
        }

        @Override
        public void showRandomItem() {
            Random r = new Random();
            if (this.symbol != null && this.symbol.getItemGroup() != null) {
                List<ItemStack> list = this.symbol.resolve();
                ItemStack newItem = list.get(r.nextInt(list.size()));
                if (list.size() > 1) {
                    while (newItem == this.item) {
                        newItem = list.get(r.nextInt(list.size()));
                    }
                }
                this.item = newItem;
            }
            this.item.setMetadata(r.nextInt(this.item.getMaxDamage()));
        }
    }
}

