/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.popup;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.Screen;
import net.minecraft.client.gui.popup.InteractivePopupComponent;
import net.minecraft.client.gui.popup.PopupCloseListener;
import net.minecraft.client.gui.popup.PopupComponent;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.core.util.collection.Pair;
import net.minecraft.core.util.helper.Color;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

public final class PopupScreen
extends Screen {
    static final int HORIZONTAL_MARGIN = 8;
    static final int VERTICAL_MARGIN = 8;
    static final int COMPONENT_GAP = 4;
    private final Screen parent;
    private final int popupWidth;
    private final int popupHeight;
    private final Integer statusCodeOnEsc;
    private final Integer statusCodeOnEnter;
    private final Integer statusCodeOnClickOut;
    private final List<PopupComponent> components;
    private final Map<PopupComponent, String> componentKeyMap;
    private final List<PopupCloseListener> onCloseListeners;
    private final Pair<Integer, Integer> backgroundColor;
    private int statusCode = -1;

    PopupScreen(Screen parent, int width, int height, Integer statusCodeOnEsc, Integer statusCodeOnEnter, Integer statusCodeOnClickOut, List<PopupComponent> components, Map<PopupComponent, String> componentKeyMap, List<PopupCloseListener> onCloseListeners, Pair<Integer, Integer> backgroundColor) {
        this.parent = parent;
        this.popupWidth = width;
        this.popupHeight = height;
        this.statusCodeOnEsc = statusCodeOnEsc;
        this.statusCodeOnEnter = statusCodeOnEnter;
        this.statusCodeOnClickOut = statusCodeOnClickOut;
        this.components = components;
        this.componentKeyMap = componentKeyMap;
        this.onCloseListeners = onCloseListeners;
        this.backgroundColor = backgroundColor;
    }

    void close(int statusCode) {
        this.statusCode = statusCode;
        this.removed();
        this.mc.currentScreen = this.parent;
    }

    @Override
    public void tick() {
        super.tick();
        for (PopupComponent component : this.components) {
            component.tick();
        }
    }

    @Override
    public void removed() {
        super.removed();
        HashMap results = new HashMap();
        for (Map.Entry<PopupComponent, String> entry : this.componentKeyMap.entrySet()) {
            if (!(entry.getKey() instanceof InteractivePopupComponent)) continue;
            Object value = ((InteractivePopupComponent)entry.getKey()).getOutput();
            results.put(entry.getValue(), value);
        }
        for (PopupCloseListener listener : this.onCloseListeners) {
            listener.onClosed(this.statusCode, results);
        }
    }

    @Override
    public void init() {
        if (this.parent.width != this.width || this.parent.height != this.height) {
            this.parent.width = this.width;
            this.parent.height = this.height;
            this.parent.buttons.clear();
            this.parent.init();
        }
        super.init();
    }

    @Override
    public void keyPressed(char eventCharacter, int eventKey, int mx, int my) {
        if (eventKey == Keyboard.KEY_ESCAPE && this.statusCodeOnEsc != null) {
            this.close(this.statusCodeOnEsc);
        }
        if (eventKey == Keyboard.KEY_RETURN && this.statusCodeOnEnter != null) {
            this.close(this.statusCodeOnEnter);
        }
        for (PopupComponent component : this.components) {
            component.onKeyDown(eventKey, eventCharacter);
        }
    }

    @Override
    public void mouseClicked(int mx, int my, int buttonNum) {
        if (this.statusCodeOnClickOut != null) {
            int popupX = this.width / 2 - this.popupWidth / 2;
            int popupY = this.height / 2 - this.popupHeight / 2;
            if (mx < popupX || mx > popupX + this.popupWidth || my < popupY || my > popupY + this.popupHeight) {
                this.close(this.statusCodeOnClickOut);
            }
        }
        super.mouseClicked(mx, my, buttonNum);
        for (PopupComponent component : this.components) {
            component.onClick(mx, my, buttonNum);
        }
    }

    @Override
    public void mouseReleased(int mx, int my, int buttonNum) {
        super.mouseReleased(mx, my, buttonNum);
        for (PopupComponent component : this.components) {
            component.mouseMovedOrUp(mx, my, buttonNum);
        }
    }

    @Override
    public void render(int mx, int my, float partialTick) {
        int popupX = this.width / 2 - this.popupWidth / 2;
        int popupY = this.height / 2 - this.popupHeight / 2;
        this.parent.render(-1, -1, partialTick);
        this.drawPopupBackground();
        int accY = popupY + 8;
        for (PopupComponent component : this.components) {
            component.render(popupX + 8, accY, mx, my);
            accY += component.getHeight() + 4;
        }
        super.render(mx, my, partialTick);
    }

    private void drawPopupBackground() {
        int popupX = this.width / 2 - this.popupWidth / 2;
        int popupY = this.height / 2 - this.popupHeight / 2;
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2912);
        Tessellator tessellator = Tessellator.instance;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.backgroundColor == null) {
            int color = ((Color)this.mc.gameSettings.guiBackgroundColor.value).getARGB();
            this.drawGradientRect(0, 0, this.width, this.height, color, color);
        } else {
            this.drawGradientRect(0, 0, this.width, this.height, this.backgroundColor.getLeft(), this.backgroundColor.getRight());
        }
        this.drawRectWidthHeight(popupX - 1, popupY - 1, this.popupWidth + 2, this.popupHeight + 2, -6250336);
        GL11.glEnable((int)3553);
        float f = 32.0f;
        tessellator.startDrawingQuads();
        this.mc.textureManager.loadTexture("/assets/minecraft/textures/gui/background.png").bind();
        tessellator.setColorOpaque_I(0x404040);
        tessellator.addVertexWithUV(popupX, popupY + this.popupHeight, 0.0, 0.0, (float)this.popupHeight / f);
        tessellator.addVertexWithUV(popupX + this.popupWidth, popupY + this.popupHeight, 0.0, (float)this.popupWidth / f, (float)this.popupHeight / f);
        tessellator.addVertexWithUV(popupX + this.popupWidth, popupY, 0.0, (float)this.popupWidth / f, 0.0);
        tessellator.addVertexWithUV(popupX, popupY, 0.0, 0.0, 0.0);
        tessellator.draw();
    }
}

