/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render;

import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import net.minecraft.client.render.ImageParser;

public class PlayerSkinParser
implements ImageParser {
    public static final PlayerSkinParser instance = new PlayerSkinParser();
    private int[] imageData;
    private int width = 64;
    private int height = 64;

    @Override
    public BufferedImage parseImage(BufferedImage image) {
        if (image == null) {
            return null;
        }
        BufferedImage newImage = new BufferedImage(this.width, this.height, 2);
        Graphics g = newImage.getGraphics();
        g.drawImage(image, 0, 0, null);
        if (image.getHeight() == 32) {
            g.drawImage(image, 24, 52, 20, 64, 4, 20, 8, 32, null);
            g.drawImage(image, 32, 52, 28, 64, 12, 20, 16, 32, null);
            g.drawImage(image, 28, 52, 24, 64, 0, 20, 4, 32, null);
            g.drawImage(image, 20, 52, 16, 64, 8, 20, 12, 32, null);
            g.drawImage(image, 24, 48, 20, 52, 4, 16, 8, 20, null);
            g.drawImage(image, 28, 48, 24, 52, 8, 16, 12, 20, null);
            g.drawImage(image, 40, 52, 36, 64, 44, 20, 48, 32, null);
            g.drawImage(image, 48, 52, 44, 64, 52, 20, 56, 32, null);
            g.drawImage(image, 44, 52, 40, 64, 40, 20, 44, 32, null);
            g.drawImage(image, 36, 52, 32, 64, 48, 20, 52, 32, null);
            g.drawImage(image, 40, 48, 36, 52, 44, 16, 48, 20, null);
            g.drawImage(image, 44, 48, 40, 52, 48, 16, 52, 20, null);
        }
        g.dispose();
        this.imageData = ((DataBufferInt)newImage.getRaster().getDataBuffer()).getData();
        this.removeTransparency(0, 0, 32, 16);
        this.removeTransparency(0, 16, 64, 16);
        this.removeTransparency(16, 48, 32, 16);
        return newImage;
    }

    private void removeTransparency(int x1, int y1, int w2, int h2) {
        for (int x = x1; x < x1 + w2; ++x) {
            for (int y = y1; y < y1 + h2; ++y) {
                int n = x + y * this.width;
                this.imageData[n] = this.imageData[n] | 0xFF000000;
            }
        }
    }
}

