/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.entity;

import net.minecraft.client.render.entity.EntityRendererSprite;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.entity.EntityFishingBobber;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.util.phys.Vec3;
import org.lwjgl.opengl.GL11;

public class EntityRendererFishingBobber
extends EntityRendererSprite<EntityFishingBobber> {
    public EntityRendererFishingBobber() {
        super(TextureRegistry.getTexture("minecraft:particle/bobber"));
    }

    @Override
    public void render(Tessellator tessellator, EntityFishingBobber entity, double x, double y, double z, float yaw, float partialTick) {
        super.render(tessellator, entity, x, y, z, yaw, partialTick);
        if (entity.owner != null) {
            float f11 = entity.owner.getSwingProgress(partialTick);
            float f12 = MathHelper.sin(MathHelper.sqrt_float(f11) * (float)Math.PI);
            Vec3 vec3 = Vec3.getTempVec3(-0.5, 0.03, 0.8);
            vec3.rotateAroundX(-(entity.owner.xRotO + (entity.owner.xRot - entity.owner.xRotO) * partialTick) * (float)Math.PI / 180.0f);
            vec3.rotateAroundY(-(entity.owner.yRotO + (entity.owner.yRot - entity.owner.yRotO) * partialTick) * (float)Math.PI / 180.0f);
            vec3.rotateAroundY(f12 * 0.5f);
            vec3.rotateAroundX(-f12 * 0.7f);
            double xp = entity.owner.xo + (entity.owner.x - entity.owner.xo) * (double)partialTick + vec3.x;
            double yp = entity.owner.yo + (entity.owner.y - entity.owner.yo) * (double)partialTick + vec3.y;
            double zp = entity.owner.zo + (entity.owner.z - entity.owner.zo) * (double)partialTick + vec3.z;
            if ((Integer)this.renderDispatcher.gameSettings.thirdPersonView.value > 0) {
                float rr = (entity.owner.yBodyRotO + (entity.owner.yBodyRot - entity.owner.yBodyRotO) * partialTick) * (float)Math.PI / 180.0f;
                double ss = MathHelper.sin(rr);
                double cc = MathHelper.cos(rr);
                xp = entity.owner.xo + (entity.owner.x - entity.owner.xo) * (double)partialTick - cc * 0.35 - ss * 0.85;
                yp = entity.owner.yo + (entity.owner.y - entity.owner.yo) * (double)partialTick - 0.45;
                zp = entity.owner.zo + (entity.owner.z - entity.owner.zo) * (double)partialTick - ss * 0.35 + cc * 0.85;
            }
            double xh = entity.xo + (entity.x - entity.xo) * (double)partialTick;
            double yh = entity.yo + (entity.y - entity.yo) * (double)partialTick + 0.25;
            double zh = entity.zo + (entity.z - entity.zo) * (double)partialTick;
            double xa = (float)(xp - xh);
            double ya = (float)(yp - yh);
            double za = (float)(zp - zh);
            GL11.glDisable((int)3553);
            GL11.glDisable((int)2896);
            tessellator.startDrawing(3);
            tessellator.setColorOpaque_I(0);
            int steps = 16;
            for (int i = 0; i <= steps; ++i) {
                float aa = (float)i / (float)steps;
                tessellator.addVertex(x + xa * (double)aa, y + ya * (double)(aa * aa + aa) * 0.5 + 0.25, z + za * (double)aa);
            }
            tessellator.draw();
            GL11.glEnable((int)2896);
            GL11.glEnable((int)3553);
        }
    }
}

