/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block.piston;

import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.block.piston.TileEntityMovingPistonBlock;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;
import org.jetbrains.annotations.Nullable;

public class BlockLogicPistonMoving
extends BlockLogic {
    public BlockLogicPistonMoving(Block<?> container) {
        super(container, Material.piston);
        container.withHardness(-1.0f);
        container.withEntity(null);
    }

    @Override
    public void onBlockPlacedByWorld(World world, int x, int y, int z) {
    }

    @Override
    public void onBlockRemoved(World world, int x, int y, int z, int data) {
        TileEntity tileEntity = world.getBlockEntity(x, y, z);
        if (tileEntity instanceof TileEntityMovingPistonBlock) {
            ((TileEntityMovingPistonBlock)tileEntity).finalTick();
        } else {
            super.onBlockRemoved(world, x, y, z, data);
        }
    }

    @Override
    public boolean canPlaceBlockAt(World world, int x, int y, int z) {
        return false;
    }

    @Override
    public boolean canPlaceBlockOnSide(World world, int x, int y, int z, Side side) {
        return false;
    }

    @Override
    public boolean isSolidRender() {
        return false;
    }

    @Override
    public boolean isCubeShaped() {
        return false;
    }

    @Override
    public boolean onBlockRightClicked(World world, int x, int y, int z, Player player, Side side, double xPlaced, double yPlaced) {
        if (!world.isClientSide && world.getBlockEntity(x, y, z) == null) {
            int id = 0;
            TileEntityMovingPistonBlock piston = this.getBlockEntity(world, x, y, z);
            if (piston != null) {
                id = piston.getMovedId();
            }
            world.setBlockWithNotify(x, y, z, id);
            return true;
        }
        return false;
    }

    @Override
    public ItemStack[] getBreakResult(World world, EnumDropCause dropCause, int meta, TileEntity tileEntity) {
        return null;
    }

    @Override
    public void dropBlockWithCause(World world, EnumDropCause cause, int x, int y, int z, int meta, TileEntity tileEntity, Player player) {
        if (world.isClientSide) {
            return;
        }
        TileEntityMovingPistonBlock piston = this.getBlockEntity(world, x, y, z);
        if (piston != null) {
            Blocks.blocksList[piston.getMovedId()].dropBlockWithCause(world, EnumDropCause.WORLD, x, y, z, meta, null, null);
        }
    }

    @Override
    public void onNeighborBlockChange(World world, int x, int y, int z, int blockId) {
        if (world.isClientSide || world.getBlockEntity(x, y, z) != null) {
            // empty if block
        }
    }

    public static TileEntity createTileEntity(int movedId, int movedData, @Nullable TileEntity movedEntity, Direction direction, boolean extending, boolean isSourcePiston) {
        assert (!(movedEntity instanceof TileEntityMovingPistonBlock)) : "Moving piston entity should not be able to be put into another moving piston!";
        return new TileEntityMovingPistonBlock(movedId, movedData, movedEntity, direction, extending, isSourcePiston);
    }

    @Override
    public AABB getCollisionBoundingBoxFromPool(WorldSource world, int x, int y, int z) {
        TileEntityMovingPistonBlock tileEntity = this.getBlockEntity(world, x, y, z);
        if (tileEntity == null) {
            return null;
        }
        float progress = tileEntity.getProgress(0.0f);
        if (tileEntity.isExtending()) {
            progress = 1.0f - progress;
        }
        return this.getCollisionShapeFromTileEntity(world, x, y, z, tileEntity.getMovedId(), progress, tileEntity.getDirection());
    }

    @Override
    public AABB getBlockBoundsFromState(WorldSource world, int x, int y, int z) {
        TileEntityMovingPistonBlock pistonBlockEntity = this.getBlockEntity(world, x, y, z);
        if (pistonBlockEntity != null) {
            Block<?> block = Blocks.blocksList[pistonBlockEntity.getMovedId()];
            if (block == null || block == this.block) {
                return this.getBlockBoundsFromState(world, x, y, z);
            }
            float f = pistonBlockEntity.getProgress(0.0f);
            if (pistonBlockEntity.isExtending()) {
                f = 1.0f - f;
            }
            Direction direction = pistonBlockEntity.getDirection();
            AABB otherBounds = block.getBlockBoundsFromState(world, x, y, z);
            return AABB.getTemporaryBB(otherBounds.minX - (double)((float)direction.getOffsetX() * f), otherBounds.maxX - (double)((float)direction.getOffsetX() * f), otherBounds.minY - (double)((float)direction.getOffsetY() * f), otherBounds.maxY - (double)((float)direction.getOffsetY() * f), otherBounds.minZ - (double)((float)direction.getOffsetZ() * f), otherBounds.maxZ - (double)((float)direction.getOffsetZ() * f));
        }
        return super.getBlockBoundsFromState(world, x, y, z);
    }

    public AABB getCollisionShapeFromTileEntity(WorldSource world, int x, int y, int z, int blockID, float directionStretch, Direction direction) {
        if (blockID == 0 || blockID == this.block.id()) {
            return null;
        }
        AABB aabb = Blocks.blocksList[blockID].getCollisionBoundingBoxFromPool(world, x, y, z);
        if (aabb == null) {
            return null;
        }
        aabb.minX -= (double)((float)direction.getOffsetX() * directionStretch);
        aabb.maxX -= (double)((float)direction.getOffsetX() * directionStretch);
        aabb.minY -= (double)((float)direction.getOffsetY() * directionStretch);
        aabb.maxY -= (double)((float)direction.getOffsetY() * directionStretch);
        aabb.minZ -= (double)((float)direction.getOffsetZ() * directionStretch);
        aabb.maxZ -= (double)((float)direction.getOffsetZ() * directionStretch);
        return aabb;
    }

    private TileEntityMovingPistonBlock getBlockEntity(WorldSource world, int x, int y, int z) {
        TileEntity tileEntity = world.getBlockEntity(x, y, z);
        if (tileEntity instanceof TileEntityMovingPistonBlock) {
            return (TileEntityMovingPistonBlock)tileEntity;
        }
        return null;
    }
}

