/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.net.command.util;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.nbt.tags.CompoundTag;
import com.mojang.nbt.tags.Tag;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.net.command.CommandSource;
import net.minecraft.core.net.command.helpers.IntegerCoordinates;
import net.minecraft.core.net.command.util.CommandReflectionHelper;
import net.minecraft.core.util.collection.NamespaceID;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.WorldSource;
import net.minecraft.core.world.generate.feature.WorldFeature;

public class CommandHelper {
    public static final Map<String, Class<? extends WorldFeature>> WORLD_FEATURES = new HashMap<String, Class<? extends WorldFeature>>();
    public static final BiFunction<SuggestionsBuilder, Consumer<SuggestionsBuilder>, CompletableFuture<Suggestions>> NO_SUGGESTIONS = (builder, consumer) -> builder.buildFuture();
    public static final BiFunction<SuggestionsBuilder, Consumer<SuggestionsBuilder>, CompletableFuture<Suggestions>> SUGGEST_BLOCKS = (builder, consumer) -> {
        String remaining = builder.getRemaining().toLowerCase(Locale.ROOT);
        for (Block<?> block : Blocks.blocksList) {
            if (block == null) continue;
            CommandHelper.getStringToSuggest(block.getKey(), remaining).ifPresent(builder::suggest);
        }
        return builder.buildFuture();
    };

    public static CompletableFuture<Suggestions> suggest(String string, SuggestionsBuilder suggestionsBuilder) {
        String stringRemaining = suggestionsBuilder.getRemaining().toLowerCase(Locale.ROOT);
        if (CommandHelper.matchesSubStr(stringRemaining, string.toLowerCase(Locale.ROOT))) {
            suggestionsBuilder.suggest(string);
        }
        return suggestionsBuilder.buildFuture();
    }

    public static CompletableFuture<Suggestions> suggest(Iterable<String> iterable, SuggestionsBuilder suggestionsBuilder) {
        String string = suggestionsBuilder.getRemaining().toLowerCase(Locale.ROOT);
        for (String string2 : iterable) {
            if (!CommandHelper.matchesSubStr(string, string2.toLowerCase(Locale.ROOT))) continue;
            suggestionsBuilder.suggest(string2);
        }
        return suggestionsBuilder.buildFuture();
    }

    public static boolean matchesSubStr(String string, String string2) {
        int i = 0;
        while (!string2.startsWith(string, i)) {
            if ((i = string2.indexOf(95, i)) < 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static Optional<String> getStringToSuggest(String checkedString, String input) {
        if (checkedString.toLowerCase(Locale.ROOT).startsWith(input.toLowerCase(Locale.ROOT))) {
            return Optional.of(checkedString);
        }
        if (checkedString.contains(":") && checkedString.length() - 1 >= checkedString.indexOf(58) + 1) {
            if (checkedString.toLowerCase(Locale.ROOT).substring(checkedString.indexOf(58) + 1).startsWith(input.toLowerCase(Locale.ROOT))) {
                return Optional.of(checkedString.substring(checkedString.indexOf(58) + 1));
            }
            return Optional.empty();
        }
        if (checkedString.contains(".") && checkedString.length() - 1 >= checkedString.indexOf(46) + 1 && checkedString.toLowerCase(Locale.ROOT).substring(checkedString.indexOf(46) + 1).startsWith(input.toLowerCase(Locale.ROOT))) {
            return Optional.of(checkedString.substring(checkedString.indexOf(46) + 1));
        }
        return Optional.empty();
    }

    public static boolean matchesKeyString(String checkedString, String input) {
        if (checkedString.equals(input)) {
            return true;
        }
        if (checkedString.contains(":") && checkedString.length() - 1 >= checkedString.indexOf(58) + 1) {
            return checkedString.substring(checkedString.indexOf(58) + 1).equals(input);
        }
        return checkedString.contains(".") && checkedString.length() - 1 >= checkedString.indexOf(46) + 1 && checkedString.substring(checkedString.indexOf(46) + 1).equals(input);
    }

    public static boolean matchesNamespaceId(NamespaceID namespaceID, String input) {
        if (input.contains(":")) {
            return namespaceID.toString().equalsIgnoreCase(input);
        }
        if (namespaceID.namespace.equals("minecraft")) {
            return namespaceID.value.equalsIgnoreCase(input);
        }
        return false;
    }

    public static String getEntityName(Entity entity) {
        return Entity.getNameFromEntity(entity, true);
    }

    public static int getVolume(CommandSource source, IntegerCoordinates first, IntegerCoordinates second) throws CommandSyntaxException {
        return (int)(MathHelper.abs(first.getX(source) - second.getX(source)) * MathHelper.abs(first.getY(source, true) - second.getY(source, true)) * MathHelper.abs(first.getZ(source) - second.getZ(source)));
    }

    public static float linearInterpolation(float factor, float min, float max) {
        return min + factor * (max - min);
    }

    public static boolean blockEntitiesAreEqual(CompoundTag first, CompoundTag second) {
        if (first == null && second == null) {
            return true;
        }
        if (first == null || second == null) {
            return false;
        }
        for (Map.Entry entry : ((Map)first.getValue()).entrySet()) {
            if (((String)entry.getKey()).equals("x") || ((String)entry.getKey()).equals("y") || ((String)entry.getKey()).equals("z") || ((Map)second.getValue()).containsKey(entry.getKey()) && (((Map)second.getValue()).get(entry.getKey()) == entry.getValue() || ((Tag)((Map)second.getValue()).get(entry.getKey())).equals(entry.getValue()) || ((Tag)((Map)second.getValue()).get(entry.getKey())).getValue().equals(((Tag)entry.getValue()).getValue()))) continue;
            return false;
        }
        for (Map.Entry entry : ((Map)second.getValue()).entrySet()) {
            if (((String)entry.getKey()).equals("x") || ((String)entry.getKey()).equals("y") || ((String)entry.getKey()).equals("z") || ((Map)first.getValue()).containsKey(entry.getKey()) && (((Map)first.getValue()).get(entry.getKey()) == entry.getValue() || ((Tag)((Map)first.getValue()).get(entry.getKey())).equals(entry.getValue()) || ((Tag)((Map)first.getValue()).get(entry.getKey())).getValue().equals(((Tag)entry.getValue()).getValue()))) continue;
            return false;
        }
        return true;
    }

    public static void setBlockEntity(WorldSource world, int x, int y, int z, CompoundTag tag) {
        if (tag == null || world.getBlockEntity(x, y, z) == null) {
            return;
        }
        tag.putInt("x", x);
        tag.putInt("y", y);
        tag.putInt("z", z);
        world.getBlockEntity(x, y, z).readFromNBT(tag);
    }

    public static void setBlockEntity(WorldSource world, int x, int y, int z, TileEntity tileEntity) {
        CommandHelper.setBlockEntity(world, x, y, z, CommandHelper.tagFrom(tileEntity));
    }

    public static CompoundTag tagFrom(TileEntity tileEntity) {
        CompoundTag tag = new CompoundTag();
        if (tileEntity != null) {
            tileEntity.writeToNBT(tag);
        }
        return tag;
    }

    public static void init() {
        try {
            for (Class<?> aClass : CommandReflectionHelper.getAllClasses(className -> className.startsWith("net.minecraft.core.world.generate.feature"))) {
                if (!WorldFeature.class.isAssignableFrom(aClass) || aClass == WorldFeature.class) continue;
                Class<?> worldGenClass = aClass;
                WORLD_FEATURES.put(aClass.getSimpleName().substring(12), worldGenClass);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

