/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.option.GameSettings;
import net.minecraft.client.render.Font;
import net.minecraft.client.render.ItemRenderer;
import net.minecraft.client.render.LightmapHelper;
import net.minecraft.client.render.TextureManager;
import net.minecraft.client.render.camera.ICamera;
import net.minecraft.client.render.entity.EntityRenderer;
import net.minecraft.client.render.entity.EntityRendererArrow;
import net.minecraft.client.render.entity.EntityRendererBoat;
import net.minecraft.client.render.entity.EntityRendererCannonball;
import net.minecraft.client.render.entity.EntityRendererDefault;
import net.minecraft.client.render.entity.EntityRendererFallingBlock;
import net.minecraft.client.render.entity.EntityRendererFishingBobber;
import net.minecraft.client.render.entity.EntityRendererItem;
import net.minecraft.client.render.entity.EntityRendererLightningBolt;
import net.minecraft.client.render.entity.EntityRendererMinecart;
import net.minecraft.client.render.entity.EntityRendererPainting;
import net.minecraft.client.render.entity.EntityRendererSprite;
import net.minecraft.client.render.entity.EntityRendererTNT;
import net.minecraft.client.render.entity.MobRenderer;
import net.minecraft.client.render.entity.MobRendererBiped;
import net.minecraft.client.render.entity.MobRendererChicken;
import net.minecraft.client.render.entity.MobRendererCow;
import net.minecraft.client.render.entity.MobRendererCreeper;
import net.minecraft.client.render.entity.MobRendererFireflyCluster;
import net.minecraft.client.render.entity.MobRendererGhast;
import net.minecraft.client.render.entity.MobRendererGiant;
import net.minecraft.client.render.entity.MobRendererHuman;
import net.minecraft.client.render.entity.MobRendererPig;
import net.minecraft.client.render.entity.MobRendererPlayer;
import net.minecraft.client.render.entity.MobRendererScorpion;
import net.minecraft.client.render.entity.MobRendererSheep;
import net.minecraft.client.render.entity.MobRendererSlime;
import net.minecraft.client.render.entity.MobRendererSpider;
import net.minecraft.client.render.entity.MobRendererSquid;
import net.minecraft.client.render.entity.MobRendererWolf;
import net.minecraft.client.render.entity.MobRendererZombieArmored;
import net.minecraft.client.render.model.ModelBiped;
import net.minecraft.client.render.model.ModelChicken;
import net.minecraft.client.render.model.ModelCow;
import net.minecraft.client.render.model.ModelPig;
import net.minecraft.client.render.model.ModelSheep;
import net.minecraft.client.render.model.ModelSheepOverlay;
import net.minecraft.client.render.model.ModelSheepWool;
import net.minecraft.client.render.model.ModelSkeleton;
import net.minecraft.client.render.model.ModelSlime;
import net.minecraft.client.render.model.ModelSquid;
import net.minecraft.client.render.model.ModelWolf;
import net.minecraft.client.render.model.ModelZombie;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.core.Global;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.EntityFallingBlock;
import net.minecraft.core.entity.EntityFishingBobber;
import net.minecraft.core.entity.EntityItem;
import net.minecraft.core.entity.EntityLightning;
import net.minecraft.core.entity.EntityPainting;
import net.minecraft.core.entity.EntityPrimedTNT;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.entity.animal.MobChicken;
import net.minecraft.core.entity.animal.MobCow;
import net.minecraft.core.entity.animal.MobFireflyCluster;
import net.minecraft.core.entity.animal.MobPig;
import net.minecraft.core.entity.animal.MobSheep;
import net.minecraft.core.entity.animal.MobSquid;
import net.minecraft.core.entity.animal.MobWolf;
import net.minecraft.core.entity.monster.MobCreeper;
import net.minecraft.core.entity.monster.MobGhast;
import net.minecraft.core.entity.monster.MobGiant;
import net.minecraft.core.entity.monster.MobHuman;
import net.minecraft.core.entity.monster.MobScorpion;
import net.minecraft.core.entity.monster.MobSkeleton;
import net.minecraft.core.entity.monster.MobSlime;
import net.minecraft.core.entity.monster.MobSnowman;
import net.minecraft.core.entity.monster.MobSpider;
import net.minecraft.core.entity.monster.MobZombie;
import net.minecraft.core.entity.monster.MobZombieArmored;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.entity.projectile.ProjectileArrow;
import net.minecraft.core.entity.projectile.ProjectileCannonball;
import net.minecraft.core.entity.projectile.ProjectileEgg;
import net.minecraft.core.entity.projectile.ProjectileFireball;
import net.minecraft.core.entity.projectile.ProjectilePebble;
import net.minecraft.core.entity.projectile.ProjectileSnowball;
import net.minecraft.core.entity.vehicle.EntityBoat;
import net.minecraft.core.entity.vehicle.EntityMinecart;
import net.minecraft.core.item.Items;
import net.minecraft.core.world.World;
import org.lwjgl.opengl.GL11;

public class EntityRenderDispatcher {
    private final Map<Class<?>, EntityRenderer<?>> renderers = new HashMap();
    public static EntityRenderDispatcher instance = new EntityRenderDispatcher();
    private Font font;
    public static double renderPosX;
    public static double renderPosY;
    public static double renderPosZ;
    public TextureManager textureManager;
    public ItemRenderer itemRenderer;
    public World world;
    public ICamera camera;
    public float viewLerpYaw;
    public float viewLerpPitch;
    public GameSettings gameSettings;
    public double viewLerpPosX;
    public double viewLerpPosY;
    public double viewLerpPosZ;

    private EntityRenderDispatcher() {
        this.renderers.put(MobSpider.class, new MobRendererSpider());
        this.renderers.put(MobScorpion.class, new MobRendererScorpion());
        this.renderers.put(MobPig.class, new MobRendererPig(new ModelPig(), new ModelPig(0.5f), 0.7f));
        this.renderers.put(MobSheep.class, new MobRendererSheep(new ModelSheep(), new ModelSheepWool(), new ModelSheepOverlay(), 0.7f));
        this.renderers.put(MobCow.class, new MobRendererCow(new ModelCow(), 0.7f));
        this.renderers.put(MobWolf.class, new MobRendererWolf(new ModelWolf(0.0f), 0.5f));
        this.renderers.put(MobChicken.class, new MobRendererChicken(new ModelChicken(), 0.3f));
        this.renderers.put(MobCreeper.class, new MobRendererCreeper());
        this.renderers.put(MobSkeleton.class, new MobRendererBiped(new ModelSkeleton(), 0.5f));
        this.renderers.put(MobZombie.class, new MobRendererBiped(new ModelZombie(), 0.5f));
        this.renderers.put(MobSnowman.class, new MobRendererBiped(new ModelZombie(), 0.5f));
        this.renderers.put(MobZombieArmored.class, new MobRendererZombieArmored(new ModelZombie(), 0.5f));
        this.renderers.put(MobSlime.class, new MobRendererSlime(new ModelSlime(16), new ModelSlime(0), 0.25f));
        this.renderers.put(Player.class, new MobRendererPlayer());
        this.renderers.put(MobHuman.class, new MobRendererHuman());
        this.renderers.put(MobGiant.class, new MobRendererGiant(new ModelZombie(), 0.5f, 6.0f));
        this.renderers.put(MobGhast.class, new MobRendererGhast());
        this.renderers.put(MobSquid.class, new MobRendererSquid(new ModelSquid(), 0.7f));
        this.renderers.put(Mob.class, new MobRenderer(new ModelBiped(), 0.5f));
        this.renderers.put(Entity.class, new EntityRendererDefault());
        this.renderers.put(EntityPainting.class, new EntityRendererPainting());
        this.renderers.put(ProjectileArrow.class, new EntityRendererArrow());
        this.renderers.put(ProjectileSnowball.class, new EntityRendererSprite(Items.AMMO_SNOWBALL));
        this.renderers.put(ProjectileEgg.class, new EntityRendererSprite(Items.EGG_CHICKEN));
        this.renderers.put(ProjectileFireball.class, new EntityRendererSprite(Items.AMMO_FIREBALL).setScale(4.0f).setFullBright());
        this.renderers.put(EntityItem.class, new EntityRendererItem());
        this.renderers.put(EntityPrimedTNT.class, new EntityRendererTNT());
        this.renderers.put(EntityFallingBlock.class, new EntityRendererFallingBlock());
        this.renderers.put(EntityMinecart.class, new EntityRendererMinecart());
        this.renderers.put(EntityBoat.class, new EntityRendererBoat());
        this.renderers.put(EntityFishingBobber.class, new EntityRendererFishingBobber());
        this.renderers.put(MobFireflyCluster.class, new MobRendererFireflyCluster());
        this.renderers.put(EntityLightning.class, new EntityRendererLightningBolt());
        this.renderers.put(ProjectileCannonball.class, new EntityRendererCannonball());
        this.renderers.put(ProjectilePebble.class, new EntityRendererSprite(Items.AMMO_PEBBLE));
        for (EntityRenderer<?> renderer : this.renderers.values()) {
            renderer.init(this);
        }
    }

    public <T extends Entity> EntityRenderer<T> getRenderer(Class<? extends Entity> e) {
        EntityRenderer<Object> r = this.renderers.get(e);
        if (r == null && e != Entity.class) {
            r = this.getRenderer(e.getSuperclass());
            this.renderers.put(e, r);
        }
        return r;
    }

    public <T extends Entity> EntityRenderer<T> getRenderer(Entity entity) {
        return this.getRenderer(entity.getClass());
    }

    public void cacheActiveRenderInfo(World world, TextureManager textureManager, Font font, ICamera camera, GameSettings gameSettings, float partialTick) {
        this.world = world;
        this.textureManager = textureManager;
        this.gameSettings = gameSettings;
        this.font = font;
        this.camera = camera;
        this.viewLerpYaw = (float)camera.getYRot(partialTick);
        this.viewLerpPitch = (float)camera.getXRot(partialTick);
        this.viewLerpPosX = (float)camera.getX(partialTick);
        this.viewLerpPosY = (float)camera.getY(partialTick);
        this.viewLerpPosZ = (float)camera.getZ(partialTick);
    }

    public <T extends Entity> void renderEntity(Tessellator tessellator, T entity, float partialTick) {
        float brightness;
        double lerpPosX = entity.xo + (entity.x - entity.xo) * (double)partialTick;
        double lerpPosY = entity.yo + (entity.y - entity.yo) * (double)partialTick;
        double lerpPosZ = entity.zo + (entity.z - entity.zo) * (double)partialTick;
        float lerpYaw = entity.yRotO + (entity.yRot - entity.yRotO) * partialTick;
        if (LightmapHelper.isLightmapEnabled()) {
            brightness = 1.0f;
            LightmapHelper.setLightmapCoord(entity.getLightmapCoord(partialTick));
        } else {
            brightness = Global.accessor.isFullbrightEnabled() ? 1.0f : entity.getBrightness(partialTick);
        }
        if (Global.accessor.isFullbrightEnabled()) {
            brightness = 1.0f;
        }
        GL11.glColor3f((float)brightness, (float)brightness, (float)brightness);
        this.renderEntityWithPosYaw(tessellator, entity, lerpPosX - renderPosX, lerpPosY - renderPosY, lerpPosZ - renderPosZ, lerpYaw, partialTick);
    }

    public <T extends Entity> void renderEntityWithPosYaw(Tessellator tessellator, T entity, double x, double y, double z, float yaw, float partialTick) {
        EntityRenderer<T> renderer = this.getRenderer(entity);
        if (renderer != null) {
            renderer.render(tessellator, entity, x, y, z, yaw, partialTick);
            renderer.postRender(tessellator, entity, x, y, z, yaw, partialTick);
        }
    }

    public <T extends Entity> void renderEntityPreviewWithPosYaw(Tessellator tessellator, T entity, double x, double y, double z, float yaw, float partialTick) {
        EntityRenderer<T> renderer = this.getRenderer(entity);
        if (renderer != null) {
            renderer.renderPreview(tessellator, entity, x, y, z, yaw, partialTick);
        }
    }

    public void unloadEntityRenderers() {
        for (EntityRenderer<?> renderer : this.renderers.values()) {
            renderer.onUnload();
        }
    }

    public void setWorld(World world) {
        this.world = world;
    }

    public double distanceToLerpSquared(double x, double y, double z) {
        double dx = x - this.viewLerpPosX;
        double dy = y - this.viewLerpPosY;
        double dz = z - this.viewLerpPosZ;
        return dx * dx + dy * dy + dz * dz;
    }

    public Font getFont() {
        return this.font;
    }
}

