/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model;

import net.minecraft.client.render.block.model.BlockModelCrossedSquares;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogicFlowerStackable;
import net.minecraft.core.util.helper.Side;

public class BlockModelFlowerStackable<T extends BlockLogicFlowerStackable>
extends BlockModelCrossedSquares<T> {
    private final IconCoordinate[] ICONS = new IconCoordinate[4];

    public BlockModelFlowerStackable(Block<T> block, String baseTexture) {
        super(block);
        for (int i = 0; i < 4; ++i) {
            this.ICONS[i] = TextureRegistry.getTexture(baseTexture + i);
        }
    }

    @Override
    public IconCoordinate getBlockTextureFromSideAndMetadata(Side side, int data) {
        int stackCount = BlockLogicFlowerStackable.getStackCount(data);
        if (stackCount > 3) {
            return this.ICONS[0];
        }
        return this.ICONS[stackCount];
    }
}

