/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.entity;

import net.minecraft.client.render.block.model.BlockModel;
import net.minecraft.client.render.block.model.BlockModelDispatcher;
import net.minecraft.client.render.entity.MobRenderer;
import net.minecraft.client.render.item.model.ItemModelDispatcher;
import net.minecraft.client.render.model.ModelWolf;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.entity.animal.MobWolf;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.material.ArmorMaterial;
import org.lwjgl.opengl.GL11;

public class MobRendererWolf
extends MobRenderer<MobWolf> {
    private final ModelWolf modelArmor;
    protected ModelWolf modelWolfMain;

    public MobRendererWolf(ModelWolf modelWolf, float shadowSize) {
        super(modelWolf, shadowSize);
        this.modelWolfMain = modelWolf;
        this.modelArmor = new ModelWolf(0.25f);
    }

    @Override
    protected boolean prepareArmor(MobWolf wolf, int layer, float partialTick) {
        ArmorMaterial material = wolf.getArmorMaterial();
        if (material == null) {
            return false;
        }
        this.bindTexture(String.format("/assets/%s/textures/armor/wolf/%s.png", material.identifier.namespace, material.identifier.value));
        this.setArmorModel(this.modelArmor);
        return true;
    }

    @Override
    protected float limbSway(MobWolf wolf, float partialTick) {
        if (wolf.isWolfAngry()) {
            return 1.5358897f;
        }
        if (wolf.isWolfTamed()) {
            return (0.55f - (float)(wolf.getMaxHealth() - wolf.getHealth()) * 0.02f) * (float)Math.PI;
        }
        return 0.62831855f;
    }

    @Override
    protected void renderAdditional(MobWolf entity, float f) {
        ItemStack itemstack = entity.getHeldItem();
        if (itemstack != null && itemstack.getItem() != null) {
            GL11.glPushMatrix();
            this.modelWolfMain.wolfHeadMain.translateTo(0.0625f);
            GL11.glTranslatef((float)-0.0625f, (float)0.4375f, (float)0.0625f);
            if (itemstack.itemID > 0 && itemstack.itemID < Blocks.blocksList.length && ((BlockModel)BlockModelDispatcher.getInstance().getDispatch(Blocks.blocksList[itemstack.itemID])).shouldItemRender3d()) {
                float scale = 0.35f;
                GL11.glTranslatef((float)0.075f, (float)-0.3f, (float)-0.35f);
                GL11.glRotatef((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glScalef((float)(scale *= 0.75f), (float)(-scale), (float)scale);
            } else {
                float scale = 0.375f;
                GL11.glTranslatef((float)0.25f, (float)-0.25f, (float)-0.35f);
                GL11.glScalef((float)scale, (float)scale, (float)scale);
                GL11.glRotatef((float)50.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                GL11.glRotatef((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)70.0f, (float)1.0f, (float)0.0f, (float)1.0f);
            }
            ItemModelDispatcher.getInstance().getDispatch(itemstack).renderItem(Tessellator.instance, this.renderDispatcher.itemRenderer, entity, itemstack);
            GL11.glPopMatrix();
        }
    }
}

