/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.net.packet;

import com.mojang.logging.LogUtils;
import com.mojang.nbt.NbtIo;
import com.mojang.nbt.tags.CompoundTag;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.net.handler.PacketHandler;
import net.minecraft.core.net.packet.PacketAESSendKey;
import net.minecraft.core.net.packet.PacketAddEntity;
import net.minecraft.core.net.packet.PacketAddItemEntity;
import net.minecraft.core.net.packet.PacketAddMob;
import net.minecraft.core.net.packet.PacketAddPainting;
import net.minecraft.core.net.packet.PacketAddParticle;
import net.minecraft.core.net.packet.PacketAddPlayer;
import net.minecraft.core.net.packet.PacketAnimate;
import net.minecraft.core.net.packet.PacketBedMessage;
import net.minecraft.core.net.packet.PacketBlockEvent;
import net.minecraft.core.net.packet.PacketBlockRegionUpdate;
import net.minecraft.core.net.packet.PacketBlockUpdate;
import net.minecraft.core.net.packet.PacketBoatControl;
import net.minecraft.core.net.packet.PacketChat;
import net.minecraft.core.net.packet.PacketChunkBlocksUpdate;
import net.minecraft.core.net.packet.PacketChunkVisibility;
import net.minecraft.core.net.packet.PacketCommandManager;
import net.minecraft.core.net.packet.PacketContainerAck;
import net.minecraft.core.net.packet.PacketContainerClick;
import net.minecraft.core.net.packet.PacketContainerClose;
import net.minecraft.core.net.packet.PacketContainerOpen;
import net.minecraft.core.net.packet.PacketContainerSetContent;
import net.minecraft.core.net.packet.PacketContainerSetData;
import net.minecraft.core.net.packet.PacketContainerSetSlot;
import net.minecraft.core.net.packet.PacketCustomPayload;
import net.minecraft.core.net.packet.PacketDisconnect;
import net.minecraft.core.net.packet.PacketEntityEvent;
import net.minecraft.core.net.packet.PacketEntityNickname;
import net.minecraft.core.net.packet.PacketEntityTagData;
import net.minecraft.core.net.packet.PacketExplosion;
import net.minecraft.core.net.packet.PacketFlagOpen;
import net.minecraft.core.net.packet.PacketGameRule;
import net.minecraft.core.net.packet.PacketGuidebook;
import net.minecraft.core.net.packet.PacketInteract;
import net.minecraft.core.net.packet.PacketKeepAlive;
import net.minecraft.core.net.packet.PacketLogin;
import net.minecraft.core.net.packet.PacketMapData;
import net.minecraft.core.net.packet.PacketMoveEntity;
import net.minecraft.core.net.packet.PacketMovePlayer;
import net.minecraft.core.net.packet.PacketPhotoMode;
import net.minecraft.core.net.packet.PacketPingHandshake;
import net.minecraft.core.net.packet.PacketPlaySoundEffect;
import net.minecraft.core.net.packet.PacketPlaySoundEffectDirect;
import net.minecraft.core.net.packet.PacketPlayerAction;
import net.minecraft.core.net.packet.PacketPlayerGamemode;
import net.minecraft.core.net.packet.PacketPlayerList;
import net.minecraft.core.net.packet.PacketPreLogin;
import net.minecraft.core.net.packet.PacketRecipeSync;
import net.minecraft.core.net.packet.PacketRemoveEntity;
import net.minecraft.core.net.packet.PacketRequestCommandManager;
import net.minecraft.core.net.packet.PacketRespawn;
import net.minecraft.core.net.packet.PacketSetCarriedItem;
import net.minecraft.core.net.packet.PacketSetEntityData;
import net.minecraft.core.net.packet.PacketSetEntityMotion;
import net.minecraft.core.net.packet.PacketSetEquippedItem;
import net.minecraft.core.net.packet.PacketSetHealth;
import net.minecraft.core.net.packet.PacketSetHeldObject;
import net.minecraft.core.net.packet.PacketSetHotbarOffset;
import net.minecraft.core.net.packet.PacketSetItemName;
import net.minecraft.core.net.packet.PacketSetMobSpawner;
import net.minecraft.core.net.packet.PacketSetPaintingArt;
import net.minecraft.core.net.packet.PacketSetRiding;
import net.minecraft.core.net.packet.PacketSetSpawnPosition;
import net.minecraft.core.net.packet.PacketSetTime;
import net.minecraft.core.net.packet.PacketSignUpdate;
import net.minecraft.core.net.packet.PacketSleep;
import net.minecraft.core.net.packet.PacketStatistic;
import net.minecraft.core.net.packet.PacketSyncIDs;
import net.minecraft.core.net.packet.PacketTakeItemEntity;
import net.minecraft.core.net.packet.PacketTeleportEntity;
import net.minecraft.core.net.packet.PacketTileEntityData;
import net.minecraft.core.net.packet.PacketUpdateCreativeInventory;
import net.minecraft.core.net.packet.PacketUpdatePlayerProfile;
import net.minecraft.core.net.packet.PacketUpdatePlayerState;
import net.minecraft.core.net.packet.PacketUseItem;
import net.minecraft.core.net.packet.PacketWeatherEffect;
import net.minecraft.core.net.packet.PacketWeatherStatus;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public abstract class Packet {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final List<Integer> INTERESTING_PACKETS = Arrays.asList(50, 51, 52);
    private static final Map<Integer, Class<? extends Packet>> packetIdToClassMap = new HashMap<Integer, Class<? extends Packet>>();
    private static final Map<Class<? extends Packet>, Integer> packetClassToIdMap = new HashMap<Class<? extends Packet>, Integer>();
    private static final Set<Integer> clientBoundPacketIds = new HashSet<Integer>();
    private static final Set<Integer> serverBoundPacketIds = new HashSet<Integer>();
    public static final int MAX_USERNAME_SIZE = 16;
    public static final int MAX_NICKNAME_SIZE = 256;
    public static final int MAX_AES_KEY_SIZE = 392;
    public static final int MAX_MESSAGE_SIZE = 1024;
    public final long creationTimeMillis = System.currentTimeMillis();
    public boolean isChunkDataPacket = false;

    public static void addMapping(int id, boolean clientBound, boolean serverBound, Class<? extends Packet> packetClass) {
        if (packetIdToClassMap.containsKey(id)) {
            throw new IllegalArgumentException("Duplicate packet id:" + id);
        }
        if (packetClassToIdMap.containsKey(packetClass)) {
            throw new IllegalArgumentException("Duplicate packet class:" + packetClass);
        }
        packetIdToClassMap.put(id, packetClass);
        packetClassToIdMap.put(packetClass, id);
        if (clientBound) {
            clientBoundPacketIds.add(id);
        }
        if (serverBound) {
            serverBoundPacketIds.add(id);
        }
    }

    public static Packet getNewPacket(int id) {
        Class<? extends Packet> packetClass = packetIdToClassMap.get(id);
        try {
            if (packetClass == null) {
                return null;
            }
            return packetClass.newInstance();
        }
        catch (Exception exception) {
            LOGGER.error("Exception instancing packet class '{}'!", (Object)packetClass.getSimpleName(), (Object)exception);
            LOGGER.warn("Skipping packet with id {}", (Object)id);
            return null;
        }
    }

    public final int getId() {
        return packetClassToIdMap.get(this.getClass());
    }

    public static Packet readPacket(DataInputStream dis, boolean isServer) throws IOException {
        Packet packet;
        try {
            int id = dis.read();
            if (id == -1) {
                return null;
            }
            if (isServer && !serverBoundPacketIds.contains(id) || !isServer && !clientBoundPacketIds.contains(id)) {
                throw new IOException("Bad packet id " + id);
            }
            packet = Packet.getNewPacket(id);
            if (packet == null) {
                throw new IOException("Bad packet id " + id);
            }
            packet.read(dis);
        }
        catch (EOFException eofexception) {
            LOGGER.warn("Reached end of stream");
            return null;
        }
        return packet;
    }

    public static void writePacket(Packet packet, DataOutputStream dos) throws IOException {
        dos.write(packet.getId());
        packet.write(dos);
    }

    public static void writeString(String string, DataOutputStream dos) throws IOException {
        if (string.length() > Short.MAX_VALUE) {
            throw new IOException("String too big");
        }
        byte[] buf = string.getBytes(StandardCharsets.UTF_8);
        dos.writeShort(buf.length);
        dos.write(buf);
    }

    public static String readString(DataInputStream dis, int maxLength) throws IOException {
        short length = dis.readShort();
        if (length < 0) {
            throw new IOException("Received string length is less than zero! Weird string!");
        }
        if (length > maxLength) {
            throw new IOException("Received string length longer than maximum allowed (" + length + " > " + maxLength + ")");
        }
        byte[] data = new byte[length];
        dis.readFully(data);
        return new String(data, StandardCharsets.UTF_8);
    }

    public static void writeUTF16BEString(String string, DataOutputStream dos) throws IOException {
        if (string.length() > Short.MAX_VALUE) {
            throw new IOException("String too big");
        }
        byte[] buf = string.getBytes(StandardCharsets.UTF_16BE);
        dos.writeShort(string.length());
        dos.write(buf);
    }

    public static String readUTF16BEString(DataInputStream dis, int maxLength) throws IOException {
        short length = dis.readShort();
        if (length < 0) {
            throw new IOException("Received string length is less than zero! Weird string!");
        }
        if (length > maxLength) {
            throw new IOException("Received string length longer than maximum allowed (" + length + " > " + maxLength + ")");
        }
        byte[] data = new byte[length * 2];
        dis.readFully(data);
        String result = new String(data, StandardCharsets.UTF_16BE);
        return result;
    }

    public static void writeCompressedCompoundTag(@NotNull CompoundTag tag, DataOutputStream dos) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        NbtIo.writeCompressed(tag, baos);
        byte[] buffer = baos.toByteArray();
        dos.writeShort((short)buffer.length);
        dos.write(buffer);
    }

    public static CompoundTag readCompressedCompoundTag(DataInputStream dis) throws IOException {
        int length = Short.toUnsignedInt(dis.readShort());
        if (length == 0) {
            return null;
        }
        byte[] data = new byte[length];
        dis.readFully(data);
        return NbtIo.readCompressed(new ByteArrayInputStream(data));
    }

    public static void writeUUID(@NotNull UUID uuid, DataOutputStream dos) throws IOException {
        dos.writeLong(uuid.getMostSignificantBits());
        dos.writeLong(uuid.getLeastSignificantBits());
    }

    public static UUID readUUID(DataInputStream dis) throws IOException {
        long msb = dis.readLong();
        long lsb = dis.readLong();
        return new UUID(msb, lsb);
    }

    public static Map<Class<? extends Packet>, Integer> getPacketClassToIdMap() {
        return Collections.unmodifiableMap(packetClassToIdMap);
    }

    public static Map<Integer, Class<? extends Packet>> getPacketIdToClassMap() {
        return Collections.unmodifiableMap(packetIdToClassMap);
    }

    public abstract void read(DataInputStream var1) throws IOException;

    public abstract void write(DataOutputStream var1) throws IOException;

    public abstract void handlePacket(PacketHandler var1);

    public abstract int getEstimatedSize();

    static {
        Packet.addMapping(0, true, true, PacketKeepAlive.class);
        Packet.addMapping(1, true, true, PacketLogin.class);
        Packet.addMapping(2, true, true, PacketPreLogin.class);
        Packet.addMapping(3, true, true, PacketChat.class);
        Packet.addMapping(4, true, false, PacketSetTime.class);
        Packet.addMapping(5, true, false, PacketSetEquippedItem.class);
        Packet.addMapping(6, true, false, PacketSetSpawnPosition.class);
        Packet.addMapping(7, false, true, PacketInteract.class);
        Packet.addMapping(8, true, false, PacketSetHealth.class);
        Packet.addMapping(9, true, true, PacketRespawn.class);
        Packet.addMapping(10, true, true, PacketMovePlayer.class);
        Packet.addMapping(11, true, true, PacketMovePlayer.Pos.class);
        Packet.addMapping(12, true, true, PacketMovePlayer.Rot.class);
        Packet.addMapping(13, true, true, PacketMovePlayer.PosRot.class);
        Packet.addMapping(14, false, true, PacketPlayerAction.class);
        Packet.addMapping(15, false, true, PacketUseItem.class);
        Packet.addMapping(16, true, true, PacketSetCarriedItem.class);
        Packet.addMapping(17, true, false, PacketSleep.class);
        Packet.addMapping(18, true, true, PacketAnimate.class);
        Packet.addMapping(19, false, true, PacketUpdatePlayerState.class);
        Packet.addMapping(20, true, false, PacketAddPlayer.class);
        Packet.addMapping(21, true, false, PacketAddItemEntity.class);
        Packet.addMapping(22, true, false, PacketTakeItemEntity.class);
        Packet.addMapping(23, true, false, PacketAddEntity.class);
        Packet.addMapping(24, true, false, PacketAddMob.class);
        Packet.addMapping(25, true, false, PacketAddPainting.class);
        Packet.addMapping(26, true, true, PacketBoatControl.class);
        Packet.addMapping(27, true, true, PacketSetHeldObject.class);
        Packet.addMapping(28, true, false, PacketSetEntityMotion.class);
        Packet.addMapping(29, true, false, PacketRemoveEntity.class);
        Packet.addMapping(30, true, false, PacketMoveEntity.class);
        Packet.addMapping(31, true, false, PacketMoveEntity.Pos.class);
        Packet.addMapping(32, true, false, PacketMoveEntity.Rot.class);
        Packet.addMapping(33, true, false, PacketMoveEntity.PosRot.class);
        Packet.addMapping(34, true, false, PacketTeleportEntity.class);
        Packet.addMapping(35, true, true, PacketEntityNickname.class);
        Packet.addMapping(38, true, false, PacketEntityEvent.class);
        Packet.addMapping(39, true, false, PacketSetRiding.class);
        Packet.addMapping(40, true, false, PacketSetEntityData.class);
        Packet.addMapping(41, true, false, PacketPlayerGamemode.class);
        Packet.addMapping(42, true, false, PacketEntityTagData.class);
        Packet.addMapping(50, true, false, PacketChunkVisibility.class);
        Packet.addMapping(51, true, false, PacketBlockRegionUpdate.class);
        Packet.addMapping(52, true, false, PacketChunkBlocksUpdate.class);
        Packet.addMapping(53, true, false, PacketBlockUpdate.class);
        Packet.addMapping(54, true, false, PacketBlockEvent.class);
        Packet.addMapping(60, true, false, PacketExplosion.class);
        Packet.addMapping(61, true, false, PacketPlaySoundEffect.class);
        Packet.addMapping(62, true, false, PacketPlaySoundEffectDirect.class);
        Packet.addMapping(63, true, false, PacketAddParticle.class);
        Packet.addMapping(70, true, false, PacketBedMessage.class);
        Packet.addMapping(71, true, false, PacketWeatherEffect.class);
        Packet.addMapping(72, true, false, PacketUpdatePlayerProfile.class);
        Packet.addMapping(73, true, false, PacketWeatherStatus.class);
        Packet.addMapping(74, true, false, PacketGameRule.class);
        Packet.addMapping(75, true, false, PacketRecipeSync.class);
        Packet.addMapping(100, true, false, PacketContainerOpen.class);
        Packet.addMapping(101, true, true, PacketContainerClose.class);
        Packet.addMapping(102, false, true, PacketContainerClick.class);
        Packet.addMapping(103, true, false, PacketContainerSetSlot.class);
        Packet.addMapping(104, true, false, PacketContainerSetContent.class);
        Packet.addMapping(105, true, false, PacketContainerSetData.class);
        Packet.addMapping(106, true, true, PacketContainerAck.class);
        Packet.addMapping(107, false, true, PacketUpdateCreativeInventory.class);
        Packet.addMapping(108, true, true, PacketSetHotbarOffset.class);
        Packet.addMapping(120, true, false, PacketCommandManager.class);
        Packet.addMapping(121, false, true, PacketRequestCommandManager.class);
        Packet.addMapping(130, false, true, PacketSignUpdate.class);
        Packet.addMapping(131, true, false, PacketMapData.class);
        Packet.addMapping(132, true, true, PacketSetMobSpawner.class);
        Packet.addMapping(133, false, true, PacketGuidebook.class);
        Packet.addMapping(136, true, false, PacketAESSendKey.class);
        Packet.addMapping(137, false, true, PacketSetItemName.class);
        Packet.addMapping(138, true, false, PacketPlayerList.class);
        Packet.addMapping(139, false, true, PacketSetPaintingArt.class);
        Packet.addMapping(140, true, false, PacketTileEntityData.class);
        Packet.addMapping(142, true, false, PacketFlagOpen.class);
        Packet.addMapping(143, true, false, PacketPhotoMode.class);
        Packet.addMapping(200, true, false, PacketStatistic.class);
        Packet.addMapping(201, true, false, PacketSyncIDs.class);
        Packet.addMapping(250, true, true, PacketCustomPayload.class);
        Packet.addMapping(254, false, true, PacketPingHandshake.class);
        Packet.addMapping(255, true, true, PacketDisconnect.class);
    }
}

