/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import net.minecraft.client.gui.ButtonElement;
import net.minecraft.client.gui.Screen;
import net.minecraft.client.gui.TextFieldElement;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.net.SavedServerList;
import net.minecraft.core.net.ServerData;
import org.lwjgl.input.Keyboard;

public class ScreenAddServer
extends Screen {
    private ButtonElement buttonSave;
    private ButtonElement buttonCancel;
    private ButtonElement buttonShowIp;
    private TextFieldElement ipTextField;
    private TextFieldElement serverNameTextField;
    private SavedServerList serverList;
    private boolean showIp = true;

    public ScreenAddServer(Screen guiscreen, SavedServerList serverList) {
        super(guiscreen);
        this.serverList = serverList;
    }

    @Override
    public void tick() {
        this.ipTextField.updateCursorCounter();
        this.serverNameTextField.updateCursorCounter();
    }

    @Override
    public void init() {
        I18n stringtranslate = I18n.getInstance();
        Keyboard.enableRepeatEvents(true);
        this.buttons.clear();
        this.buttonSave = new ButtonElement(0, this.width / 2 - 100, this.height / 4 + 96 + 12, stringtranslate.translateKey("gui.add_server.button.save"));
        this.buttons.add(this.buttonSave);
        this.buttonCancel = new ButtonElement(1, this.width / 2 - 100, this.height / 4 + 120 + 12, stringtranslate.translateKey("gui.add_server.button.cancel"));
        this.buttons.add(this.buttonCancel);
        this.serverNameTextField = new TextFieldElement(this, this.font, this.width / 2 - 100, this.height / 4 - 10 + 18, 200, 20, "", "");
        this.serverNameTextField.isFocused = true;
        this.serverNameTextField.setMaxStringLength(32);
        this.ipTextField = new TextFieldElement(this, this.font, this.width / 2 - 100, this.height / 4 - 10 + 50 + 18, 200, 20, "", "");
        this.ipTextField.setMaxStringLength(128);
        this.buttonShowIp = new ButtonElement(2, this.width / 2 - 100, this.height / 4 - 10 + 50 + 18 + 20 + 4, 200, 20, this.getShowIpLabel());
        this.buttons.add(this.buttonShowIp);
        this.buttonSave.enabled = false;
    }

    private String getShowIpLabel() {
        return I18n.getInstance().translateKeyAndFormat("gui.add_server.button.show_ip", this.showIp ? I18n.getInstance().translateKey("gui.add_server.button.show_ip.on") : I18n.getInstance().translateKey("gui.add_server.button.show_ip.off"));
    }

    @Override
    public void removed() {
        Keyboard.enableRepeatEvents(false);
    }

    @Override
    protected void buttonClicked(ButtonElement button) {
        if (!button.enabled) {
            return;
        }
        if (button.id == 1) {
            this.mc.displayScreen(this.parentScreen);
        } else if (button.id == 0) {
            String serverName = this.serverNameTextField.getText().trim();
            String ipText = this.ipTextField.getText().trim();
            if (serverName.isEmpty()) {
                serverName = "Minecraft Server";
            }
            this.serverList.servers.add(new ServerData(serverName, ipText, this.showIp));
            this.serverList.writeToFile();
            this.mc.displayScreen(this.parentScreen);
        } else if (button.id == 2) {
            this.showIp = !this.showIp;
            this.buttonShowIp.displayString = this.getShowIpLabel();
        }
    }

    @Override
    public void keyPressed(char eventCharacter, int eventKey, int mx, int my) {
        if (eventKey != Keyboard.KEY_BACK) {
            super.keyPressed(eventCharacter, eventKey, mx, my);
        }
        if (eventKey == Keyboard.KEY_TAB) {
            if (!this.ipTextField.isFocused && !this.serverNameTextField.isFocused) {
                this.serverNameTextField.isFocused = true;
            } else {
                this.ipTextField.isFocused = !this.ipTextField.isFocused;
                this.serverNameTextField.isFocused = !this.serverNameTextField.isFocused;
            }
            return;
        }
        if (eventKey == Keyboard.KEY_RETURN && this.buttonSave.enabled) {
            this.buttonClicked(this.buttonSave);
        }
        if (this.ipTextField.isFocused) {
            this.ipTextField.textboxKeyTyped(eventCharacter, eventKey);
        }
        if (this.serverNameTextField.isFocused) {
            this.serverNameTextField.textboxKeyTyped(eventCharacter, eventKey);
        }
        this.buttonSave.enabled = this.ipTextField.getText().length() > 0;
    }

    @Override
    public void mouseClicked(int mx, int my, int buttonNum) {
        super.mouseClicked(mx, my, buttonNum);
        this.ipTextField.mouseClicked(mx, my, buttonNum);
        this.serverNameTextField.mouseClicked(mx, my, buttonNum);
    }

    @Override
    public void render(int mx, int my, float partialTick) {
        I18n stringtranslate = I18n.getInstance();
        this.renderBackground();
        this.drawStringCentered(this.font, stringtranslate.translateKey("gui.add_server.label.title"), this.width / 2, this.height / 4 - 60 + 20, 0xFFFFFF);
        this.drawString(this.font, stringtranslate.translateKey("gui.add_server.label.server_name"), this.serverNameTextField.xPosition, this.serverNameTextField.yPosition - 14, 0xA0A0A0);
        this.drawString(this.font, stringtranslate.translateKey("gui.add_server.label.ip_address"), this.ipTextField.xPosition, this.ipTextField.yPosition - 14, 0xA0A0A0);
        this.ipTextField.drawTextBox();
        this.serverNameTextField.drawTextBox();
        super.render(mx, my, partialTick);
    }
}

