/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.option;

import com.mojang.logging.LogUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.ScaledResolution;
import net.minecraft.client.discord.RichPresenceHandlerThread;
import net.minecraft.client.gui.hud.component.HudComponents;
import net.minecraft.client.input.InputDevice;
import net.minecraft.client.option.KeyBinding;
import net.minecraft.client.option.Option;
import net.minecraft.client.option.OptionBoolean;
import net.minecraft.client.option.OptionColor;
import net.minecraft.client.option.OptionEnum;
import net.minecraft.client.option.OptionFloat;
import net.minecraft.client.option.OptionImmersiveMode;
import net.minecraft.client.option.OptionInteger;
import net.minecraft.client.option.OptionRange;
import net.minecraft.client.option.OptionString;
import net.minecraft.client.option.OptionVolume;
import net.minecraft.client.option.enums.Colorblindness;
import net.minecraft.client.option.enums.LightmapStyle;
import net.minecraft.client.option.enums.MipmapType;
import net.minecraft.client.option.enums.RenderScale;
import net.minecraft.client.option.enums.TooltipStyle;
import net.minecraft.core.enums.ChatVisibility;
import net.minecraft.core.enums.Difficulty;
import net.minecraft.core.enums.PlacementMode;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.sound.SoundCategory;
import net.minecraft.core.util.helper.Color;
import net.minecraft.core.util.helper.ITranslatable;
import org.lwjgl.input.Keyboard;
import org.slf4j.Logger;

public class GameSettings {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final String[] ANIMATIONS = new String[]{"options.animations.off", "options.animations.procedural", "options.animations.custom"};
    public final Minecraft mc;
    private final File optionsFile;
    public OptionInteger windowWidth = new OptionInteger(this, "windowWidth", 854);
    public OptionInteger windowHeight = new OptionInteger(this, "windowHeight", 480);
    public OptionVolume masterVolume = new OptionVolume(this, "sound.master", 1.0f, SoundCategory.GUI_SOUNDS);
    public OptionVolume musicVolume = new OptionVolume(this, "sound.music", 1.0f, SoundCategory.MUSIC);
    public OptionVolume worldSoundsVolume = new OptionVolume(this, "sound.world", 1.0f, SoundCategory.WORLD_SOUNDS);
    public OptionVolume entitySoundsVolume = new OptionVolume(this, "sound.entity", 1.0f, SoundCategory.ENTITY_SOUNDS);
    public OptionVolume caveSoundsVolume = new OptionVolume(this, "sound.cave", 1.0f, SoundCategory.CAVE_SOUNDS);
    public OptionVolume guiSoundsVolume = new OptionVolume(this, "sound.gui", 1.0f, SoundCategory.GUI_SOUNDS);
    public OptionVolume weatherSoundsVolume = new OptionVolume(this, "sound.weather", 1.0f, SoundCategory.WEATHER_SOUNDS);
    public OptionFloat FoV = new OptionFloat(this, "fov", 0.40140846f);
    public OptionFloat mouseSensitivity = new OptionFloat(this, "mouseSensitivity", 0.5f);
    public OptionFloat screenPadding = new OptionFloat(this, "screenPadding", 0.0f);
    public OptionFloat gamma = new OptionFloat(this, "gamma", 0.5f);
    public OptionFloat brightness = new OptionFloat(this, "brightness", 0.5f);
    public OptionFloat fxaa = new OptionFloat(this, "fxaa", 0.0f);
    public OptionFloat controllerSensitivity = new OptionFloat(this, "controllerSensitivity", 0.5f);
    public OptionFloat controllerMenuSensitivity = new OptionFloat(this, "controllerMenuSensitivity", 0.5f);
    public OptionFloat controllerDeadzoneLeft = new OptionFloat(this, "controllerDeadzoneL", 0.25f);
    public OptionFloat controllerDeadzoneRight = new OptionFloat(this, "controllerDeadzoneR", 0.25f);
    public OptionFloat blockOutlineWidth = new OptionFloat(this, "blockOutlineWidth", 0.25f);
    public OptionFloat flightSpeed = new OptionFloat(this, "flightSpeed", 0.5f);
    public OptionFloat flightSmoothness = new OptionFloat(this, "flightSmoothness", 0.5f);
    public OptionBoolean invertMouse = new OptionBoolean(this, "invertYMouse", false);
    public OptionBoolean rawMouseInput = new OptionBoolean(this, "rawMouseInput", false);
    public OptionBoolean viewBobbing = new OptionBoolean(this, "bobView", true);
    public OptionBoolean advancedOpenGL = new OptionBoolean(this, "advancedOpengl", false);
    public OptionRange fancyGraphics = new OptionRange(this, "fancyGraphics", 1, 2);
    public OptionBoolean treeShadows = new OptionBoolean(this, "treeShadows", true);
    public OptionBoolean ambientOcclusion = new OptionBoolean(this, "ambientOcclusion", true);
    public OptionBoolean items3D = new OptionBoolean(this, "3Ditems", false);
    public OptionBoolean smoothCamera = new OptionBoolean(this, "smoothCamera", false);
    public OptionBoolean lockCamera = new OptionBoolean(this, "lockCamera", false);
    public OptionBoolean biomeWater = new OptionBoolean(this, "biomeWater", true);
    public OptionBoolean vignette = new OptionBoolean(this, "vignette", true);
    public OptionBoolean showPlayerList = new OptionBoolean(this, "showPlayerList", false);
    public OptionBoolean slimeParticles = new OptionBoolean(this, "slimeParticles", true);
    public OptionBoolean disableShaders = new OptionBoolean(this, "disableShaders", false);
    public OptionString shaderOverride = new OptionString(this, "shaderOverride", "");
    public OptionBoolean autoHit = new OptionBoolean(this, "autoHit", true);
    public OptionBoolean easyBridge = new OptionBoolean(this, "easyBridge", true);
    public OptionBoolean foodHealthRegenOverlay = new OptionBoolean(this, "foodHealthRegenOverlay", true);
    public OptionBoolean fpsInOverlay = new OptionBoolean(this, "fpsInOverlay", false);
    public OptionBoolean versionInOverlay = new OptionBoolean(this, "versionInOverlay", false);
    public OptionBoolean controllerSwapShoulderButtons = new OptionBoolean(this, "controllerSwapShoulderButtons", false);
    public OptionBoolean controllerSwapAB = new OptionBoolean(this, "controllerSwapAB", false);
    public OptionBoolean controllerSwapXY = new OptionBoolean(this, "controllerSwapXY", false);
    public OptionBoolean clouds = new OptionBoolean(this, "clouds", true);
    public OptionFloat cloudHeight = new OptionFloat(this, "cloudHeight", 0.0f);
    public OptionBoolean armorDurabilityOverlay = new OptionBoolean(this, "armorDurabilityOverlay", false);
    public OptionBoolean armorProtectionOverlay = new OptionBoolean(this, "armorProtectionOverlay", true);
    public OptionBoolean heldItemCountOverlay = new OptionBoolean(this, "heldItemCountOverlay", false);
    public OptionBoolean pauseOnLostFocus = new OptionBoolean(this, "pauseOnLostFocus", true);
    public OptionBoolean showDebugScreen = new OptionBoolean(this, "showDebugScreen", false);
    public OptionBoolean showFrameTimes = new OptionBoolean(this, "showFrameTimes", false);
    public OptionBoolean showItemDebugInfo = new OptionBoolean(this, "showItemDebugInfo", false);
    public OptionBoolean showChunkBorders = new OptionBoolean(this, "showChunkBorders", false);
    public OptionBoolean showCollisionBoxes = new OptionBoolean(this, "showCollisionBoxes", false);
    public OptionBoolean swapCraftingButtons = new OptionBoolean(this, "swapCraftingButtons", false);
    public OptionBoolean forceUnicodeFont = new OptionBoolean(this, "forceUnicodeFont", false);
    public OptionEnum<PlacementMode> placementMode = new OptionEnum<PlacementMode>(this, "placementMode", PlacementMode.class, PlacementMode.DEFAULT).setIsSlider(false);
    public OptionBoolean discordRichPresence = new OptionBoolean(this, "discordRichPresence", false);
    public OptionImmersiveMode immersiveMode = new OptionImmersiveMode(this);
    public OptionColor guiBackgroundColor = new OptionColor(this, "guiBackgroundColor", new Color().setARGB(-1072689136));
    public OptionEnum<Difficulty> difficulty = new OptionEnum<Difficulty>(this, "difficulty", Difficulty.class, Difficulty.NORMAL);
    public OptionInteger thirdPersonView = new OptionInteger(this, "thirdPersonView", 0);
    public OptionRange renderDistance = new OptionRange(this, "renderDistance", 12, 2, 32);
    public OptionBoolean enableVsync = new OptionBoolean(this, "enableVsync", false);
    public OptionEnum<ChatVisibility> chatVisibility = new OptionEnum<ChatVisibility>(this, "chatVisibility", ChatVisibility.class, ChatVisibility.SHOW_ALL);
    public OptionRange customFpsLimit = new OptionRange(this, "customFpsLimit", 0, 241);
    public OptionInteger guiScale = new OptionInteger(this, "guiScale", 0);
    public OptionInteger overlayMode = new OptionInteger(this, "overlayMode", 0);
    public OptionInteger rotationOverlayMode = new OptionInteger(this, "rotationOverlayMode", 0);
    public OptionRange animations = new OptionRange(this, "animations", 2, 3);
    public OptionBoolean customAnimations = new OptionBoolean(this, "customAnimations", true);
    public OptionInteger playerListPosition = new OptionInteger(this, "playerListPosition", 2);
    public OptionBoolean heldItemTooltips = new OptionBoolean(this, "heldItemTooltips", true);
    public OptionFloat colorCorrection = new OptionFloat(this, "colorCorrection", 0.5f);
    public OptionBoolean sneakToggle = new OptionBoolean(this, "sneakToggle", false);
    public OptionFloat autosaveTimer = new OptionFloat(this, "autosaveTimer", 0.041666668f);
    public OptionBoolean enableItemDragging = new OptionBoolean(this, "enableItemDragging", true);
    public OptionRange bloom = new OptionRange(this, "bloom", 0, 3);
    public OptionEnum<RenderScale> renderScale = new OptionEnum<RenderScale>(this, "renderScale", RenderScale.class, RenderScale.SCALE_100);
    public OptionBoolean heatHaze = new OptionBoolean(this, "heatHaze", false);
    public OptionBoolean alphaMenu = new OptionBoolean(this, "old", false);
    public OptionBoolean enableItemClumping = new OptionBoolean(this, "enableItemClumping", true);
    public OptionBoolean alwaysShowDescriptions = new OptionBoolean(this, "alwaysShowDescriptions", false);
    public OptionBoolean turnWithVehicle = new OptionBoolean(this, "turnWithVehicle", true);
    public OptionBoolean disableCrashHandler = new OptionBoolean(this, "disableCrashHandler", false);
    public OptionBoolean enableDevResourceLoading = new OptionBoolean(this, "enableDevResourceLoading", false);
    public OptionBoolean downloadSoundfiles = new OptionBoolean(this, "downloadSoundfiles", true);
    public OptionBoolean allowSoundOverrides = new OptionBoolean(this, "allowSoundOverrides", false);
    public OptionBoolean loadAllSounds = new OptionBoolean(this, "loadAllSounds", false);
    public OptionBoolean overlayShowCoords = new OptionBoolean(this, "overlayShowCoords", true);
    public OptionBoolean overlayShowDirection = new OptionBoolean(this, "overlayShowDirection", true);
    public OptionBoolean overlayShowTime = new OptionBoolean(this, "overlayShowTime", true);
    public OptionBoolean overlayShowSeason = new OptionBoolean(this, "overlayShowSeason", true);
    public OptionBoolean overlayShowWeather = new OptionBoolean(this, "overlayShowWeather", true);
    public OptionBoolean overlayShowBiome = new OptionBoolean(this, "overlayShowBiome", true);
    public OptionBoolean[] overlayElements = new OptionBoolean[]{this.overlayShowCoords, this.overlayShowDirection, this.overlayShowTime, this.overlayShowSeason, this.overlayShowWeather, this.overlayShowBiome};
    public OptionString lastServer = new OptionString(this, "lastServer", "");
    public OptionString skin = new OptionString(this, "skin", "Default");
    public OptionString selectedController = new OptionString(this, "selectedController", "");
    public OptionString language = new OptionString(this, "language", "en_US");
    public OptionRange mipmapLevels = new OptionRange(this, "mipmapLevels", 0, 5);
    public OptionEnum<MipmapType> mipmapType = new OptionEnum<MipmapType>(this, "mipmapType", MipmapType.class, MipmapType.SMOOTH);
    public OptionBoolean fovModification = new OptionBoolean(this, "fov.modification", true);
    public OptionBoolean screenMotionEffects = new OptionBoolean(this, "screen.motion.effects", true);
    public OptionBoolean fullscreen = new OptionBoolean(this, "fullscreen", Minecraft.isClientASteamDeck());
    public OptionBoolean borderlessFullscreen = new OptionBoolean(this, "borderlessFullscreen", true);
    public OptionBoolean startInFullscreen = new OptionBoolean(this, "startInFullscreen", true);
    public OptionEnum<TooltipStyle> tooltipStyle = new OptionEnum<TooltipStyle>(this, "tooltipStyle", TooltipStyle.class);
    public OptionEnum<LightmapStyle> lightmapStyle = new OptionEnum<LightmapStyle>(this, "lightmapStyle", LightmapStyle.class, LightmapStyle.GRAY);
    public OptionBoolean customLightmap = new OptionBoolean(this, "customLightmap", true);
    public OptionBoolean fog = new OptionBoolean(this, "fog", true);
    public OptionBoolean hideUndiscoveredItems = new OptionBoolean(this, "hideUndiscoveredItems", true);
    public OptionBoolean muteOnLostFocus = new OptionBoolean(this, "muteOnLostFocus", false);
    public OptionBoolean aurora = new OptionBoolean(this, "aurora", true);
    public OptionBoolean mobVariants = new OptionBoolean(this, "mobVariants", true);
    public OptionEnum<Colorblindness> colorblindnessFix = new OptionEnum<Colorblindness>(this, "colorblindnessFix", Colorblindness.class, Colorblindness.NONE);
    public OptionBoolean subtitles = new OptionBoolean(this, "subtitles", false);
    public OptionBoolean enableHolidayTextures = new OptionBoolean(this, "enableHolidayTextures", true);
    public KeyBinding keyAttack = new KeyBinding("key.attack").setDefault(InputDevice.mouse, 0);
    public KeyBinding keyInteract = new KeyBinding("key.interact").setDefault(InputDevice.mouse, 1);
    public KeyBinding keyPickBlock = new KeyBinding("key.pickBlock").setDefault(InputDevice.mouse, 2);
    public KeyBinding keySortInventory = new KeyBinding("key.sortInventory").setDefault(InputDevice.mouse, 2);
    public KeyBinding keyForward = new KeyBinding("key.forward").setDefault(InputDevice.keyboard, Keyboard.KEY_W);
    public KeyBinding keyLeft = new KeyBinding("key.left").setDefault(InputDevice.keyboard, Keyboard.KEY_A);
    public KeyBinding keyBack = new KeyBinding("key.back").setDefault(InputDevice.keyboard, Keyboard.KEY_S);
    public KeyBinding keyRight = new KeyBinding("key.right").setDefault(InputDevice.keyboard, Keyboard.KEY_D);
    public KeyBinding keyJump = new KeyBinding("key.jump").setDefault(InputDevice.keyboard, Keyboard.KEY_SPACE);
    public KeyBinding keyInventory = new KeyBinding("key.inventory").setDefault(InputDevice.keyboard, Keyboard.KEY_E);
    public KeyBinding keyDrop = new KeyBinding("key.drop").setDefault(InputDevice.keyboard, Keyboard.KEY_Q);
    public KeyBinding keyChat = new KeyBinding("key.chat").setDefault(InputDevice.keyboard, Keyboard.KEY_T);
    public KeyBinding keyCommand = new KeyBinding("key.command").setDefault(InputDevice.keyboard, Keyboard.KEY_SLASH);
    public KeyBinding keyToggleFog = new KeyBinding("key.fog").setDefault(InputDevice.keyboard, Keyboard.KEY_F);
    public KeyBinding keyToggleGamma = new KeyBinding("key.gamma").setDefault(InputDevice.keyboard, Keyboard.KEY_G);
    public KeyBinding keySneak = new KeyBinding("key.sneak").setDefault(InputDevice.keyboard, Keyboard.KEY_LSHIFT);
    public KeyBinding keyFly = new KeyBinding("key.fly").setDefault(InputDevice.keyboard, Keyboard.KEY_LCONTROL);
    public KeyBinding keyGuidebook = new KeyBinding("key.guidebook").setDefault(InputDevice.keyboard, Keyboard.KEY_R);
    public KeyBinding keyShowRecipe = new KeyBinding("key.showRecipe").setDefault(InputDevice.keyboard, Keyboard.KEY_R);
    public KeyBinding keyShowUsage = new KeyBinding("key.showUsage").setDefault(InputDevice.keyboard, Keyboard.KEY_U);
    public KeyBinding keyHotBarLeft = new KeyBinding("key.hotbar.left").setDefault(InputDevice.keyboard, Keyboard.KEY_COMMA);
    public KeyBinding keyHotBarRight = new KeyBinding("key.hotbar.right").setDefault(InputDevice.keyboard, Keyboard.KEY_PERIOD);
    public KeyBinding keyHotBarSwitch = new KeyBinding("key.hotbar.switch").setDefault(InputDevice.keyboard, Keyboard.KEY_TAB);
    public KeyBinding keyHotBarSlot1 = new KeyBinding("key.hotbar.1").setDefault(InputDevice.keyboard, Keyboard.KEY_1);
    public KeyBinding keyHotBarSlot2 = new KeyBinding("key.hotbar.2").setDefault(InputDevice.keyboard, Keyboard.KEY_2);
    public KeyBinding keyHotBarSlot3 = new KeyBinding("key.hotbar.3").setDefault(InputDevice.keyboard, Keyboard.KEY_3);
    public KeyBinding keyHotBarSlot4 = new KeyBinding("key.hotbar.4").setDefault(InputDevice.keyboard, Keyboard.KEY_4);
    public KeyBinding keyHotBarSlot5 = new KeyBinding("key.hotbar.5").setDefault(InputDevice.keyboard, Keyboard.KEY_5);
    public KeyBinding keyHotBarSlot6 = new KeyBinding("key.hotbar.6").setDefault(InputDevice.keyboard, Keyboard.KEY_6);
    public KeyBinding keyHotBarSlot7 = new KeyBinding("key.hotbar.7").setDefault(InputDevice.keyboard, Keyboard.KEY_7);
    public KeyBinding keyHotBarSlot8 = new KeyBinding("key.hotbar.8").setDefault(InputDevice.keyboard, Keyboard.KEY_8);
    public KeyBinding keyHotBarSlot9 = new KeyBinding("key.hotbar.9").setDefault(InputDevice.keyboard, Keyboard.KEY_9);
    public KeyBinding keyLookLeft = new KeyBinding("key.look.left").setDefault(InputDevice.keyboard, Keyboard.KEY_LEFT);
    public KeyBinding keyLookRight = new KeyBinding("key.look.right").setDefault(InputDevice.keyboard, Keyboard.KEY_RIGHT);
    public KeyBinding keyLookUp = new KeyBinding("key.look.up").setDefault(InputDevice.keyboard, Keyboard.KEY_UP);
    public KeyBinding keyLookDown = new KeyBinding("key.look.down").setDefault(InputDevice.keyboard, Keyboard.KEY_DOWN);
    public KeyBinding keyCenterView = new KeyBinding("key.look.center").setDefault(InputDevice.keyboard, Keyboard.KEY_END);
    public KeyBinding keyZoom = new KeyBinding("key.zoom").setDefault(InputDevice.keyboard, Keyboard.KEY_C);
    public KeyBinding keyPlayerList = new KeyBinding("key.playerList").setDefault(InputDevice.keyboard, Keyboard.KEY_L);
    public KeyBinding keyPhotoMode = new KeyBinding("key.photoMode").setDefault(InputDevice.keyboard, Keyboard.KEY_P);
    public KeyBinding keyLockRotation = new KeyBinding("key.lockRotation").setDefault(InputDevice.keyboard, Keyboard.KEY_Z);
    public KeyBinding keyScreenshot = new KeyBinding("key.screenshot").setDefault(InputDevice.keyboard, Keyboard.KEY_F2);
    public KeyBinding keyCinematicCamera = new KeyBinding("key.cinematicCamera").setDefault(InputDevice.keyboard, Keyboard.KEY_F8);
    public KeyBinding keySwitchPerspective = new KeyBinding("key.switchPerspective").setDefault(InputDevice.keyboard, Keyboard.KEY_F5);
    public KeyBinding keyHideGui = new KeyBinding("key.immersiveMode").setDefault(InputDevice.keyboard, Keyboard.KEY_F1);
    public KeyBinding keyAutoWalk = new KeyBinding("key.autoWalk");
    public KeyBinding keySprint = new KeyBinding("key.sprint");
    public KeyBinding keyToggleOverlay = new KeyBinding("key.toggleOverlay").setDefault(InputDevice.keyboard, Keyboard.KEY_F4);
    public KeyBinding keyOpenAchievements = new KeyBinding("key.openAchievements");
    public KeyBinding keyOpenStatistics = new KeyBinding("key.openStatistics");
    public List<KeyBinding> debugsKeys = new ArrayList<KeyBinding>();
    public KeyBinding keyToggleDebug = new KeyBinding("key.toggleDebug").setDefault(InputDevice.keyboard, Keyboard.KEY_F3);
    public KeyBinding keyReload = new KeyBinding("key.debug.reload").setDefault(InputDevice.keyboard, Keyboard.KEY_R);
    public KeyBinding keySwitchGamemode = new KeyBinding("key.debug.gamemode").setDefault(InputDevice.keyboard, Keyboard.KEY_N);
    public KeyBinding keyDumpTextures = new KeyBinding("key.debug.dumptextures").setDefault(InputDevice.keyboard, Keyboard.KEY_D);
    public KeyBinding keyFullbright = new KeyBinding("key.debug.fullbright").setDefault(InputDevice.keyboard, Keyboard.KEY_F);
    public KeyBinding keyLightmaps = new KeyBinding("key.debug.lightmap").setDefault(InputDevice.keyboard, Keyboard.KEY_L);
    public KeyBinding keyCollisionBoxes = new KeyBinding("key.debug.collision").setDefault(InputDevice.keyboard, Keyboard.KEY_B);
    public KeyBinding keyChunkBorders = new KeyBinding("key.debug.chunkborders").setDefault(InputDevice.keyboard, Keyboard.KEY_G);
    public KeyBinding keyClearChat = new KeyBinding("key.debug.clearchat").setDefault(InputDevice.keyboard, Keyboard.KEY_C);
    public KeyBinding keyPauseLostFocus = new KeyBinding("key.debug.pauseFocus").setDefault(InputDevice.keyboard, Keyboard.KEY_P);
    public KeyBinding keyToggleItemInfo = new KeyBinding("key.debug.iteminfo").setDefault(InputDevice.keyboard, Keyboard.KEY_H);
    public KeyBinding keyReloadChunks = new KeyBinding("key.debug.reloadchunks").setDefault(InputDevice.keyboard, Keyboard.KEY_A);
    public KeyBinding keySmoothLighting = new KeyBinding("key.debug.smoothlighting").setDefault(InputDevice.keyboard, Keyboard.KEY_S);
    public KeyBinding keyReleaseCursor = new KeyBinding("key.debug.releasecursor").setDefault(InputDevice.keyboard, Keyboard.KEY_F12);
    public KeyBinding keyShowShortcuts = new KeyBinding("key.debug.shortcuts").setDefault(InputDevice.keyboard, Keyboard.KEY_Q);
    public KeyBinding keyToggleTextureAtlas = new KeyBinding("key.debug.textureAtlas");
    public KeyBinding keyLoadChunksQuickly = new KeyBinding("key.debug.loadChunksQuickly");
    public static final List<KeyBinding> keys = new ArrayList<KeyBinding>();
    public static final List<Option<?>> options = new ArrayList();

    public List<Option<?>> getAllOptions() {
        return options;
    }

    public KeyBinding getKey(int i) {
        return keys.get(i);
    }

    public String getKeyBindName(int id) {
        return I18n.getInstance().translateKey(this.getKey(id).getId());
    }

    public GameSettings(Minecraft minecraft, File file) {
        this.mc = minecraft;
        this.optionsFile = new File(file, "options.txt");
        this.loadOptions();
        this.saveOptions();
        this.debugsKeys.add(this.keyShowShortcuts);
        this.debugsKeys.add(this.keyReload);
        this.debugsKeys.add(this.keySwitchGamemode);
        this.debugsKeys.add(this.keyDumpTextures);
        this.debugsKeys.add(this.keyFullbright);
        this.debugsKeys.add(this.keyLightmaps);
        this.debugsKeys.add(this.keyCollisionBoxes);
        this.debugsKeys.add(this.keyChunkBorders);
        this.debugsKeys.add(this.keyClearChat);
        this.debugsKeys.add(this.keyPauseLostFocus);
        this.debugsKeys.add(this.keyToggleItemInfo);
        this.debugsKeys.add(this.keyReloadChunks);
        this.debugsKeys.add(this.keySmoothLighting);
    }

    public String getDisplayString(Option<?> option) {
        if (option == null) {
            return "";
        }
        I18n trans = I18n.getInstance();
        if (option instanceof OptionFloat) {
            OptionFloat optionFloat = (OptionFloat)option;
            float value = ((Float)optionFloat.value).floatValue();
            if (option == this.brightness) {
                int percent = (int)(value * 200.0f);
                if (percent == 0) {
                    return trans.translateKey("options.brightness.min");
                }
                if (percent == 100) {
                    return trans.translateKey("options.brightness.default");
                }
                if (percent == 200) {
                    return trans.translateKey("options.brightness.max");
                }
                return percent + "%";
            }
            if (option == this.mouseSensitivity) {
                if (value == 0.0f) {
                    return trans.translateKey("options.mouseSensitivity.min");
                }
                if (value == 1.0f) {
                    return trans.translateKey("options.mouseSensitivity.max");
                }
                return (int)(value * 200.0f) + "%";
            }
            if (option == this.FoV) {
                if (value == 0.0f) {
                    return trans.translateKey("options.fov.min");
                }
                if (value == 1.0f) {
                    return trans.translateKey("options.fov.max");
                }
                return (int)(value * 100.0f + 30.0f) + "\u00b0";
            }
            if (option == this.screenPadding) {
                int percent = (int)(value * 100.0f);
                return percent + "%";
            }
            if (option == this.gamma) {
                int percent = (int)(value * 200.0f);
                return percent + "%";
            }
            if (option == this.autosaveTimer) {
                int timer = (int)(value * 24.0f);
                if (timer == 0) {
                    return trans.translateKey("options.autosaveTimer.off");
                }
                return timer * 5 + " seconds";
            }
            if (option == this.cloudHeight) {
                int percent = (int)(value * 100.0f + 100.0f);
                if (percent == 100) {
                    return trans.translateKey("options.cloudHeight.default");
                }
                return percent + "%";
            }
            if (value == 0.0f) {
                return trans.translateKey("options.off");
            }
            return (int)(value * 100.0f) + "%";
        }
        if (option == this.guiScale) {
            if ((Integer)this.guiScale.value == 0) {
                return trans.translateKey("options.guiScale.auto");
            }
            return this.guiScale.value + "x";
        }
        if (option == this.customFpsLimit) {
            int value = (Integer)this.customFpsLimit.value;
            int maxValue = 240;
            if (((Boolean)this.enableVsync.value).booleanValue()) {
                return String.valueOf(this.mc.gameWindow.getFrequency());
            }
            if (value > maxValue) {
                this.customFpsLimit.set(maxValue);
            }
            if (value < 15) {
                this.customFpsLimit.set(0);
                return trans.translateKey("options.customFpsLimit.unlimited");
            }
        }
        if (option == this.animations) {
            return trans.translateKey(ANIMATIONS[(Integer)this.animations.value]);
        }
        if (option == this.fancyGraphics) {
            if ((Integer)this.fancyGraphics.value == 1) {
                return trans.translateKey("options.graphics.fancy");
            }
            return trans.translateKey("options.graphics.fast");
        }
        if (option == this.lightmapStyle) {
            return trans.translateKey(((LightmapStyle)((Object)this.lightmapStyle.value)).getTranslationKey());
        }
        if (option == this.bloom) {
            if ((Integer)this.bloom.value == 0) {
                return trans.translateKey("options.off");
            }
            if ((Integer)this.bloom.value == 1) {
                return trans.translateKey("options.bloom.low");
            }
            if ((Integer)this.bloom.value == 2) {
                return trans.translateKey("options.bloom.high");
            }
        }
        if (option instanceof OptionBoolean) {
            Boolean flag = (Boolean)option.value;
            if (flag.booleanValue()) {
                return trans.translateKey("options.on");
            }
            return trans.translateKey("options.off");
        }
        if (option instanceof OptionEnum) {
            String key;
            OptionEnum optionEnum = (OptionEnum)option;
            if (optionEnum.value instanceof ITranslatable) {
                ITranslatable translatable = (ITranslatable)optionEnum.value;
                key = translatable.getTranslationKey();
            } else {
                key = ((Enum)optionEnum.value).toString().toLowerCase();
            }
            return trans.translateKey("options." + optionEnum.name + "." + key);
        }
        return option.value.toString();
    }

    public void optionChanged(Option<?> option) {
        int max;
        if (option == null) {
            return;
        }
        if (option == this.difficulty && this.mc.currentWorld != null) {
            this.mc.currentWorld.setDifficulty((Difficulty)((Object)this.difficulty.value), false);
        }
        if (option == this.enableVsync) {
            this.mc.gameWindow.setVsync((Boolean)this.enableVsync.value);
        }
        if (option == this.fancyGraphics) {
            this.mc.renderGlobal.loadRenderers();
        }
        if (option == this.ambientOcclusion) {
            this.mc.renderGlobal.loadRenderers();
        }
        if (option == this.advancedOpenGL) {
            this.mc.renderGlobal.loadRenderers();
        }
        if (option == this.biomeWater) {
            this.mc.renderGlobal.loadRenderers();
            this.mc.textureManager.updateDynamicTextures(false);
        }
        if (option == this.treeShadows) {
            this.mc.renderGlobal.loadRenderers();
        }
        if (option == this.placementMode && this.mc.thePlayer != null) {
            this.mc.thePlayer.syncPlacementMode();
        }
        if (option == this.animations || option == this.customAnimations) {
            this.mc.textureManager.refreshTexturesAndDisplayErrors();
            this.mc.textureManager.updateDynamicTextures(false);
            this.mc.renderGlobal.loadRenderers();
        }
        if (option == this.fullscreen) {
            this.mc.gameWindow.updateWindowState();
        }
        if (option == this.borderlessFullscreen && ((Boolean)this.fullscreen.value).booleanValue()) {
            this.mc.gameWindow.updateWindowState();
        }
        if (option == this.guiScale) {
            ScaledResolution cfr_ignored_0 = this.mc.resolution;
            max = ScaledResolution.getMaxScale(this.mc.gameWindow.getWidthScreenCoords(), this.mc.gameWindow.getHeightScreenCoords());
            this.guiScale.value = ((Integer)this.guiScale.value + max) % max;
            this.mc.resolution.setScale((Integer)this.guiScale.value);
            if (this.mc.currentScreen != null) {
                this.mc.currentScreen.opened(this.mc, this.mc.resolution.getScaledWidthScreenCoords(), this.mc.resolution.getScaledHeightScreenCoords());
            }
        }
        if (option == this.mipmapType || option == this.mipmapLevels) {
            this.mc.textureManager.refreshTexturesAndDisplayErrors();
        }
        if (option == this.autosaveTimer) {
            max = 24;
            this.autosaveTimer.value = Float.valueOf((((Float)this.autosaveTimer.value).floatValue() + (float)max) % (float)max);
        }
        if (option == this.discordRichPresence && ((Boolean)this.discordRichPresence.value).booleanValue() && this.mc.rpcThread == null) {
            this.mc.rpcThread = new RichPresenceHandlerThread(this.mc);
            this.mc.rpcThread.start();
        }
        if (option == this.language && this.mc.currentScreen != null) {
            this.mc.currentScreen.opened(this.mc, this.mc.resolution.getScaledWidthScreenCoords(), this.mc.resolution.getScaledHeightScreenCoords());
        }
        if (option == this.lightmapStyle && this.mc.renderGlobal != null) {
            this.mc.renderGlobal.loadRenderers();
        }
        if (option == this.customLightmap) {
            this.mc.worldRenderer.lightmapHelper.setup();
        }
        if (option == this.rawMouseInput) {
            this.mc.mouseInput.setRawInput((Boolean)this.rawMouseInput.value);
        }
        if (option == this.enableHolidayTextures) {
            this.mc.textureManager.refreshTexturesAndDisplayErrors();
            this.mc.renderGlobal.loadRenderers();
        }
    }

    public void loadOptions() {
        HudComponents.DEFAULT_LAYOUT = HudComponents.INSTANCE.toSettingsString();
        if (!this.optionsFile.exists()) {
            return;
        }
        try {
            String line;
            BufferedReader br = new BufferedReader(new FileReader(this.optionsFile));
            block4: while ((line = br.readLine()) != null) {
                try {
                    int i = line.indexOf(58);
                    String key = line.substring(0, i);
                    String value = line.substring(i + 1);
                    if (key.equals("hudLayout")) {
                        HudComponents.INSTANCE.fromSettingsString(value);
                        continue;
                    }
                    for (Option<?> option : this.getAllOptions()) {
                        if (!option.name.equalsIgnoreCase(key)) continue;
                        option.parse(value);
                        continue block4;
                    }
                    for (KeyBinding keyBinding : keys) {
                        if (!key.equals("key_" + keyBinding.getId())) continue;
                        keyBinding.fromOptionsString(value);
                    }
                }
                catch (Exception e) {
                    LOGGER.warn("Skipping bad option: {}", (Object)line, (Object)e);
                }
            }
            br.close();
        }
        catch (Exception e) {
            LOGGER.error("Failed to load options", e);
        }
    }

    public void saveOptions() {
        try {
            PrintWriter printwriter = new PrintWriter(new FileWriter(this.optionsFile));
            for (Option<?> option : this.getAllOptions()) {
                printwriter.println(option.name + ":" + option.getValueString());
            }
            for (KeyBinding key : keys) {
                printwriter.println("key_" + key.getId() + ":" + key.toOptionsString());
            }
            String hudComponentsString = HudComponents.INSTANCE.toSettingsString();
            if (hudComponentsString != null) {
                printwriter.println("hudLayout:" + hudComponentsString);
            }
            printwriter.close();
        }
        catch (Exception exception) {
            LOGGER.error("Failed to save options", exception);
        }
    }
}

