/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render;

import com.mojang.logging.LogUtils;
import java.awt.image.BufferedImage;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.GLAllocation;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.popup.PopupBuilder;
import net.minecraft.client.gui.popup.PopupScreen;
import net.minecraft.client.option.GameSettings;
import net.minecraft.client.render.Font;
import net.minecraft.client.render.ImageParser;
import net.minecraft.client.render.colorizer.Colorizers;
import net.minecraft.client.render.customatlas.CustomAtlasHandler;
import net.minecraft.client.render.dynamictexture.DynamicTexture;
import net.minecraft.client.render.dynamictexture.DynamicTextureCalendar;
import net.minecraft.client.render.dynamictexture.DynamicTextureClock;
import net.minecraft.client.render.dynamictexture.DynamicTextureCompass;
import net.minecraft.client.render.dynamictexture.DynamicTextureCustom;
import net.minecraft.client.render.dynamictexture.DynamicTextureFire;
import net.minecraft.client.render.dynamictexture.DynamicTextureFireflyJar;
import net.minecraft.client.render.dynamictexture.DynamicTextureLavaFlowing;
import net.minecraft.client.render.dynamictexture.DynamicTextureLavaStill;
import net.minecraft.client.render.dynamictexture.DynamicTextureTrommel;
import net.minecraft.client.render.dynamictexture.DynamicTextureWaterFlow;
import net.minecraft.client.render.dynamictexture.DynamicTextureWaterStill;
import net.minecraft.client.render.texture.Texture;
import net.minecraft.client.render.texture.TextureBuffered;
import net.minecraft.client.render.texture.TextureDownloaded;
import net.minecraft.client.render.texture.TextureFile;
import net.minecraft.client.render.texture.meta.AnimationProperties;
import net.minecraft.client.render.texture.stitcher.AtlasStitcher;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.client.render.texturepack.TexturePackException;
import net.minecraft.client.render.texturepack.TexturePackList;
import net.minecraft.client.util.helper.Colors;
import net.minecraft.client.util.helper.Textures;
import net.minecraft.core.block.material.MaterialColor;
import net.minecraft.core.util.collection.NamespaceID;
import net.minecraft.core.util.helper.Buffer;
import net.minecraft.core.util.helper.DyeColor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL12;
import org.slf4j.Logger;

public class TextureManager {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final int ANIMATIONS_DISABLED = 0;
    public static final int ANIMATIONS_NATIVE = 1;
    public static final int ANIMATIONS_CUSTOM = 2;
    public final Minecraft mc;
    public final Map<Integer, Texture> idToTextureMap = new HashMap<Integer, Texture>();
    public final Map<String, Texture> textureMap = new HashMap<String, Texture>();
    public final List<TextureBuffered> bufferedTextures = new ArrayList<TextureBuffered>();
    public final Map<String, TextureDownloaded> downloadedTextures = new HashMap<String, TextureDownloaded>();
    public final Map<NamespaceID, DynamicTexture> dynamicTextures = new HashMap<NamespaceID, DynamicTexture>();
    private final GameSettings gameSettings;
    public TexturePackList texturePacks;
    private boolean clampTexture;
    private boolean blurTexture;

    public TextureManager(Minecraft minecraft, TexturePackList texturePacks, GameSettings gameSettings) {
        this.mc = minecraft;
        this.clampTexture = false;
        this.blurTexture = false;
        this.texturePacks = texturePacks;
        this.gameSettings = gameSettings;
    }

    public void initDynamicTextures(Collection<? super Throwable> errors) {
        LOGGER.info("Initializing Dynamic Textures...");
        this.dynamicTextures.clear();
        this.addNativeDynamicTextures((Integer)this.mc.gameSettings.animations.value);
        if (((Boolean)this.mc.gameSettings.customAnimations.value).booleanValue() && (Integer)this.mc.gameSettings.animations.value == 2) {
            try {
                this.loadCustomAnimations();
            }
            catch (TexturePackException e) {
                errors.add(e);
            }
        }
        this.addDynamicTextureOverride(new DynamicTextureClock(this.mc), true);
        this.addDynamicTextureOverride(new DynamicTextureCalendar(this.mc), true);
        this.addDynamicTextureOverride(new DynamicTextureCompass(this.mc, TextureRegistry.getTexture("minecraft:item/tool_compass")), true);
    }

    protected void addNativeDynamicTextures(int state) {
        if (state > 0) {
            String[] fireflyColors;
            this.addDynamicTexture(new DynamicTextureWaterStill(TextureRegistry.getTexture("minecraft:block/water_still")));
            this.addDynamicTexture(new DynamicTextureWaterFlow(TextureRegistry.getTexture("minecraft:block/water_flowing")));
            this.addDynamicTexture(new DynamicTextureLavaStill(TextureRegistry.getTexture("minecraft:block/lava_still")));
            this.addDynamicTexture(new DynamicTextureLavaFlowing(TextureRegistry.getTexture("minecraft:block/lava_flowing")));
            this.addDynamicTexture(new DynamicTextureFire(TextureRegistry.getTexture("minecraft:block/fire")));
            String[] stringArray = fireflyColors = new String[]{"blue", "orange", "green", "red"};
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String color = stringArray[i];
                this.addDynamicTexture(new DynamicTextureFireflyJar(TextureRegistry.getTexture("minecraft:block/lantern_firefly/" + color)));
            }
            this.addDynamicTexture(new DynamicTextureTrommel(this.mc, TextureRegistry.getTexture("minecraft:block/trommel/active_front"), true));
            this.addDynamicTexture(new DynamicTextureTrommel(this.mc, TextureRegistry.getTexture("minecraft:block/trommel/active_back"), false));
        }
        if (state < 2) {
            for (DyeColor c : DyeColor.values()) {
                IconCoordinate cNether = TextureRegistry.getTexture("minecraft:block/portal_nether/" + c.colorID);
                assert (cNether.hasMeta("animation")) : "Coordinate " + cNether.namespaceId + " is expected to have animation data attached!";
                this.addDynamicTexture(new DynamicTextureCustom(cNether, cNether.getMeta("animation", AnimationProperties.class)));
                IconCoordinate cParadise = TextureRegistry.getTexture("minecraft:block/portal_paradise/" + c.colorID);
                assert (cParadise.hasMeta("animation")) : "Coordinate " + cParadise.namespaceId + " is expected to have animation data attached!";
                this.addDynamicTexture(new DynamicTextureCustom(cParadise, cParadise.getMeta("animation", AnimationProperties.class)));
            }
        }
    }

    protected void addDynamicTexture(DynamicTexture texture) {
        this.addDynamicTextureOverride(texture, false);
    }

    protected void addDynamicTextureOverride(DynamicTexture texture, boolean override) {
        if (!override && this.dynamicTextures.containsKey(texture.targetTexture.namespaceId)) {
            return;
        }
        this.dynamicTextures.put(texture.targetTexture.namespaceId, texture);
    }

    private void loadCustomAnimations() {
        if (!((Boolean)this.mc.gameSettings.customAnimations.value).booleanValue()) {
            return;
        }
        for (AtlasStitcher stitcher : TextureRegistry.stitcherMap.values()) {
            for (IconCoordinate c : stitcher.textureMap.values()) {
                if (!c.hasMeta("animation")) continue;
                LOGGER.debug("Icon '{}' has 'animation' meta!", (Object)c.namespaceId);
                this.addDynamicTextureOverride(new DynamicTextureCustom(c, c.getMeta("animation", AnimationProperties.class)), true);
            }
        }
    }

    @NotNull
    public Texture loadTexture(@NotNull String name) {
        Texture t = this.loadTextureNoDefault(name);
        if (t == null) {
            t = new TextureBuffered(Textures.missingTexture, false, false, false);
            this.textureMap.put(name, t);
            this.idToTextureMap.put(t.id(), t);
        }
        return t;
    }

    @Nullable
    public Texture loadTextureNoDefault(@NotNull String name) {
        Objects.requireNonNull(name);
        Texture texture = this.textureMap.get(name);
        if (texture != null) {
            return texture;
        }
        try {
            texture = new TextureFile(name);
            this.textureMap.put(name, texture);
            this.idToTextureMap.put(texture.id(), texture);
            return texture;
        }
        catch (Exception e) {
            LOGGER.error("Failed to create texture for '{}'!", (Object)name, (Object)e);
            return null;
        }
    }

    public TextureBuffered loadBufferedTexture(BufferedImage bufferedimage) {
        TextureBuffered texture = new TextureBuffered(bufferedimage, false, false, false);
        this.bufferedTextures.add(texture);
        return texture;
    }

    public int createTexture(int width, int height) {
        int tex = GLAllocation.generateTexture();
        GL12.glBindTexture((int)3553, (int)tex);
        ByteBuffer buffer = ByteBuffer.allocateDirect(width * height * 4);
        GL12.glTexImage2D((int)3553, (int)0, (int)6408, (int)width, (int)height, (int)0, (int)6408, (int)5121, (ByteBuffer)buffer);
        return tex;
    }

    public void updateDynamicTexture(DynamicTexture anim) {
        anim.update();
        Buffer.checkBufferSize(anim.imageData.length);
        Buffer.reset();
        Buffer.buffer.put(anim.imageData);
        Buffer.buffer.position(0).limit(anim.imageData.length);
        anim.targetTexture.parentAtlas.bind();
        IconCoordinate icon = anim.targetTexture;
        int x1 = icon.iconX;
        int y1 = icon.iconY;
        GL12.glTexSubImage2D((int)3553, (int)0, (int)x1, (int)y1, (int)icon.width, (int)icon.height, (int)6408, (int)5121, (ByteBuffer)Buffer.buffer);
        if ((Integer)this.mc.gameSettings.mipmapLevels.value > 0 && anim.targetTexture.parentAtlas.hasMipmaps()) {
            int levels = GL12.glGetTexParameteri((int)3553, (int)33085);
            for (int level = 1; level <= levels; ++level) {
                int lod = (int)Math.pow(2.0, level);
                Buffer.reset();
                for (int x = 0; x < icon.width / lod; ++x) {
                    for (int y = 0; y < icon.height / lod; ++y) {
                        int i = y * lod * icon.width + x * lod;
                        int j = y * (icon.width / lod) + x;
                        Buffer.buffer.put(j * 4 + 0, anim.imageData[i * 4 + 0]);
                        Buffer.buffer.put(j * 4 + 1, anim.imageData[i * 4 + 1]);
                        Buffer.buffer.put(j * 4 + 2, anim.imageData[i * 4 + 2]);
                        Buffer.buffer.put(j * 4 + 3, anim.imageData[i * 4 + 3]);
                    }
                }
                Buffer.buffer.position(0).limit(icon.width / lod * icon.height / lod * 4);
                x1 = icon.iconX;
                y1 = icon.iconY;
                GL12.glTexSubImage2D((int)3553, (int)level, (int)(x1 / lod), (int)(y1 / lod), (int)(icon.width / lod), (int)(icon.height / lod), (int)6408, (int)5121, (ByteBuffer)Buffer.buffer);
            }
        }
    }

    public void updateTextureData(int[] imageData, int w, int h, int textureId) {
        GL12.glBindTexture((int)3553, (int)textureId);
        GL12.glTexParameteri((int)3553, (int)10241, (int)9728);
        GL12.glTexParameteri((int)3553, (int)10240, (int)9728);
        if (this.blurTexture) {
            GL12.glTexParameteri((int)3553, (int)10241, (int)9729);
            GL12.glTexParameteri((int)3553, (int)10240, (int)9729);
        }
        if (this.clampTexture) {
            GL12.glTexParameteri((int)3553, (int)10242, (int)10496);
            GL12.glTexParameteri((int)3553, (int)10243, (int)10496);
        } else {
            GL12.glTexParameteri((int)3553, (int)10242, (int)10497);
            GL12.glTexParameteri((int)3553, (int)10243, (int)10497);
        }
        byte[] bytes = new byte[w * h * 4];
        for (int l = 0; l < imageData.length; ++l) {
            int a = imageData[l] >> 24 & 0xFF;
            int r = imageData[l] >> 16 & 0xFF;
            int g = imageData[l] >> 8 & 0xFF;
            int b = imageData[l] & 0xFF;
            bytes[l * 4] = (byte)r;
            bytes[l * 4 + 1] = (byte)g;
            bytes[l * 4 + 2] = (byte)b;
            bytes[l * 4 + 3] = (byte)a;
        }
        Buffer.buffer.clear();
        Buffer.buffer.put(bytes);
        Buffer.buffer.position(0).limit(bytes.length);
        GL12.glTexSubImage2D((int)3553, (int)0, (int)0, (int)0, (int)w, (int)h, (int)6408, (int)5121, (ByteBuffer)Buffer.buffer);
    }

    public void updateDynamicTextures(boolean isPaused) {
        ArrayList<DynamicTexture> dynamics = new ArrayList<DynamicTexture>(this.dynamicTextures.values());
        for (DynamicTexture dynamicTexture : dynamics) {
            try {
                if (!dynamicTexture.runUpdates(isPaused)) continue;
                this.updateDynamicTexture(dynamicTexture);
            }
            catch (Exception e) {
                LOGGER.error("Exception while updating dynamic for '{}'. Removing from dynamic texture pool and skipping!", (Object)dynamicTexture.targetTexture.namespaceId, (Object)e);
                this.dynamicTextures.remove(dynamicTexture.targetTexture.namespaceId);
            }
        }
    }

    public BufferedImage getImage(String name) {
        try {
            return Textures.readImage(this.texturePacks.getResourceAsStream(name));
        }
        catch (Exception e) {
            return Textures.missingTexture;
        }
    }

    public void refreshTexturesAndDisplayErrors() {
        MaterialColor.assignManualEntries();
        ArrayList<Throwable> errors = new ArrayList<Throwable>();
        this.refreshTextures(errors);
        if (!errors.isEmpty()) {
            String string = this.createErrorString(errors);
            if (this.mc.currentScreen != null) {
                PopupBuilder builder = new PopupBuilder(this.mc.currentScreen, this.mc.resolution.getScaledWidthScreenCoords() - 40);
                builder.closeOnClickOut(0);
                builder.closeOnEnter(0);
                builder.closeOnEsc(0);
                builder.withMessageBox("what", this.mc.resolution.getScaledHeightScreenCoords() - 120, string, Integer.MAX_VALUE);
                builder.withButtonGroup("ok", new String[]{"gui.options.button.done"}, new int[]{0});
                PopupScreen popup = builder.build();
                this.mc.displayScreen(popup);
            } else {
                String[] lines;
                for (String line : lines = string.split("\n")) {
                    this.mc.hudIngame.addChatMessage(line);
                }
            }
        }
    }

    private String createErrorString(List<Throwable> errors) {
        if (errors.isEmpty()) {
            return "";
        }
        StringBuilder str = new StringBuilder();
        int readableErrorCount = 0;
        for (Throwable e : errors) {
            if (e instanceof TexturePackException) {
                this.addErrorText(str, e, 0);
                ++readableErrorCount;
            }
            LOGGER.error("Unexpected Exception", e);
        }
        if (readableErrorCount == 0) {
            str.append("An unexpected error has occurred! Check the log for more information!");
        }
        return str.toString();
    }

    private void addErrorText(StringBuilder str, Throwable e, int indent) {
        for (int i = 0; i < 4 * indent; ++i) {
            str.append(' ');
        }
        str.append(e.getMessage()).append("\n");
        Throwable cause = e.getCause();
        if (cause instanceof TexturePackException) {
            this.addErrorText(str, cause, indent + 1);
        }
    }

    public void refreshTextures(List<Throwable> errors) {
        CustomAtlasHandler.beforeRefreshTextures();
        long start = System.nanoTime();
        for (AtlasStitcher atlasStitcher : TextureRegistry.stitcherMap.values()) {
            atlasStitcher.preinit();
        }
        LOGGER.debug("Took '{}' seconds to load atlases.", (Object)((double)(System.nanoTime() - start) / 1.0E9));
        this.initDynamicTextures(errors);
        for (AtlasStitcher atlasStitcher : TextureRegistry.stitcherMap.values()) {
            atlasStitcher.init();
        }
        for (DynamicTexture dynamicTexture : this.dynamicTextures.values()) {
            dynamicTexture.postInit();
        }
        for (TextureBuffered textureBuffered : this.bufferedTextures) {
            textureBuffered.init();
        }
        for (Texture texture : this.textureMap.values()) {
            texture.init();
        }
        Colors.loadColors();
        this.mc.font = new Font(this.mc, this.gameSettings, this);
        this.mc.skinVariantList.refresh(errors);
        this.mc.mainMenuBackground.refresh(errors);
        Colorizers.reload();
        Colorizers.update(true);
        this.mc.worldRenderer.lightmapHelper.setup();
    }

    public void bindTexture(Texture texture) {
        if (texture == null) {
            return;
        }
        texture.bind();
    }

    public void bindTexture(int textureID) {
        if (textureID < 0) {
            return;
        }
        GL11.glBindTexture((int)3553, (int)textureID);
    }

    public boolean bindDownloadableTexture(String urlTexture, String backupTexture, ImageParser imageParser) {
        if (urlTexture == null) {
            if (backupTexture != null) {
                this.bindTexture(this.loadTexture(backupTexture));
                return true;
            }
            return false;
        }
        TextureDownloaded texture = this.downloadedTextures.get(urlTexture);
        if (texture == null) {
            texture = new TextureDownloaded(urlTexture, imageParser);
            this.downloadedTextures.put(urlTexture, texture);
        }
        if (!texture.isGenerated() && texture.image != null) {
            texture.generate();
            texture.setupTexture(texture.image, false, false, false);
        }
        if (texture.bind()) {
            return true;
        }
        if (backupTexture != null) {
            this.bindTexture(this.loadTexture(backupTexture));
            return true;
        }
        return false;
    }
}

