/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.entity;

import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.PlayerLocal;
import net.minecraft.client.render.Font;
import net.minecraft.client.render.Lighting;
import net.minecraft.client.render.LightmapHelper;
import net.minecraft.client.render.PlayerSkinParser;
import net.minecraft.client.render.RenderBlocks;
import net.minecraft.client.render.TileEntityRenderDispatcher;
import net.minecraft.client.render.block.model.BlockModel;
import net.minecraft.client.render.block.model.BlockModelDispatcher;
import net.minecraft.client.render.camera.EntityCamera;
import net.minecraft.client.render.entity.MobRenderer;
import net.minecraft.client.render.item.model.ItemModelDispatcher;
import net.minecraft.client.render.model.ModelBiped;
import net.minecraft.client.render.model.ModelPlayer;
import net.minecraft.client.render.model.ModelPlayerSlim;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.client.render.tileentity.TileEntityRenderer;
import net.minecraft.core.Global;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.motion.CarriedBlock;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.item.IArmorItem;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemQuiver;
import net.minecraft.core.item.ItemQuiverEndless;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.Items;
import net.minecraft.core.player.gamemode.Gamemode;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.BlocksContainer;
import org.lwjgl.opengl.GL11;

public class MobRendererPlayer
extends MobRenderer<Player> {
    private ModelBiped modelBipedMain = (ModelBiped)this.mainModel;
    private final ModelPlayer modelThick;
    private final ModelPlayer modelSlim;
    private final ModelBiped modelArmorChestplate = new ModelBiped(1.0f);
    private final ModelBiped modelArmor = new ModelBiped(0.5f);
    private BlocksContainer container = null;
    private RenderBlocks containerRenderBlock = null;

    public MobRendererPlayer() {
        super(new ModelPlayer(0.0f), 0.5f);
        this.modelThick = new ModelPlayer(0.0f);
        this.modelSlim = new ModelPlayerSlim(0.0f);
    }

    protected void renderSpecials(Player player, float partialTick) {
        ItemStack itemstack1;
        boolean renderCape;
        if (Minecraft.getMinecraft().thePlayer.getGamemode() == Gamemode.spectator && player.getGamemode() == Gamemode.spectator) {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.25f);
        } else if (player.getGamemode() == Gamemode.spectator) {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.0f);
        }
        ItemStack itemstack = player.inventory.armorItemInSlot(3);
        if (itemstack != null) {
            float scale;
            GL11.glPushMatrix();
            this.modelBipedMain.head.translateTo(0.0625f);
            if (itemstack.itemID < Blocks.blocksList.length && ((BlockModel)BlockModelDispatcher.getInstance().getDispatch(Blocks.getBlock(itemstack.itemID))).shouldItemRender3d()) {
                scale = 0.625f;
                GL11.glTranslatef((float)0.0f, (float)-0.25f, (float)0.0f);
                GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glScalef((float)scale, (float)(-scale), (float)scale);
                ItemModelDispatcher.getInstance().getDispatch(itemstack).renderItem(Tessellator.instance, this.renderDispatcher.itemRenderer, player, itemstack);
            } else if (!(itemstack.getItem() instanceof IArmorItem) || ((IArmorItem)((Object)itemstack.getItem())).getArmorPiece() != 3) {
                GL11.glEnable((int)2884);
                scale = 0.625f;
                GL11.glTranslatef((float)0.0f, (float)-0.8f, (float)0.0f);
                GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                GL11.glScalef((float)scale, (float)scale, (float)scale);
                ItemModelDispatcher.getInstance().getDispatch(itemstack).renderItemInWorld(Tessellator.instance, player, itemstack, player.getBrightness(partialTick), 1.0f, true);
                GL11.glDisable((int)2884);
            }
            GL11.glPopMatrix();
        }
        if (!(renderCape = this.bindDownloadableTexture("https://api.betterthanadventure.net/capes?username=" + player.username, null, null))) {
            renderCape = this.bindDownloadableTexture(player.capeURL, null, null);
        }
        if (renderCape) {
            GL11.glPushMatrix();
            float brightness = Global.accessor.isFullbrightEnabled() || LightmapHelper.isLightmapEnabled() ? 1.0f : player.getBrightness(partialTick);
            GL11.glColor4f((float)brightness, (float)brightness, (float)brightness, (float)1.0f);
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)0.125f);
            float yawOff = player.yBodyRotO + (player.yBodyRot - player.yBodyRotO) * partialTick;
            float bodyAngle = 5.0f;
            if (player.isSneaking()) {
                bodyAngle += 25.0f;
            }
            double _xd = player.xdO + (player.xd - player.xdO) * (double)partialTick;
            double _yd = Math.min(player.ydO + (player.yd - player.ydO) * (double)partialTick, 0.0);
            double _zd = player.zd0 + (player.zd - player.zd0) * (double)partialTick;
            double vel = -1.0 / (3.0 * Math.hypot(_xd, _zd) + 1.0) + 1.0;
            double moveAng = Math.atan2(_xd, _zd);
            double yawRad = Math.toRadians(yawOff);
            double multiplier = 1.0 - Math.abs((Math.cos(yawRad) + 1.0 - (Math.cos(moveAng) + 1.0) + 2.0) / 2.0 - 1.0);
            player.wobbleTimer += (float)((double)((float)player.tickCount + partialTick - (float)player.lastRenderTick) / (30.0 - 29.0 * MathHelper.clamp(vel, 0.0, 1.0)));
            player.lastRenderTick = player.tickCount;
            double wobble = Math.sin(player.wobbleTimer) * (1.5 + 4.5 * vel * multiplier);
            GL11.glRotatef((float)((float)MathHelper.clamp(MathHelper.clamp((double)bodyAngle + vel * 100.0 * multiplier, (double)bodyAngle, 100.0) + wobble - _yd * 60.0, 0.0, 180.0)), (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glRotatef((float)0.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            this.modelBipedMain.renderCloak(0.0625f);
            GL11.glPopMatrix();
        }
        if ((itemstack1 = player.inventory.getCurrentItem()) != null) {
            GL11.glPushMatrix();
            this.modelBipedMain.armRight.translateTo(0.0625f);
            BlockModel.setRenderBlocks(this.renderDispatcher.itemRenderer.renderBlocksInstance);
            ItemModelDispatcher.getInstance().getDispatch(itemstack1).renderItemThirdPerson(Tessellator.instance, this.renderDispatcher.itemRenderer, player, itemstack1, true);
            GL11.glPopMatrix();
        }
        if (player.getHeldObject() != null) {
            float walkSpeed = player.walkAnimSpeedO + (player.walkAnimSpeed - player.walkAnimSpeedO) * partialTick;
            float walkProgress = player.walkAnimPos - player.walkAnimSpeed * (1.0f - partialTick);
            GL11.glTranslatef((float)0.0f, (float)(MathHelper.cos(walkProgress / 2.0f * 2.0f / 3.0f) / 26.0f * walkSpeed + 0.1f), (float)0.0f);
            this.drawHeldObject(player, partialTick);
        }
    }

    public void drawFirstPersonHand(Player player, boolean isLeft) {
        this.mainModel = player.slimModel ? this.modelSlim : this.modelThick;
        this.modelBipedMain = player.slimModel ? this.modelSlim : this.modelThick;
        this.modelBipedMain.onGround = 0.0f;
        this.modelBipedMain.isRiding = false;
        this.modelBipedMain.setupAnimation(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f);
        if (isLeft) {
            this.modelBipedMain.armLeft.render(0.0625f);
        } else {
            this.modelBipedMain.armRight.render(0.0625f);
        }
        if (this.modelBipedMain instanceof ModelPlayer) {
            if (isLeft) {
                ((ModelPlayer)this.modelBipedMain).bipedLeftArmOverlay.render(0.0625f);
            } else {
                ((ModelPlayer)this.modelBipedMain).bipedRightArmOverlay.render(0.0625f);
            }
        }
    }

    public void drawHeldObject(Player player, float partialTick) {
        if (player.getHeldObject() instanceof CarriedBlock) {
            CarriedBlock carriedBlock = (CarriedBlock)player.getHeldObject();
            if (this.container == null || this.container.world != player.world) {
                this.container = new BlocksContainer(player.world);
                this.containerRenderBlock = new RenderBlocks(this.container);
            }
            Tessellator tessellator = Tessellator.instance;
            Minecraft mc = Minecraft.getMinecraft();
            TextureRegistry.blockAtlas.bind();
            GL11.glPushMatrix();
            Lighting.disable();
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glEnable((int)3042);
            GL11.glDisable((int)2884);
            if (mc.isAmbientOcclusionEnabled()) {
                GL11.glShadeModel((int)7425);
            } else {
                GL11.glShadeModel((int)7424);
            }
            GL11.glScalef((float)0.55f, (float)-0.55f, (float)0.55f);
            GL11.glTranslatef((float)0.0f, (float)-0.75f, (float)-0.75f);
            int blockX = MathHelper.floor(player.x);
            int blockY = MathHelper.floor(player.y) + 1;
            int blockZ = MathHelper.floor(player.z);
            BlockModel.setRenderBlocks(this.containerRenderBlock);
            tessellator.startDrawingQuads();
            tessellator.setTranslation((double)(-blockX) - 0.5, (double)(-blockY) - 0.5, (double)(-blockZ) - 0.5);
            this.container.setLightReferenceEntity(player);
            this.container.setBlock(blockX, blockY, blockZ, carriedBlock.blockId, carriedBlock.metadata, carriedBlock.entity);
            ((BlockModel)BlockModelDispatcher.getInstance().getDispatch(carriedBlock.block())).renderNoCulling(Tessellator.instance, blockX, blockY, blockZ);
            tessellator.draw();
            tessellator.setTranslation(0.0, 0.0, 0.0);
            this.container.setLightReferenceEntity(null);
            this.container.clear();
            TileEntityRenderer<TileEntity> renderer = TileEntityRenderDispatcher.instance.getRenderer(carriedBlock.entity);
            if (renderer != null) {
                carriedBlock.entity.worldObj = player.world;
                renderer.doRender(tessellator, carriedBlock.entity, -0.5, -0.5, -0.5, partialTick);
                carriedBlock.entity.worldObj = null;
            }
            Lighting.enableLight();
            GL11.glPopMatrix();
        }
    }

    @Override
    protected void renderSpecials(Tessellator tessellator, Player entity, double d, double d1, double d2) {
        if (Minecraft.getMinecraft().thePlayer.getGamemode() != Gamemode.spectator && entity.getGamemode() == Gamemode.spectator) {
            return;
        }
        if (Minecraft.getMinecraft().gameSettings.immersiveMode.drawNames() && this.renderDispatcher.camera != null) {
            float f3;
            if (this.renderDispatcher.camera instanceof EntityCamera && ((EntityCamera)this.renderDispatcher.camera).mob == entity) {
                return;
            }
            float f = 1.6f;
            float f1 = 0.01666667f * f;
            float f2 = (float)this.renderDispatcher.camera.distanceTo(entity);
            float f4 = f3 = entity.isSneaking() ? 32.0f : 64.0f;
            if (f2 < f3) {
                String s = entity.getDisplayName();
                if (!entity.isSneaking()) {
                    if (entity.isPlayerSleeping()) {
                        this.renderLivingLabel(tessellator, entity, s, d, d1 - 1.5, d2, 64, false);
                    } else {
                        this.renderLivingLabel(tessellator, entity, s, d, d1, d2, 64, false);
                    }
                } else {
                    Font font = this.getFont();
                    GL11.glPushMatrix();
                    GL11.glTranslatef((float)((float)d + 0.0f), (float)((float)d1 + 2.3f), (float)((float)d2));
                    GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
                    GL11.glRotatef((float)(-this.renderDispatcher.viewLerpYaw), (float)0.0f, (float)1.0f, (float)0.0f);
                    GL11.glRotatef((float)this.renderDispatcher.viewLerpPitch, (float)1.0f, (float)0.0f, (float)0.0f);
                    GL11.glScalef((float)(-f1), (float)(-f1), (float)f1);
                    GL11.glDisable((int)2896);
                    GL11.glTranslatef((float)0.0f, (float)(0.25f / f1), (float)0.0f);
                    GL11.glDepthMask((boolean)false);
                    GL11.glEnable((int)3042);
                    GL11.glBlendFunc((int)770, (int)771);
                    GL11.glDisable((int)3553);
                    tessellator.startDrawingQuads();
                    int i = font.getStringWidth(s) / 2;
                    tessellator.setColorRGBA_F(0.0f, 0.0f, 0.0f, 0.25f);
                    tessellator.addVertex(-i - 1, -1.0, 0.0);
                    tessellator.addVertex(-i - 1, 8.0, 0.0);
                    tessellator.addVertex(i + 1, 8.0, 0.0);
                    tessellator.addVertex(i + 1, -1.0, 0.0);
                    tessellator.draw();
                    GL11.glEnable((int)3553);
                    GL11.glDepthMask((boolean)true);
                    font.drawString(s, -font.getStringWidth(s) / 2, 0, 0x20FFFFFF);
                    GL11.glEnable((int)2896);
                    GL11.glDisable((int)3042);
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    GL11.glPopMatrix();
                }
            }
        }
    }

    @Override
    protected void setupScale(Player entity, float partialTick) {
        if (Minecraft.getMinecraft().thePlayer.getGamemode() == Gamemode.spectator && entity.getGamemode() == Gamemode.spectator) {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.25f);
        } else if (entity.getGamemode() == Gamemode.spectator) {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.0f);
        }
        float scale = 0.9375f;
        GL11.glScalef((float)scale, (float)scale, (float)scale);
        if (entity.isDwarf()) {
            GL11.glScalef((float)0.6f, (float)0.5f, (float)0.6f);
        }
    }

    @Override
    protected boolean prepareArmor(Player entity, int layer, float partialTick) {
        IArmorItem armorItem;
        Item item;
        ItemStack itemstack = entity.inventory.armorItemInSlot(3 - layer);
        if (itemstack != null && (item = itemstack.getItem()) instanceof IArmorItem && (armorItem = (IArmorItem)((Object)item)).getArmorPiece() == 3 - layer) {
            if (item instanceof ItemQuiver) {
                this.bindTexture("/assets/minecraft/textures/armor/quiver.png");
                ModelBiped modelBiped = this.modelArmorChestplate;
                modelBiped.body.visible = layer == 1 || layer == 2;
                this.setArmorModel(modelBiped);
                return true;
            }
            if (item instanceof ItemQuiverEndless) {
                this.bindTexture("/assets/minecraft/textures/armor/quiver_golden.png");
                ModelBiped modelBiped = this.modelArmorChestplate;
                modelBiped.body.visible = layer == 1 || layer == 2;
                this.setArmorModel(modelBiped);
                return true;
            }
            if (item == Items.ARMOR_BOOTS_ICESKATES) {
                this.bindTexture("/assets/minecraft/textures/armor/skates.png");
                ModelBiped modelBiped = this.modelArmorChestplate;
                modelBiped.legRight.visible = layer == 2 || layer == 3;
                modelBiped.legLeft.visible = layer == 2 || layer == 3;
                this.setArmorModel(modelBiped);
                return true;
            }
            if (armorItem.getArmorMaterial() != null) {
                this.bindTexture(String.format("/assets/%s/textures/armor/%s_%d.png", armorItem.getArmorMaterial().identifier.namespace, armorItem.getArmorMaterial().identifier.value, layer != 2 ? 1 : 2));
                ModelBiped modelBiped = layer != 2 ? this.modelArmorChestplate : this.modelArmor;
                modelBiped.head.visible = layer == 0;
                modelBiped.hair.visible = layer == 0;
                modelBiped.body.visible = layer == 1 || layer == 2;
                modelBiped.armRight.visible = layer == 1;
                modelBiped.armLeft.visible = layer == 1;
                modelBiped.legRight.visible = layer == 2 || layer == 3;
                modelBiped.legLeft.visible = layer == 2 || layer == 3;
                this.setArmorModel(modelBiped);
                return true;
            }
        }
        return false;
    }

    @Override
    protected void renderAdditional(Player entity, float partialTick) {
        this.renderSpecials(entity, partialTick);
    }

    @Override
    protected void setupRotations(Player entity, float ticksExisted, float bodyYaw, float partialTick) {
        if (entity.isAlive() && entity.isPlayerSleeping()) {
            GL11.glRotatef((float)entity.getBedOrientationInDegrees(), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)this.getMaxDeathRotation(entity), (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glRotatef((float)270.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        } else {
            super.setupRotations(entity, ticksExisted, bodyYaw, partialTick);
        }
    }

    @Override
    protected void translateModel(Player entity, double x, double y, double z) {
        if (entity.isAlive() && entity.isPlayerSleeping()) {
            super.translateModel(entity, x + (double)entity.sleepOffX, y + (double)entity.sleepOffY, z + (double)entity.sleepOffZ);
        } else {
            super.translateModel(entity, x, y, z);
        }
    }

    @Override
    public void render(Tessellator tessellator, Player entity, double x, double y, double z, float yaw, float partialTick) {
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        this.mainModel = entity.slimModel ? this.modelSlim : this.modelThick;
        this.modelBipedMain = entity.slimModel ? this.modelSlim : this.modelThick;
        ItemStack itemstack = entity.inventory.getCurrentItem();
        this.modelBipedMain.holdingLarge = entity.getHeldObject() != null;
        this.modelArmor.holdingLarge = this.modelBipedMain.holdingLarge;
        this.modelArmorChestplate.holdingLarge = this.modelBipedMain.holdingLarge;
        this.modelBipedMain.holdingRightHand = itemstack != null;
        this.modelArmor.holdingRightHand = this.modelBipedMain.holdingRightHand;
        this.modelArmorChestplate.holdingRightHand = this.modelBipedMain.holdingRightHand;
        this.modelArmor.holdingRightHand = this.modelBipedMain.holdingRightHand = this.modelBipedMain.holdingRightHand | entity.getHeldObject() != null;
        this.modelArmorChestplate.holdingRightHand = this.modelBipedMain.holdingRightHand;
        this.modelArmor.holdingLeftHand = this.modelBipedMain.holdingLeftHand = this.modelBipedMain.holdingLeftHand | entity.getHeldObject() != null;
        this.modelArmorChestplate.holdingLeftHand = this.modelBipedMain.holdingLeftHand;
        this.modelArmor.sneaking = this.modelBipedMain.sneaking = entity.isSneaking();
        this.modelArmorChestplate.sneaking = this.modelBipedMain.sneaking;
        this.modelArmor.isRiding = this.modelBipedMain.isRiding = entity.isPassenger();
        this.modelArmorChestplate.isRiding = this.modelBipedMain.isRiding;
        double d3 = y - (double)entity.heightOffset;
        if (entity.isSneaking() && !(entity instanceof PlayerLocal)) {
            d3 -= 0.125;
        }
        super.render(tessellator, entity, x, d3, z, yaw, partialTick);
        this.modelBipedMain.holdingLarge = false;
        this.modelArmor.holdingLarge = false;
        this.modelArmorChestplate.holdingLarge = false;
        this.modelBipedMain.sneaking = false;
        this.modelArmor.sneaking = false;
        this.modelArmorChestplate.sneaking = false;
        this.modelBipedMain.holdingRightHand = false;
        this.modelArmor.holdingRightHand = false;
        this.modelArmorChestplate.holdingRightHand = false;
        this.modelBipedMain.holdingLeftHand = false;
        this.modelArmor.holdingLeftHand = false;
        this.modelArmorChestplate.holdingLeftHand = false;
        GL11.glDisable((int)3042);
    }

    @Override
    public void loadEntityTexture(Player entity) {
        this.bindDownloadableTexture(entity.skinURL, entity.getEntityTexture(), PlayerSkinParser.instance);
    }

    @Override
    protected float limbSway(Player entity, float partialTick) {
        return super.limbSway(entity, partialTick);
    }
}

