/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.model;

import net.minecraft.client.render.model.Cube;
import net.minecraft.client.render.model.ModelBase;
import net.minecraft.core.util.helper.MathHelper;
import org.lwjgl.opengl.GL11;

public class ModelScorpion
extends ModelBase {
    private final Cube body = new Cube(0, 0);
    private final Cube clawLeft;
    private final Cube clawRight;
    private final Cube legLFront;
    private final Cube legLMid;
    private final Cube legLBack;
    private final Cube legRFront;
    private final Cube legRMid;
    private final Cube legRBack;
    private final Cube tail0;
    private final Cube tail1;
    private final Cube tail2;

    public ModelScorpion() {
        this.body.addBox(-2.5f, -4.0f, -5.0f, 5, 3, 10);
        this.body.setRotationPoint(0.0f, 0.0f, 0.0f);
        this.clawLeft = new Cube(20, 0);
        this.clawLeft.addBox(1.5f, -3.0f, -10.0f, 3, 2, 6);
        this.clawLeft.setRotationPoint(0.0f, 0.0f, 0.0f);
        this.clawLeft.setRotationAngle(0.0f, -0.0873f, 0.0f);
        this.clawRight = new Cube(14, 13);
        this.clawRight.addBox(-4.5f, -3.0f, -10.0f, 3, 2, 6);
        this.clawRight.setRotationPoint(0.0f, 0.0f, 0.0f);
        this.clawRight.setRotationAngle(0.0f, 0.0873f, 0.0f);
        this.legLFront = new Cube(21, 22);
        this.legLFront.addBox(-9.0f, -4.0f, -0.5f, 9, 1, 1);
        this.legLFront.setRotationPoint(0.0f, 0.0f, 0.0f);
        this.legLFront.setRotationAngle(0.0f, -2.618f, 0.3927f);
        this.legLMid = new Cube(0, 23);
        this.legLMid.addBox(-9.0f, -4.0f, -0.5f, 9, 1, 1);
        this.legLMid.setRotationPoint(0.0f, 0.0f, 0.0f);
        this.legLMid.setRotationAngle(0.0f, 3.1416f, 0.3927f);
        this.legLBack = new Cube(0, 25);
        this.legLBack.addBox(-9.0f, -4.0f, -0.5f, 9, 1, 1);
        this.legLBack.setRotationPoint(0.0f, 0.0f, 0.0f);
        this.legLBack.setRotationAngle(0.0f, 2.618f, 0.3927f);
        this.legRFront = new Cube(21, 22);
        this.legRFront.addBox(-9.0f, -4.0f, -0.5f, 9, 1, 1);
        this.legRFront.setRotationPoint(0.0f, 0.0f, 0.0f);
        this.legRFront.setRotationAngle(0.0f, -0.5236f, -0.3927f);
        this.legRMid = new Cube(0, 25);
        this.legRMid.addBox(-9.0f, -4.0f, -0.5f, 9, 1, 1);
        this.legRMid.setRotationPoint(0.0f, 0.0f, 0.0f);
        this.legRMid.setRotationAngle(0.0f, 0.0f, -0.3927f);
        this.legRBack = new Cube(19, 24);
        this.legRBack.addBox(-9.0f, -4.0f, -0.5f, 9, 1, 1);
        this.legRBack.setRotationPoint(0.0f, 0.0f, 0.0f);
        this.legRBack.setRotationAngle(0.0f, 0.5236f, -0.3927f);
        this.tail0 = new Cube(0, 13);
        this.tail0.addBox(-1.5f, -1.0f, -4.0f, 3, 2, 8);
        this.tail0.setRotationPoint(0.0f, -5.0f, 6.0f);
        this.tail0.setRotationAngle(1.0472f, 0.0f, 0.0f);
        this.tail1 = new Cube(0, 0);
        this.tail1.addBox(-1.0f, 2.0f, 2.5f, 2, 6, 2);
        this.tail1.setRotationPoint(0.0f, -11.0f, 0.0f);
        this.tail1.setRotationAngle(0.7854f, 0.0f, 0.0f);
        this.tail2 = new Cube(0, 13);
        this.tail2.addBox(-1.0f, 0.0f, -1.5f, 2, 4, 1);
        this.tail2.setRotationPoint(0.0f, -11.0f, 0.0f);
        this.tail2.setRotationAngle(2.138f, 0.0f, 0.0f);
    }

    @Override
    public void render(float limbSwing, float limbYaw, float limbPitch, float headYaw, float headPitch, float scale) {
        this.setupAnimation(limbSwing, limbYaw, limbPitch, headYaw, headPitch, scale);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.0f, (float)1.4f, (float)0.0f);
        this.body.render(scale);
        this.clawLeft.render(scale);
        this.clawRight.render(scale);
        this.legLFront.render(scale);
        this.legLMid.render(scale);
        this.legLBack.render(scale);
        this.legRFront.render(scale);
        this.legRMid.render(scale);
        this.legRBack.render(scale);
        this.tail0.render(scale);
        this.tail1.render(scale);
        this.tail2.render(scale);
        GL11.glPopMatrix();
    }

    @Override
    public void setupAnimation(float limbSwing, float limbYaw, float limbPitch, float headYaw, float headPitch, float scale) {
        this.legLFront.setRotationAngle(0.0f, -2.618f, 0.3927f);
        this.legLMid.setRotationAngle(0.0f, 3.1416f, 0.3927f);
        this.legLBack.setRotationAngle(0.0f, 2.618f, 0.3927f);
        this.legRFront.setRotationAngle(0.0f, -0.5236f, -0.3927f);
        this.legRMid.setRotationAngle(0.0f, 0.0f, -0.3927f);
        this.legRBack.setRotationAngle(0.0f, 0.5236f, -0.3927f);
        float pair1Y = -(MathHelper.cos(limbSwing * 0.6662f * 2.0f + 0.0f) * 0.4f) * limbYaw;
        float pair2Y = -(MathHelper.cos(limbSwing * 0.6662f * 2.0f + (float)Math.PI) * 0.4f) * limbYaw;
        float pair3Y = -(MathHelper.cos(limbSwing * 0.6662f * 2.0f + 1.5707964f) * 0.4f) * limbYaw;
        this.legLFront.yRot += pair1Y;
        this.legLBack.yRot -= pair1Y;
        this.legRFront.yRot -= pair2Y;
        this.legRBack.yRot += pair2Y;
        this.legLMid.yRot += pair3Y;
        this.legRMid.yRot -= pair3Y;
    }
}

