/*
 * Decompiled with CFR 0.152.
 */
public class ChunkConverter {
    public int oldSaveVersion;
    public int newSaveVersion;
    protected MappingBase[] mappings;
    public static ChunkConverter[] converters = new ChunkConverter[4];

    public ChunkConverter(int oldSaveVersion, int newSaveVersion, int maxOldId) {
        this.oldSaveVersion = oldSaveVersion;
        this.newSaveVersion = newSaveVersion;
        this.mappings = new MappingBase[maxOldId + 1];
    }

    public void addMapping(MappingBase mapping) {
        this.mappings[mapping.id] = mapping;
    }

    public void convertBlocksAndMetadata(short[] blocks, byte[] metadata) {
        for (int i = 0; i < blocks.length; ++i) {
            if (blocks[i] < 0) continue;
            MappingBase mapping = this.mappings[blocks[i]];
            if (mapping == null) {
                blocks[i] = 0;
                metadata[i] = 0;
                continue;
            }
            int[] conversion = mapping.getConversion(metadata[i]);
            blocks[i] = (short)conversion[0];
            metadata[i] = (byte)conversion[1];
        }
    }

    static {
        ChunkConverter.converters[0] = new ChunkConverter(19132, 19133, 148);
        ChunkConverter chunkConverter = converters[0];
        ChunkConverter chunkConverter2 = converters[0];
        chunkConverter2.getClass();
        chunkConverter.addMapping(chunkConverter2.new MappingSimple(1, uu.u.bn));
        ChunkConverter chunkConverter3 = converters[0];
        ChunkConverter chunkConverter4 = converters[0];
        chunkConverter4.getClass();
        chunkConverter3.addMapping(chunkConverter4.new MappingSimple(2, uu.v.bn));
        ChunkConverter chunkConverter5 = converters[0];
        ChunkConverter chunkConverter6 = converters[0];
        chunkConverter6.getClass();
        chunkConverter5.addMapping(chunkConverter6.new MappingSimple(3, uu.w.bn));
        ChunkConverter chunkConverter7 = converters[0];
        ChunkConverter chunkConverter8 = converters[0];
        chunkConverter8.getClass();
        chunkConverter7.addMapping(chunkConverter8.new MappingSimple(4, uu.cobbleStone.bn));
        ChunkConverter chunkConverter9 = converters[0];
        ChunkConverter chunkConverter10 = converters[0];
        chunkConverter10.getClass();
        chunkConverter9.addMapping(chunkConverter10.new MappingSimple(5, uu.planksOak.bn));
        ChunkConverter chunkConverter11 = converters[0];
        ChunkConverter chunkConverter12 = converters[0];
        chunkConverter12.getClass();
        chunkConverter11.addMapping(chunkConverter12.new MappingMetaToId(6, new int[]{uu.saplingOak.bn, uu.saplingPine.bn, uu.saplingBirch.bn, uu.saplingCherry.bn}));
        ChunkConverter chunkConverter13 = converters[0];
        ChunkConverter chunkConverter14 = converters[0];
        chunkConverter14.getClass();
        chunkConverter13.addMapping(chunkConverter14.new MappingSimple(7, uu.A.bn));
        ChunkConverter chunkConverter15 = converters[0];
        ChunkConverter chunkConverter16 = converters[0];
        chunkConverter16.getClass();
        chunkConverter15.addMapping(chunkConverter16.new MappingSimple(8, uu.B.bn));
        ChunkConverter chunkConverter17 = converters[0];
        ChunkConverter chunkConverter18 = converters[0];
        chunkConverter18.getClass();
        chunkConverter17.addMapping(chunkConverter18.new MappingSimple(9, uu.C.bn));
        ChunkConverter chunkConverter19 = converters[0];
        ChunkConverter chunkConverter20 = converters[0];
        chunkConverter20.getClass();
        chunkConverter19.addMapping(chunkConverter20.new MappingSimple(10, uu.D.bn));
        ChunkConverter chunkConverter21 = converters[0];
        ChunkConverter chunkConverter22 = converters[0];
        chunkConverter22.getClass();
        chunkConverter21.addMapping(chunkConverter22.new MappingSimple(11, uu.E.bn));
        ChunkConverter chunkConverter23 = converters[0];
        ChunkConverter chunkConverter24 = converters[0];
        chunkConverter24.getClass();
        chunkConverter23.addMapping(chunkConverter24.new MappingSimple(12, uu.F.bn));
        ChunkConverter chunkConverter25 = converters[0];
        ChunkConverter chunkConverter26 = converters[0];
        chunkConverter26.getClass();
        chunkConverter25.addMapping(chunkConverter26.new MappingSimple(13, uu.G.bn));
        ChunkConverter chunkConverter27 = converters[0];
        ChunkConverter chunkConverter28 = converters[0];
        chunkConverter28.getClass();
        chunkConverter27.addMapping(chunkConverter28.new MappingMetaToId(14, new int[]{uu.oreGoldStone.bn, uu.oreGoldBasalt.bn, uu.oreGoldLimestone.bn, uu.oreGoldGranite.bn}));
        ChunkConverter chunkConverter29 = converters[0];
        ChunkConverter chunkConverter30 = converters[0];
        chunkConverter30.getClass();
        chunkConverter29.addMapping(chunkConverter30.new MappingMetaToId(15, new int[]{uu.oreIronStone.bn, uu.oreIronBasalt.bn, uu.oreIronLimestone.bn, uu.oreIronGranite.bn}));
        ChunkConverter chunkConverter31 = converters[0];
        ChunkConverter chunkConverter32 = converters[0];
        chunkConverter32.getClass();
        chunkConverter31.addMapping(chunkConverter32.new MappingMetaToId(16, new int[]{uu.oreCoalStone.bn, uu.oreCoalBasalt.bn, uu.oreCoalLimestone.bn, uu.oreCoalGranite.bn}));
        ChunkConverter chunkConverter33 = converters[0];
        ChunkConverter chunkConverter34 = converters[0];
        chunkConverter34.getClass();
        chunkConverter33.addMapping(chunkConverter34.new MappingMetaToId(17, new int[]{uu.logOak.bn, uu.logPine.bn, uu.logBirch.bn, uu.logCherry.bn}));
        ChunkConverter chunkConverter35 = converters[0];
        ChunkConverter chunkConverter36 = converters[0];
        chunkConverter36.getClass();
        chunkConverter35.addMapping(chunkConverter36.new MappingLeavesMetaToId(18, new int[]{uu.leavesOak.bn, uu.leavesPine.bn, uu.leavesBirch.bn, uu.leavesCherry.bn}));
        ChunkConverter chunkConverter37 = converters[0];
        ChunkConverter chunkConverter38 = converters[0];
        chunkConverter38.getClass();
        chunkConverter37.addMapping(chunkConverter38.new MappingSimple(19, uu.spongeDry.bn));
        ChunkConverter chunkConverter39 = converters[0];
        ChunkConverter chunkConverter40 = converters[0];
        chunkConverter40.getClass();
        chunkConverter39.addMapping(chunkConverter40.new MappingSimple(20, uu.N.bn));
        ChunkConverter chunkConverter41 = converters[0];
        ChunkConverter chunkConverter42 = converters[0];
        chunkConverter42.getClass();
        chunkConverter41.addMapping(chunkConverter42.new MappingMetaToId(21, new int[]{uu.oreLapisStone.bn, uu.oreLapisBasalt.bn, uu.oreLapisLimestone.bn, uu.oreLapisGranite.bn}));
        ChunkConverter chunkConverter43 = converters[0];
        ChunkConverter chunkConverter44 = converters[0];
        chunkConverter44.getClass();
        chunkConverter43.addMapping(chunkConverter44.new MappingSimple(22, uu.N.bn));
        ChunkConverter chunkConverter45 = converters[0];
        ChunkConverter chunkConverter46 = converters[0];
        chunkConverter46.getClass();
        chunkConverter45.addMapping(chunkConverter46.new MappingSimple(23, uu.Q.bn));
        ChunkConverter chunkConverter47 = converters[0];
        ChunkConverter chunkConverter48 = converters[0];
        chunkConverter48.getClass();
        chunkConverter47.addMapping(chunkConverter48.new MappingSimple(24, uu.sandstone.bn));
        ChunkConverter chunkConverter49 = converters[0];
        ChunkConverter chunkConverter50 = converters[0];
        chunkConverter50.getClass();
        chunkConverter49.addMapping(chunkConverter50.new MappingSimple(25, uu.noteBlock.bn));
        ChunkConverter chunkConverter51 = converters[0];
        ChunkConverter chunkConverter52 = converters[0];
        chunkConverter52.getClass();
        chunkConverter51.addMapping(chunkConverter52.new MappingSimple(26, uu.bed.bn));
        ChunkConverter chunkConverter53 = converters[0];
        ChunkConverter chunkConverter54 = converters[0];
        chunkConverter54.getClass();
        chunkConverter53.addMapping(chunkConverter54.new MappingSimple(27, uu.U.bn));
        ChunkConverter chunkConverter55 = converters[0];
        ChunkConverter chunkConverter56 = converters[0];
        chunkConverter56.getClass();
        chunkConverter55.addMapping(chunkConverter56.new MappingSimple(28, uu.V.bn));
        ChunkConverter chunkConverter57 = converters[0];
        ChunkConverter chunkConverter58 = converters[0];
        chunkConverter58.getClass();
        chunkConverter57.addMapping(chunkConverter58.new MappingSimple(29, uu.pistonSticky.bn));
        ChunkConverter chunkConverter59 = converters[0];
        ChunkConverter chunkConverter60 = converters[0];
        chunkConverter60.getClass();
        chunkConverter59.addMapping(chunkConverter60.new MappingSimple(30, uu.cobweb.bn));
        ChunkConverter chunkConverter61 = converters[0];
        ChunkConverter chunkConverter62 = converters[0];
        chunkConverter62.getClass();
        chunkConverter61.addMapping(chunkConverter62.new MappingMetaToId(31, new int[]{uu.Z.bn, uu.Y.bn, uu.fern.bn}));
        ChunkConverter chunkConverter63 = converters[0];
        ChunkConverter chunkConverter64 = converters[0];
        chunkConverter64.getClass();
        chunkConverter63.addMapping(chunkConverter64.new MappingSimple(32, uu.Z.bn));
        ChunkConverter chunkConverter65 = converters[0];
        ChunkConverter chunkConverter66 = converters[0];
        chunkConverter66.getClass();
        chunkConverter65.addMapping(chunkConverter66.new MappingSimple(33, uu.piston.bn));
        ChunkConverter chunkConverter67 = converters[0];
        ChunkConverter chunkConverter68 = converters[0];
        chunkConverter68.getClass();
        chunkConverter67.addMapping(chunkConverter68.new MappingSimple(34, uu.ab.bn));
        ChunkConverter chunkConverter69 = converters[0];
        ChunkConverter chunkConverter70 = converters[0];
        chunkConverter70.getClass();
        chunkConverter69.addMapping(chunkConverter70.new MappingSimple(35, uu.wool.bn));
        ChunkConverter chunkConverter71 = converters[0];
        ChunkConverter chunkConverter72 = converters[0];
        chunkConverter72.getClass();
        chunkConverter71.addMapping(chunkConverter72.new MappingSimple(36, uu.ad.bn));
        ChunkConverter chunkConverter73 = converters[0];
        ChunkConverter chunkConverter74 = converters[0];
        chunkConverter74.getClass();
        chunkConverter73.addMapping(chunkConverter74.new MappingSimple(37, uu.flowerYellow.bn));
        ChunkConverter chunkConverter75 = converters[0];
        ChunkConverter chunkConverter76 = converters[0];
        chunkConverter76.getClass();
        chunkConverter75.addMapping(chunkConverter76.new MappingSimple(38, uu.flowerRed.bn));
        ChunkConverter chunkConverter77 = converters[0];
        ChunkConverter chunkConverter78 = converters[0];
        chunkConverter78.getClass();
        chunkConverter77.addMapping(chunkConverter78.new MappingSimple(39, uu.ag.bn));
        ChunkConverter chunkConverter79 = converters[0];
        ChunkConverter chunkConverter80 = converters[0];
        chunkConverter80.getClass();
        chunkConverter79.addMapping(chunkConverter80.new MappingSimple(40, uu.ah.bn));
        ChunkConverter chunkConverter81 = converters[0];
        ChunkConverter chunkConverter82 = converters[0];
        chunkConverter82.getClass();
        chunkConverter81.addMapping(chunkConverter82.new MappingSimple(41, uu.ai.bn));
        ChunkConverter chunkConverter83 = converters[0];
        ChunkConverter chunkConverter84 = converters[0];
        chunkConverter84.getClass();
        chunkConverter83.addMapping(chunkConverter84.new MappingSimple(42, uu.blockIron.bn));
        ChunkConverter chunkConverter85 = converters[0];
        ChunkConverter chunkConverter86 = converters[0];
        chunkConverter86.getClass();
        chunkConverter85.addMapping(chunkConverter86.new MappingComplex(43, new int[]{uu.slabCarvedStone.bn, uu.slabSandstone.bn, uu.slabPlanksOak.bn, uu.slabCobbleStone.bn, uu.slabBrickStone.bn}, new int[]{1, 1, 1, 1, 1}));
        ChunkConverter chunkConverter87 = converters[0];
        ChunkConverter chunkConverter88 = converters[0];
        chunkConverter88.getClass();
        chunkConverter87.addMapping(chunkConverter88.new MappingComplex(44, new int[]{uu.slabCarvedStone.bn, uu.slabSandstone.bn, uu.slabPlanksOak.bn, uu.slabCobbleStone.bn, uu.slabBrickStone.bn}, new int[]{0, 0, 0, 0, 0}));
        ChunkConverter chunkConverter89 = converters[0];
        ChunkConverter chunkConverter90 = converters[0];
        chunkConverter90.getClass();
        chunkConverter89.addMapping(chunkConverter90.new MappingSimple(45, uu.brickClay.bn));
        ChunkConverter chunkConverter91 = converters[0];
        ChunkConverter chunkConverter92 = converters[0];
        chunkConverter92.getClass();
        chunkConverter91.addMapping(chunkConverter92.new MappingSimple(46, uu.an.bn));
        ChunkConverter chunkConverter93 = converters[0];
        ChunkConverter chunkConverter94 = converters[0];
        chunkConverter94.getClass();
        chunkConverter93.addMapping(chunkConverter94.new MappingSimple(47, uu.bookshelfPlanksOak.bn));
        ChunkConverter chunkConverter95 = converters[0];
        ChunkConverter chunkConverter96 = converters[0];
        chunkConverter96.getClass();
        chunkConverter95.addMapping(chunkConverter96.new MappingSimple(48, uu.cobbleStoneMossy.bn));
        ChunkConverter chunkConverter97 = converters[0];
        ChunkConverter chunkConverter98 = converters[0];
        chunkConverter98.getClass();
        chunkConverter97.addMapping(chunkConverter98.new MappingSimple(49, uu.aq.bn));
        ChunkConverter chunkConverter99 = converters[0];
        ChunkConverter chunkConverter100 = converters[0];
        chunkConverter100.getClass();
        chunkConverter99.addMapping(chunkConverter100.new MappingSimple(50, uu.torchCoal.bn));
        ChunkConverter chunkConverter101 = converters[0];
        ChunkConverter chunkConverter102 = converters[0];
        chunkConverter102.getClass();
        chunkConverter101.addMapping(chunkConverter102.new MappingSimple(51, uu.as.bn));
        ChunkConverter chunkConverter103 = converters[0];
        ChunkConverter chunkConverter104 = converters[0];
        chunkConverter104.getClass();
        chunkConverter103.addMapping(chunkConverter104.new MappingSimple(52, uu.at.bn));
        ChunkConverter chunkConverter105 = converters[0];
        ChunkConverter chunkConverter106 = converters[0];
        chunkConverter106.getClass();
        chunkConverter105.addMapping(chunkConverter106.new MappingSimple(53, uu.stairsPlanksOak.bn));
        ChunkConverter chunkConverter107 = converters[0];
        ChunkConverter chunkConverter108 = converters[0];
        chunkConverter108.getClass();
        chunkConverter107.addMapping(chunkConverter108.new MappingSimple(54, uu.chestPlanksOak.bn));
        ChunkConverter chunkConverter109 = converters[0];
        ChunkConverter chunkConverter110 = converters[0];
        chunkConverter110.getClass();
        chunkConverter109.addMapping(chunkConverter110.new MappingSimple(55, uu.wireRedstone.bn));
        ChunkConverter chunkConverter111 = converters[0];
        ChunkConverter chunkConverter112 = converters[0];
        chunkConverter112.getClass();
        chunkConverter111.addMapping(chunkConverter112.new MappingMetaToId(56, new int[]{uu.oreDiamondStone.bn, uu.oreDiamondBasalt.bn, uu.oreDiamondLimestone.bn, uu.oreDiamondGranite.bn}));
        ChunkConverter chunkConverter113 = converters[0];
        ChunkConverter chunkConverter114 = converters[0];
        chunkConverter114.getClass();
        chunkConverter113.addMapping(chunkConverter114.new MappingSimple(57, uu.ay.bn));
        ChunkConverter chunkConverter115 = converters[0];
        ChunkConverter chunkConverter116 = converters[0];
        chunkConverter116.getClass();
        chunkConverter115.addMapping(chunkConverter116.new MappingSimple(58, uu.az.bn));
        ChunkConverter chunkConverter117 = converters[0];
        ChunkConverter chunkConverter118 = converters[0];
        chunkConverter118.getClass();
        chunkConverter117.addMapping(chunkConverter118.new MappingSimple(59, uu.cropsWheat.bn));
        ChunkConverter chunkConverter119 = converters[0];
        ChunkConverter chunkConverter120 = converters[0];
        chunkConverter120.getClass();
        chunkConverter119.addMapping(chunkConverter120.new MappingSimple(60, uu.farmlandDirt.bn));
        ChunkConverter chunkConverter121 = converters[0];
        ChunkConverter chunkConverter122 = converters[0];
        chunkConverter122.getClass();
        chunkConverter121.addMapping(chunkConverter122.new MappingSimple(61, uu.furnaceStoneIdle.bn));
        ChunkConverter chunkConverter123 = converters[0];
        ChunkConverter chunkConverter124 = converters[0];
        chunkConverter124.getClass();
        chunkConverter123.addMapping(chunkConverter124.new MappingSimple(62, uu.furnaceStoneActive.bn));
        ChunkConverter chunkConverter125 = converters[0];
        ChunkConverter chunkConverter126 = converters[0];
        chunkConverter126.getClass();
        chunkConverter125.addMapping(chunkConverter126.new MappingSimple(63, uu.signPostPlanksOak.bn));
        ChunkConverter chunkConverter127 = converters[0];
        ChunkConverter chunkConverter128 = converters[0];
        chunkConverter128.getClass();
        chunkConverter127.addMapping(chunkConverter128.new MappingSimple(64, uu.doorPlanksOakBottom.bn));
        ChunkConverter chunkConverter129 = converters[0];
        ChunkConverter chunkConverter130 = converters[0];
        chunkConverter130.getClass();
        chunkConverter129.addMapping(chunkConverter130.new MappingSimple(65, uu.ladderOak.bn));
        ChunkConverter chunkConverter131 = converters[0];
        ChunkConverter chunkConverter132 = converters[0];
        chunkConverter132.getClass();
        chunkConverter131.addMapping(chunkConverter132.new MappingSimple(66, uu.aH.bn));
        ChunkConverter chunkConverter133 = converters[0];
        ChunkConverter chunkConverter134 = converters[0];
        chunkConverter134.getClass();
        chunkConverter133.addMapping(chunkConverter134.new MappingSimple(67, uu.stairsCobbleStone.bn));
        ChunkConverter chunkConverter135 = converters[0];
        ChunkConverter chunkConverter136 = converters[0];
        chunkConverter136.getClass();
        chunkConverter135.addMapping(chunkConverter136.new MappingSimple(68, uu.signWallPlanksOak.bn));
        ChunkConverter chunkConverter137 = converters[0];
        ChunkConverter chunkConverter138 = converters[0];
        chunkConverter138.getClass();
        chunkConverter137.addMapping(chunkConverter138.new MappingSimple(69, uu.leverCobbleStone.bn));
        ChunkConverter chunkConverter139 = converters[0];
        ChunkConverter chunkConverter140 = converters[0];
        chunkConverter140.getClass();
        chunkConverter139.addMapping(chunkConverter140.new MappingSimple(70, uu.aL.bn));
        ChunkConverter chunkConverter141 = converters[0];
        ChunkConverter chunkConverter142 = converters[0];
        chunkConverter142.getClass();
        chunkConverter141.addMapping(chunkConverter142.new MappingSimple(71, uu.doorIronBottom.bn));
        ChunkConverter chunkConverter143 = converters[0];
        ChunkConverter chunkConverter144 = converters[0];
        chunkConverter144.getClass();
        chunkConverter143.addMapping(chunkConverter144.new MappingSimple(72, uu.pressurePlatePlanksOak.bn));
        ChunkConverter chunkConverter145 = converters[0];
        ChunkConverter chunkConverter146 = converters[0];
        chunkConverter146.getClass();
        chunkConverter145.addMapping(chunkConverter146.new MappingMetaToId(73, new int[]{uu.oreRedstoneStone.bn, uu.oreRedstoneBasalt.bn, uu.oreRedstoneLimestone.bn, uu.oreRedstoneGranite.bn}));
        ChunkConverter chunkConverter147 = converters[0];
        ChunkConverter chunkConverter148 = converters[0];
        chunkConverter148.getClass();
        chunkConverter147.addMapping(chunkConverter148.new MappingMetaToId(74, new int[]{uu.oreRedstoneGlowingStone.bn, uu.oreRedstoneGlowingBasalt.bn, uu.oreRedstoneGlowingLimestone.bn, uu.oreRedstoneGlowingGranite.bn}));
        ChunkConverter chunkConverter149 = converters[0];
        ChunkConverter chunkConverter150 = converters[0];
        chunkConverter150.getClass();
        chunkConverter149.addMapping(chunkConverter150.new MappingSimple(75, uu.aQ.bn));
        ChunkConverter chunkConverter151 = converters[0];
        ChunkConverter chunkConverter152 = converters[0];
        chunkConverter152.getClass();
        chunkConverter151.addMapping(chunkConverter152.new MappingSimple(76, uu.aR.bn));
        ChunkConverter chunkConverter153 = converters[0];
        ChunkConverter chunkConverter154 = converters[0];
        chunkConverter154.getClass();
        chunkConverter153.addMapping(chunkConverter154.new MappingSimple(77, uu.buttonStone.bn));
        ChunkConverter chunkConverter155 = converters[0];
        ChunkConverter chunkConverter156 = converters[0];
        chunkConverter156.getClass();
        chunkConverter155.addMapping(chunkConverter156.new MappingSimple(78, uu.layerSnow.bn));
        ChunkConverter chunkConverter157 = converters[0];
        ChunkConverter chunkConverter158 = converters[0];
        chunkConverter158.getClass();
        chunkConverter157.addMapping(chunkConverter158.new MappingSimple(79, uu.aU.bn));
        ChunkConverter chunkConverter159 = converters[0];
        ChunkConverter chunkConverter160 = converters[0];
        chunkConverter160.getClass();
        chunkConverter159.addMapping(chunkConverter160.new MappingSimple(80, uu.aT.bn));
        ChunkConverter chunkConverter161 = converters[0];
        ChunkConverter chunkConverter162 = converters[0];
        chunkConverter162.getClass();
        chunkConverter161.addMapping(chunkConverter162.new MappingSimple(81, uu.aW.bn));
        ChunkConverter chunkConverter163 = converters[0];
        ChunkConverter chunkConverter164 = converters[0];
        chunkConverter164.getClass();
        chunkConverter163.addMapping(chunkConverter164.new MappingSimple(82, uu.clay.bn));
        ChunkConverter chunkConverter165 = converters[0];
        ChunkConverter chunkConverter166 = converters[0];
        chunkConverter166.getClass();
        chunkConverter165.addMapping(chunkConverter166.new MappingSimple(83, uu.sugarcane.bn));
        ChunkConverter chunkConverter167 = converters[0];
        ChunkConverter chunkConverter168 = converters[0];
        chunkConverter168.getClass();
        chunkConverter167.addMapping(chunkConverter168.new MappingSimple(84, uu.aZ.bn));
        ChunkConverter chunkConverter169 = converters[0];
        ChunkConverter chunkConverter170 = converters[0];
        chunkConverter170.getClass();
        chunkConverter169.addMapping(chunkConverter170.new MappingSimple(85, uu.fencePlanksOak.bn));
        ChunkConverter chunkConverter171 = converters[0];
        ChunkConverter chunkConverter172 = converters[0];
        chunkConverter172.getClass();
        chunkConverter171.addMapping(chunkConverter172.new MappingSimple(86, uu.pumpkinCarved.bn));
        ChunkConverter chunkConverter173 = converters[0];
        ChunkConverter chunkConverter174 = converters[0];
        chunkConverter174.getClass();
        chunkConverter173.addMapping(chunkConverter174.new MappingSimple(87, uu.bc.bn));
        ChunkConverter chunkConverter175 = converters[0];
        ChunkConverter chunkConverter176 = converters[0];
        chunkConverter176.getClass();
        chunkConverter175.addMapping(chunkConverter176.new MappingSimple(88, uu.soulsand.bn));
        ChunkConverter chunkConverter177 = converters[0];
        ChunkConverter chunkConverter178 = converters[0];
        chunkConverter178.getClass();
        chunkConverter177.addMapping(chunkConverter178.new MappingSimple(89, uu.glowstone.bn));
        ChunkConverter chunkConverter179 = converters[0];
        ChunkConverter chunkConverter180 = converters[0];
        chunkConverter180.getClass();
        chunkConverter179.addMapping(chunkConverter180.new MappingSimple(90, uu.portalNether.bn));
        ChunkConverter chunkConverter181 = converters[0];
        ChunkConverter chunkConverter182 = converters[0];
        chunkConverter182.getClass();
        chunkConverter181.addMapping(chunkConverter182.new MappingSimple(91, uu.pumpkinLit.bn));
        ChunkConverter chunkConverter183 = converters[0];
        ChunkConverter chunkConverter184 = converters[0];
        chunkConverter184.getClass();
        chunkConverter183.addMapping(chunkConverter184.new MappingSimple(92, uu.bh.bn));
        ChunkConverter chunkConverter185 = converters[0];
        ChunkConverter chunkConverter186 = converters[0];
        chunkConverter186.getClass();
        chunkConverter185.addMapping(chunkConverter186.new MappingSimple(93, uu.bi.bn));
        ChunkConverter chunkConverter187 = converters[0];
        ChunkConverter chunkConverter188 = converters[0];
        chunkConverter188.getClass();
        chunkConverter187.addMapping(chunkConverter188.new MappingSimple(94, uu.bj.bn));
        ChunkConverter chunkConverter189 = converters[0];
        ChunkConverter chunkConverter190 = converters[0];
        chunkConverter190.getClass();
        chunkConverter189.addMapping(chunkConverter190.new MappingSimple(96, uu.trapdoorPlanksOak.bn));
        ChunkConverter chunkConverter191 = converters[0];
        ChunkConverter chunkConverter192 = converters[0];
        chunkConverter192.getClass();
        chunkConverter191.addMapping(chunkConverter192.new MappingSimple(97, uu.brickStone.bn));
        ChunkConverter chunkConverter193 = converters[0];
        ChunkConverter chunkConverter194 = converters[0];
        chunkConverter194.getClass();
        chunkConverter193.addMapping(chunkConverter194.new MappingSimple(98, uu.brickStoneMossy.bn));
        ChunkConverter chunkConverter195 = converters[0];
        ChunkConverter chunkConverter196 = converters[0];
        chunkConverter196.getClass();
        chunkConverter195.addMapping(chunkConverter196.new MappingSimple(99, uu.brickSandstone.bn));
        ChunkConverter chunkConverter197 = converters[0];
        ChunkConverter chunkConverter198 = converters[0];
        chunkConverter198.getClass();
        chunkConverter197.addMapping(chunkConverter198.new MappingSimple(100, uu.brickGold.bn));
        ChunkConverter chunkConverter199 = converters[0];
        ChunkConverter chunkConverter200 = converters[0];
        chunkConverter200.getClass();
        chunkConverter199.addMapping(chunkConverter200.new MappingSimple(101, uu.brickLapis.bn));
        ChunkConverter chunkConverter201 = converters[0];
        ChunkConverter chunkConverter202 = converters[0];
        chunkConverter202.getClass();
        chunkConverter201.addMapping(chunkConverter202.new MappingSimple(102, uu.pathDirt.bn));
        ChunkConverter chunkConverter203 = converters[0];
        ChunkConverter chunkConverter204 = converters[0];
        chunkConverter204.getClass();
        chunkConverter203.addMapping(chunkConverter204.new MappingSimple(103, uu.stairsBrickStone.bn));
        ChunkConverter chunkConverter205 = converters[0];
        ChunkConverter chunkConverter206 = converters[0];
        chunkConverter206.getClass();
        chunkConverter205.addMapping(chunkConverter206.new MappingSimple(104, uu.fenceGatePlanksOak.bn));
        ChunkConverter chunkConverter207 = converters[0];
        ChunkConverter chunkConverter208 = converters[0];
        chunkConverter208.getClass();
        chunkConverter207.addMapping(chunkConverter208.new MappingSimple(105, uu.spike.bn));
        ChunkConverter chunkConverter209 = converters[0];
        ChunkConverter chunkConverter210 = converters[0];
        chunkConverter210.getClass();
        chunkConverter209.addMapping(chunkConverter210.new MappingSimple(106, uu.mesh.bn));
        ChunkConverter chunkConverter211 = converters[0];
        ChunkConverter chunkConverter212 = converters[0];
        chunkConverter212.getClass();
        chunkConverter211.addMapping(chunkConverter212.new MappingSimple(107, uu.basalt.bn));
        ChunkConverter chunkConverter213 = converters[0];
        ChunkConverter chunkConverter214 = converters[0];
        chunkConverter214.getClass();
        chunkConverter213.addMapping(chunkConverter214.new MappingSimple(108, uu.limestone.bn));
        ChunkConverter chunkConverter215 = converters[0];
        ChunkConverter chunkConverter216 = converters[0];
        chunkConverter216.getClass();
        chunkConverter215.addMapping(chunkConverter216.new MappingSimple(109, uu.granite.bn));
        ChunkConverter chunkConverter217 = converters[0];
        ChunkConverter chunkConverter218 = converters[0];
        chunkConverter218.getClass();
        chunkConverter217.addMapping(chunkConverter218.new MappingMetaToId(110, new int[]{uu.mossStone.bn, uu.mossBasalt.bn, uu.mossLimestone.bn, uu.mossGranite.bn}));
        ChunkConverter chunkConverter219 = converters[0];
        ChunkConverter chunkConverter220 = converters[0];
        chunkConverter220.getClass();
        chunkConverter219.addMapping(chunkConverter220.new MappingSimple(111, uu.oreNetherCoalNetherrack.bn));
        ChunkConverter chunkConverter221 = converters[0];
        ChunkConverter chunkConverter222 = converters[0];
        chunkConverter222.getClass();
        chunkConverter221.addMapping(chunkConverter222.new MappingSimple(112, uu.furnaceBlastIdle.bn));
        ChunkConverter chunkConverter223 = converters[0];
        ChunkConverter chunkConverter224 = converters[0];
        chunkConverter224.getClass();
        chunkConverter223.addMapping(chunkConverter224.new MappingSimple(113, uu.furnaceBlastActive.bn));
        ChunkConverter chunkConverter225 = converters[0];
        ChunkConverter chunkConverter226 = converters[0];
        chunkConverter226.getClass();
        chunkConverter225.addMapping(chunkConverter226.new MappingSimple(114, uu.aj.bn));
        ChunkConverter chunkConverter227 = converters[0];
        ChunkConverter chunkConverter228 = converters[0];
        chunkConverter228.getClass();
        chunkConverter227.addMapping(chunkConverter228.new MappingSimple(115, uu.spongeWet.bn));
        ChunkConverter chunkConverter229 = converters[0];
        ChunkConverter chunkConverter230 = converters[0];
        chunkConverter230.getClass();
        chunkConverter229.addMapping(chunkConverter230.new MappingSimple(116, uu.pressurePlateCobbleStone.bn));
        ChunkConverter chunkConverter231 = converters[0];
        ChunkConverter chunkConverter232 = converters[0];
        chunkConverter232.getClass();
        chunkConverter231.addMapping(chunkConverter232.new MappingSimple(117, uu.cobbleBasalt.bn));
        ChunkConverter chunkConverter233 = converters[0];
        ChunkConverter chunkConverter234 = converters[0];
        chunkConverter234.getClass();
        chunkConverter233.addMapping(chunkConverter234.new MappingSimple(118, uu.cobbleLimestone.bn));
        ChunkConverter chunkConverter235 = converters[0];
        ChunkConverter chunkConverter236 = converters[0];
        chunkConverter236.getClass();
        chunkConverter235.addMapping(chunkConverter236.new MappingSimple(119, uu.cobbleGranite.bn));
        ChunkConverter chunkConverter237 = converters[0];
        ChunkConverter chunkConverter238 = converters[0];
        chunkConverter238.getClass();
        chunkConverter237.addMapping(chunkConverter238.new MappingSimple(120, uu.brickBasalt.bn));
        ChunkConverter chunkConverter239 = converters[0];
        ChunkConverter chunkConverter240 = converters[0];
        chunkConverter240.getClass();
        chunkConverter239.addMapping(chunkConverter240.new MappingSimple(121, uu.brickLimestone.bn));
        ChunkConverter chunkConverter241 = converters[0];
        ChunkConverter chunkConverter242 = converters[0];
        chunkConverter242.getClass();
        chunkConverter241.addMapping(chunkConverter242.new MappingSimple(122, uu.brickGranite.bn));
        ChunkConverter chunkConverter243 = converters[0];
        ChunkConverter chunkConverter244 = converters[0];
        chunkConverter244.getClass();
        chunkConverter243.addMapping(chunkConverter244.new MappingSimple(123, uu.motionSensorIdle.bn));
        ChunkConverter chunkConverter245 = converters[0];
        ChunkConverter chunkConverter246 = converters[0];
        chunkConverter246.getClass();
        chunkConverter245.addMapping(chunkConverter246.new MappingSimple(124, uu.motionSensorActive.bn));
        ChunkConverter chunkConverter247 = converters[0];
        ChunkConverter chunkConverter248 = converters[0];
        chunkConverter248.getClass();
        chunkConverter247.addMapping(chunkConverter248.new MappingSimple(125, uu.slabPlanksOak.bn));
        ChunkConverter chunkConverter249 = converters[0];
        ChunkConverter chunkConverter250 = converters[0];
        chunkConverter250.getClass();
        chunkConverter249.addMapping(chunkConverter250.new MappingSimple(126, uu.slabCobbleStone.bn));
        ChunkConverter chunkConverter251 = converters[0];
        ChunkConverter chunkConverter252 = converters[0];
        chunkConverter252.getClass();
        chunkConverter251.addMapping(chunkConverter252.new MappingSimple(127, uu.slabSandstone.bn));
        ChunkConverter chunkConverter253 = converters[0];
        ChunkConverter chunkConverter254 = converters[0];
        chunkConverter254.getClass();
        chunkConverter253.addMapping(chunkConverter254.new MappingSimple(128, uu.slabBrickStone.bn));
        ChunkConverter chunkConverter255 = converters[0];
        ChunkConverter chunkConverter256 = converters[0];
        chunkConverter256.getClass();
        chunkConverter255.addMapping(chunkConverter256.new MappingSimple(129, uu.slabCarvedStone.bn));
        ChunkConverter chunkConverter257 = converters[0];
        ChunkConverter chunkConverter258 = converters[0];
        chunkConverter258.getClass();
        chunkConverter257.addMapping(chunkConverter258.new MappingSimple(130, uu.slabBrickClay.bn));
        ChunkConverter chunkConverter259 = converters[0];
        ChunkConverter chunkConverter260 = converters[0];
        chunkConverter260.getClass();
        chunkConverter259.addMapping(chunkConverter260.new MappingSimple(131, uu.doorPlanksOakTop.bn));
        ChunkConverter chunkConverter261 = converters[0];
        ChunkConverter chunkConverter262 = converters[0];
        chunkConverter262.getClass();
        chunkConverter261.addMapping(chunkConverter262.new MappingSimple(132, uu.doorIronTop.bn));
        ChunkConverter chunkConverter263 = converters[0];
        ChunkConverter chunkConverter264 = converters[0];
        chunkConverter264.getClass();
        chunkConverter263.addMapping(chunkConverter264.new MappingSimple(134, uu.layerLeavesOak.bn));
        ChunkConverter chunkConverter265 = converters[0];
        ChunkConverter chunkConverter266 = converters[0];
        chunkConverter266.getClass();
        chunkConverter265.addMapping(chunkConverter266.new MappingSimple(135, uu.portalParadise.bn));
        ChunkConverter chunkConverter267 = converters[0];
        ChunkConverter chunkConverter268 = converters[0];
        chunkConverter268.getClass();
        chunkConverter267.addMapping(chunkConverter268.new MappingSimple(136, uu.grassRetro.bn));
        ChunkConverter chunkConverter269 = converters[0];
        ChunkConverter chunkConverter270 = converters[0];
        chunkConverter270.getClass();
        chunkConverter269.addMapping(chunkConverter270.new MappingSimple(137, uu.leavesRetro.bn));
        ChunkConverter chunkConverter271 = converters[0];
        ChunkConverter chunkConverter272 = converters[0];
        chunkConverter272.getClass();
        chunkConverter271.addMapping(chunkConverter272.new MappingSimple(138, uu.trommelActive.bn));
        ChunkConverter chunkConverter273 = converters[0];
        ChunkConverter chunkConverter274 = converters[0];
        chunkConverter274.getClass();
        chunkConverter273.addMapping(chunkConverter274.new MappingSimple(139, uu.bb.bn));
        ChunkConverter chunkConverter275 = converters[0];
        ChunkConverter chunkConverter276 = converters[0];
        chunkConverter276.getClass();
        chunkConverter275.addMapping(chunkConverter276.new MappingSimple(140, uu.trommelIdle.bn));
        ChunkConverter chunkConverter277 = converters[0];
        ChunkConverter chunkConverter278 = converters[0];
        chunkConverter278.getClass();
        chunkConverter277.addMapping(chunkConverter278.new MappingSimple(141, uu.netherrackIgneous.bn));
        ChunkConverter chunkConverter279 = converters[0];
        ChunkConverter chunkConverter280 = converters[0];
        chunkConverter280.getClass();
        chunkConverter279.addMapping(chunkConverter280.new MappingSimple(142, uu.marble.bn));
        ChunkConverter chunkConverter281 = converters[0];
        ChunkConverter chunkConverter282 = converters[0];
        chunkConverter282.getClass();
        chunkConverter281.addMapping(chunkConverter282.new MappingSimple(143, uu.pillarMarble.bn));
        ChunkConverter chunkConverter283 = converters[0];
        ChunkConverter chunkConverter284 = converters[0];
        chunkConverter284.getClass();
        chunkConverter283.addMapping(chunkConverter284.new MappingSimple(144, uu.brickMarble.bn));
        ChunkConverter chunkConverter285 = converters[0];
        ChunkConverter chunkConverter286 = converters[0];
        chunkConverter286.getClass();
        chunkConverter285.addMapping(chunkConverter286.new MappingSimple(145, uu.stairsBrickMarble.bn));
        ChunkConverter chunkConverter287 = converters[0];
        ChunkConverter chunkConverter288 = converters[0];
        chunkConverter288.getClass();
        chunkConverter287.addMapping(chunkConverter288.new MappingSimple(146, uu.slabBrickMarble.bn));
        ChunkConverter chunkConverter289 = converters[0];
        ChunkConverter chunkConverter290 = converters[0];
        chunkConverter290.getClass();
        chunkConverter289.addMapping(chunkConverter290.new MappingSimple(147, uu.dirtScorchedRich.bn));
        ChunkConverter chunkConverter291 = converters[0];
        ChunkConverter chunkConverter292 = converters[0];
        chunkConverter292.getClass();
        chunkConverter291.addMapping(chunkConverter292.new MappingSimple(148, uu.dirtScorched.bn));
    }

    protected class MappingComplex
    extends MappingBase {
        protected int[] metaIds;
        protected int[] metaMetas;
        protected int backup;

        public MappingComplex(int oldId, int[] metaIds, int[] metaMetas) {
            this(oldId, metaIds, metaMetas, 0);
        }

        public MappingComplex(int oldId, int[] metaIds, int[] metaMetas, int backup) {
            super(oldId);
            if (metaIds.length != metaMetas.length) {
                throw new IllegalArgumentException();
            }
            this.metaIds = metaIds;
            this.metaMetas = metaMetas;
            this.backup = backup;
        }

        @Override
        public int[] getConversion(int metadata) {
            if (metadata > this.metaIds.length) {
                return new int[]{this.backup, 0};
            }
            return new int[]{this.metaIds[metadata], this.metaMetas[metadata]};
        }
    }

    protected class MappingLeavesMetaToId
    extends MappingBase {
        protected int[] metaIds;
        protected int backup;

        public MappingLeavesMetaToId(int oldId, int[] metaIds) {
            this(oldId, metaIds, 0);
        }

        public MappingLeavesMetaToId(int oldId, int[] metaIds, int backup) {
            super(oldId);
            this.metaIds = metaIds;
            this.backup = backup;
        }

        @Override
        public int[] getConversion(int metadata) {
            if ((metadata & 3) >= this.metaIds.length) {
                return new int[]{this.backup, 0};
            }
            return new int[]{this.metaIds[metadata & 3], metadata & 0xC};
        }
    }

    protected class MappingMetaToId
    extends MappingBase {
        protected int[] metaIds;
        protected int backup;

        public MappingMetaToId(int oldId, int[] metaIds) {
            this(oldId, metaIds, 0);
        }

        public MappingMetaToId(int oldId, int[] metaIds, int backup) {
            super(oldId);
            this.metaIds = metaIds;
            this.backup = backup;
        }

        @Override
        public int[] getConversion(int metadata) {
            if (metadata >= this.metaIds.length) {
                return new int[]{this.backup, 0};
            }
            return new int[]{this.metaIds[metadata], 0};
        }
    }

    protected class MappingSimple
    extends MappingBase {
        protected int newId;

        public MappingSimple(int oldId, int newId) {
            super(oldId);
            this.newId = newId;
        }

        @Override
        public int[] getConversion(int metadata) {
            return new int[]{this.newId, metadata};
        }
    }

    protected abstract class MappingBase {
        public int id;

        public MappingBase(int id2) {
            this.id = id2;
        }

        public abstract int[] getConversion(int var1);
    }
}

