/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;

public abstract class Command {
    public String[] triggers;
    public String helpText;
    public static Command[] commands = new Command[]{new Command(new String[]{"help", "?"}, "/help"){

        @Override
        public boolean runCommand(Minecraft mc2, fd worldObj, gs player, String[] args) throws Exception {
            for (int i = 0; i < commands.length; ++i) {
                mc2.v.a(1.commands[i].helpText);
            }
            return true;
        }
    }, new Command(new String[]{"tp"}, "/tp <x> <y> <z>"){

        @Override
        public boolean runCommand(Minecraft mc2, fd worldObj, gs player, String[] args) throws Exception {
            if (args.length != 4) {
                return false;
            }
            int x = Integer.parseInt(args[1]);
            int y = Integer.parseInt(args[2]);
            int z2 = Integer.parseInt(args[3]);
            player.e(x, y, z2);
            mc2.v.a("Teleporting to x: " + x + ", y: " + y + ", z: " + z2 + ".");
            return true;
        }
    }, new Command(new String[]{"time"}, "/time <set|get> <time>"){

        @Override
        public boolean runCommand(Minecraft mc2, fd worldObj, gs player, String[] args) throws Exception {
            if (args.length == 3 && args[1].equals("set")) {
                long newTime = -1L;
                newTime = args[2].equals("sunrise") ? worldObj.t() / 24000L * 24000L : (args[2].equals("noon") ? worldObj.t() / 24000L * 24000L + 6000L : (args[2].equals("sunset") ? worldObj.t() / 24000L * 24000L + 12000L : (args[2].equals("midnight") ? worldObj.t() / 24000L * 24000L + 18000L : (args[2].startsWith("spring") ? Long.parseLong(args[2].substring(6)) * 24000L : (args[2].startsWith("summer") ? 168000L + Long.parseLong(args[2].substring(6)) * 24000L : (args[2].startsWith("fall") ? 336000L + Long.parseLong(args[2].substring(4)) * 24000L : (args[2].startsWith("winter") ? 504000L + Long.parseLong(args[2].substring(6)) * 24000L : Long.parseLong(args[2]))))))));
                worldObj.setWorldTimeUpdateTicks(newTime);
                mc2.v.a("Setting time to " + newTime + ".");
                return true;
            }
            if (args.length == 2 && args[1].equals("get")) {
                mc2.v.a("Current time: " + worldObj.t() + ".");
                return true;
            }
            return false;
        }
    }, new Command(new String[]{"weather"}, "/weather <value>"){

        @Override
        public boolean runCommand(Minecraft mc2, fd worldObj, gs player, String[] args) throws Exception {
            if (args.length == 2) {
                if (args[1].equals("next")) {
                    worldObj.weatherDuration = 0L;
                    mc2.v.a("Skipping to next weather.");
                } else {
                    int newWeather = Integer.parseInt(args[1]);
                    worldObj.newWeather = Weather.weatherList[newWeather];
                    worldObj.weatherDuration = net.minecraft.shared.Minecraft.DAY_LENGTH_TICKS;
                    mc2.v.a("Setting weather to " + worldObj.newWeather.getName() + ".");
                }
                if (worldObj.currentWeather == worldObj.dimension.worldType.defaultWeather) {
                    worldObj.weatherIntensity = 0.0f;
                }
                return true;
            }
            return false;
        }
    }, new Command(new String[]{"give"}, "/give <id> <metadata?>"){

        @Override
        public boolean runCommand(Minecraft mc2, fd worldObj, gs player, String[] args) throws Exception {
            if (args.length > 3) {
                return false;
            }
            int meta = 0;
            if (args.length == 3) {
                meta = Integer.parseInt(args[2]);
            }
            int id2 = Integer.parseInt(args[1]);
            iz stack = new iz(gm.c[id2], gm.c[id2].bg, meta);
            player.c.a(stack);
            mc2.v.a("Giving " + stack.c() + " " + nh.a().b(stack.l()) + ".");
            return true;
        }
    }, new Command(new String[]{"clear"}, "/clear"){

        @Override
        public boolean runCommand(Minecraft mc2, fd worldObj, gs player, String[] args) throws Exception {
            int i;
            if (args.length != 1) {
                return false;
            }
            for (i = 0; i < player.c.a.length; ++i) {
                player.c.a[i] = null;
            }
            for (i = 0; i < player.c.b.length; ++i) {
                player.c.b[i] = null;
            }
            mc2.v.a("Cleared inventory.");
            return true;
        }
    }, new Command(new String[]{"gamemode"}, "/gamemode <value>"){

        @Override
        public boolean runCommand(Minecraft mc2, fd worldObj, gs player, String[] args) throws Exception {
            if (args.length != 2) {
                return false;
            }
            int id2 = Integer.parseInt(args[1]);
            player.setGamemode(Gamemode.gamemodesList[id2]);
            mc2.v.a("Set gamemode to " + nh.a().b(player.getGamemode().languageKey) + ".");
            return true;
        }
    }, new Command(new String[]{"summon"}, "/summon <name>"){

        @Override
        public boolean runCommand(Minecraft mc2, fd worldObj, gs player, String[] args) throws Exception {
            sn e2;
            if (args.length != 2) {
                return false;
            }
            ArrayList keys = new ArrayList(jc.a.keySet());
            for (int i = 0; i < keys.size(); ++i) {
                if (!((String)keys.get(i)).toLowerCase().equals(args[1].toLowerCase())) continue;
                args[1] = (String)keys.get(i);
                break;
            }
            if ((e2 = jc.a(args[1], worldObj)) != null) {
                e2.c(player.aM, player.aN, player.aO, 0.0f, 0.0f);
                worldObj.b(e2);
                for (int k = 0; k < 20; ++k) {
                    double d1 = player.aM + 0.5 + ((double)worldObj.r.nextFloat() - 0.5) * 2.0;
                    double d3 = player.aN + 0.5 + ((double)worldObj.r.nextFloat() - 0.5) * 2.0;
                    double d5 = player.aO + 0.5 + ((double)worldObj.r.nextFloat() - 0.5) * 2.0;
                    worldObj.a("smoke", d1, d3, d5, 0.0, 0.0, 0.0);
                    worldObj.a("flame", d1, d3, d5, 0.0, 0.0, 0.0);
                }
                mc2.v.a("Summoned " + args[1] + ".");
                return true;
            }
            return false;
        }
    }, new Command(new String[]{"seed"}, "/seed"){

        @Override
        public boolean runCommand(Minecraft mc2, fd worldObj, gs player, String[] args) throws Exception {
            mc2.v.a("Seed: " + worldObj.x.b() + " (copied to clipboard)");
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            clipboard.setContents(new StringSelection(String.valueOf(worldObj.x.b())), null);
            return true;
        }
    }};

    public Command(String[] triggers, String helpText) {
        this.triggers = triggers;
        this.helpText = helpText;
    }

    public abstract boolean runCommand(Minecraft var1, fd var2, gs var3, String[] var4) throws Exception;
}

