/*
 * Decompiled with CFR 0.152.
 */
import java.lang.reflect.Field;
import java.util.Set;
import java.util.logging.Logger;
import net.minecraft.server.MinecraftServer;
import net.minecraft.shared.Minecraft;

public class ConsoleCommandHandler {
    private static Logger minecraftLogger = Logger.getLogger("Minecraft");
    private MinecraftServer minecraftServer;

    public ConsoleCommandHandler(MinecraftServer minecraftserver) {
        this.minecraftServer = minecraftserver;
    }

    public void handleCommand(ServerCommand servercommand) {
        String s1;
        ICommandListener icommandlistener;
        String s2;
        block105: {
            String[] as;
            s2 = servercommand.command;
            icommandlistener = servercommand.commandListener;
            s1 = icommandlistener.getUsername();
            ServerConfigurationManager serverconfigurationmanager = this.minecraftServer.configManager;
            if (s2.toLowerCase().startsWith("help") || s2.toLowerCase().startsWith("?")) {
                this.printHelp(icommandlistener);
            } else if (s2.toLowerCase().startsWith("list")) {
                icommandlistener.log("Connected players: " + serverconfigurationmanager.getPlayerList());
            } else if (s2.toLowerCase().startsWith("stop")) {
                this.sendNoticeToOps(s1, "Stopping the server..");
                this.minecraftServer.initiateShutdown();
            } else if (s2.toLowerCase().startsWith("save-all")) {
                this.sendNoticeToOps(s1, "Forcing save..");
                if (serverconfigurationmanager != null) {
                    serverconfigurationmanager.savePlayerStates();
                }
                for (int i = 0; i < this.minecraftServer.worldMngr.length; ++i) {
                    WorldServer worldserver = this.minecraftServer.worldMngr[i];
                    worldserver.a(true, null);
                }
                this.sendNoticeToOps(s1, "Save complete.");
            } else if (s2.toLowerCase().startsWith("save-off")) {
                this.sendNoticeToOps(s1, "Disabling level saving..");
                for (int j = 0; j < this.minecraftServer.worldMngr.length; ++j) {
                    WorldServer worldserver1 = this.minecraftServer.worldMngr[j];
                    worldserver1.levelSaving = true;
                }
            } else if (s2.toLowerCase().startsWith("save-on")) {
                this.sendNoticeToOps(s1, "Enabling level saving..");
                for (int k = 0; k < this.minecraftServer.worldMngr.length; ++k) {
                    WorldServer worldserver2 = this.minecraftServer.worldMngr[k];
                    worldserver2.levelSaving = false;
                }
            } else if (s2.toLowerCase().startsWith("op ")) {
                String s22 = s2.substring(s2.indexOf(" ")).trim();
                serverconfigurationmanager.opPlayer(s22);
                this.sendNoticeToOps(s1, "Opping " + s22);
                serverconfigurationmanager.sendChatMessageToPlayer(s22, "\u00a7eYou are now op!");
            } else if (s2.toLowerCase().startsWith("deop ")) {
                String s3 = s2.substring(s2.indexOf(" ")).trim();
                serverconfigurationmanager.deopPlayer(s3);
                serverconfigurationmanager.sendChatMessageToPlayer(s3, "\u00a7eYou are no longer op!");
                this.sendNoticeToOps(s1, "De-opping " + s3);
            } else if (s2.toLowerCase().startsWith("ban-ip ")) {
                String s4 = s2.substring(s2.indexOf(" ")).trim();
                serverconfigurationmanager.banIP(s4);
                this.sendNoticeToOps(s1, "Banning ip " + s4);
            } else if (s2.toLowerCase().startsWith("pardon-ip ")) {
                String s5 = s2.substring(s2.indexOf(" ")).trim();
                serverconfigurationmanager.pardonIP(s5);
                this.sendNoticeToOps(s1, "Pardoning ip " + s5);
            } else if (s2.toLowerCase().startsWith("ban ")) {
                String s6 = s2.substring(s2.indexOf(" ")).trim();
                serverconfigurationmanager.banPlayer(s6);
                this.sendNoticeToOps(s1, "Banning " + s6);
                EntityPlayerMP entityplayermp = serverconfigurationmanager.getPlayerEntity(s6);
                if (entityplayermp != null) {
                    entityplayermp.playerNetServerHandler.kickPlayer("Banned by admin");
                }
            } else if (s2.toLowerCase().startsWith("pardon ")) {
                String s7 = s2.substring(s2.indexOf(" ")).trim();
                serverconfigurationmanager.pardonPlayer(s7);
                this.sendNoticeToOps(s1, "Pardoning " + s7);
            } else if (s2.toLowerCase().startsWith("kick ")) {
                String s8 = s2.substring(s2.indexOf(" ")).trim();
                EntityPlayerMP entityplayermp1 = null;
                for (int l = 0; l < serverconfigurationmanager.playerEntities.size(); ++l) {
                    EntityPlayerMP entityplayermp5 = (EntityPlayerMP)serverconfigurationmanager.playerEntities.get(l);
                    if (!entityplayermp5.l.equalsIgnoreCase(s8)) continue;
                    entityplayermp1 = entityplayermp5;
                }
                if (entityplayermp1 != null) {
                    entityplayermp1.playerNetServerHandler.kickPlayer("Kicked by admin");
                    this.sendNoticeToOps(s1, "Kicking " + entityplayermp1.l);
                } else {
                    icommandlistener.log("Can't find user " + s8 + ". No kick.");
                }
            } else if (s2.toLowerCase().startsWith("tp ")) {
                String[] as2 = s2.split(" ");
                if (as2.length == 3) {
                    EntityPlayerMP entityplayermp2 = serverconfigurationmanager.getPlayerEntity(as2[1]);
                    EntityPlayerMP entityplayermp3 = serverconfigurationmanager.getPlayerEntity(as2[2]);
                    if (entityplayermp2 == null) {
                        icommandlistener.log("Can't find user " + as2[1] + ". No tp.");
                    } else if (entityplayermp3 == null) {
                        icommandlistener.log("Can't find user " + as2[2] + ". No tp.");
                    } else if (entityplayermp2.m != entityplayermp3.m) {
                        icommandlistener.log("User " + as2[1] + " and " + as2[2] + " are in different dimensions. No tp.");
                    } else {
                        entityplayermp2.playerNetServerHandler.teleportTo(entityplayermp3.aM, entityplayermp3.aN, entityplayermp3.aO, entityplayermp3.aS, entityplayermp3.aT);
                        this.sendNoticeToOps(s1, "Teleporting " + as2[1] + " to " + as2[2] + ".");
                    }
                } else {
                    icommandlistener.log("Syntax error, please provice a source and a target.");
                }
            } else if (s2.toLowerCase().startsWith("give ")) {
                String[] as1 = s2.split(" ");
                if (as1.length != 3 && as1.length != 4) {
                    return;
                }
                String s9 = as1[1];
                EntityPlayerMP entityplayermp4 = serverconfigurationmanager.getPlayerEntity(s9);
                if (entityplayermp4 != null) {
                    try {
                        int j1 = Integer.parseInt(as1[2]);
                        if (gm.c[j1] != null) {
                            this.sendNoticeToOps(s1, "Giving " + entityplayermp4.l + " some " + j1);
                            int i2 = 1;
                            if (as1.length > 3) {
                                i2 = this.tryParse(as1[3], 1);
                            }
                            if (i2 < 1) {
                                i2 = 1;
                            }
                            if (i2 > 64) {
                                i2 = 64;
                            }
                            entityplayermp4.a(new iz(j1, i2, 0));
                            return;
                        }
                    }
                    catch (NumberFormatException j1) {
                        // empty catch block
                    }
                    Field[] fields = gm.class.getFields();
                    for (int q = 0; q < fields.length; ++q) {
                        try {
                            if (!fields[q].getName().equals(as1[2]) || !(fields[q].get(null) instanceof gm)) continue;
                            this.sendNoticeToOps(s1, "Giving " + entityplayermp4.l + " some " + as1[2]);
                            int i2 = 1;
                            if (as1.length > 3) {
                                i2 = this.tryParse(as1[3], 1);
                            }
                            if (i2 < 1) {
                                i2 = 1;
                            }
                            if (i2 > 64) {
                                i2 = 64;
                            }
                            try {
                                entityplayermp4.a(new iz(((gm)fields[q].get(null)).itemID, i2, 0));
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            return;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    icommandlistener.log("There's no item with id " + as1[2]);
                } else {
                    icommandlistener.log("Can't find user " + s9);
                }
            } else if (s2.toLowerCase().startsWith("time ")) {
                String[] as2 = s2.split(" ");
                if (as2.length != 3) {
                    return;
                }
                String s10 = as2[1];
                try {
                    int i1 = Integer.parseInt(as2[2]);
                    if ("add".equalsIgnoreCase(s10)) {
                        for (int k1 = 0; k1 < this.minecraftServer.worldMngr.length; ++k1) {
                            WorldServer worldserver3 = this.minecraftServer.worldMngr[k1];
                            worldserver3.setWorldTimeUpdateTicks(worldserver3.t() + (long)i1);
                        }
                        this.sendNoticeToOps(s1, "Added " + i1 + " to time");
                        break block105;
                    }
                    if ("set".equalsIgnoreCase(s10)) {
                        for (int l1 = 0; l1 < this.minecraftServer.worldMngr.length; ++l1) {
                            WorldServer worldserver4 = this.minecraftServer.worldMngr[l1];
                            worldserver4.setWorldTimeUpdateTicks(i1);
                        }
                        this.sendNoticeToOps(s1, "Set time to " + i1);
                        break block105;
                    }
                    icommandlistener.log("Unknown method, use either \"add\" or \"set\"");
                }
                catch (NumberFormatException numberformatexception) {
                    icommandlistener.log("Unable to convert time value, " + as2[2]);
                }
            } else if (s2.toLowerCase().startsWith("say ")) {
                s2 = s2.substring(s2.indexOf(" ")).trim();
                minecraftLogger.info("[" + s1 + "] " + s2);
                serverconfigurationmanager.sendPacketToAllPlayers((ki)new pe("\u00a7d[Server] " + s2));
            } else if (s2.toLowerCase().startsWith("tell ")) {
                String[] as3 = s2.split(" ");
                if (as3.length >= 3) {
                    s2 = s2.substring(s2.indexOf(" ")).trim();
                    s2 = s2.substring(s2.indexOf(" ")).trim();
                    minecraftLogger.info("[" + s1 + "->" + as3[1] + "] " + s2);
                    s2 = "\u00a77" + s1 + " whispers " + s2;
                    minecraftLogger.info(s2);
                    if (!serverconfigurationmanager.sendPacketToPlayer(as3[1], (ki)new pe(s2))) {
                        icommandlistener.log("There's no player by that name online.");
                    }
                }
            } else if (s2.toLowerCase().startsWith("whitelist ")) {
                this.handleWhitelist(s1, s2, icommandlistener);
            } else if (s2.startsWith("gamemode ")) {
                String[] as3 = s2.split(" ");
                if (as3.length == 3) {
                    int gamemodeId = -1;
                    try {
                        gamemodeId = Integer.parseInt(as3[2]);
                    }
                    catch (Exception e2) {
                        icommandlistener.log("Unknown or invalid gamemode ID.");
                    }
                    if (gamemodeId != -1) {
                        if (gamemodeId >= Gamemode.gamemodesList.length || Gamemode.gamemodesList[gamemodeId] == null) {
                            icommandlistener.log("Unknown or invalid gamemode ID.");
                        } else if (!serverconfigurationmanager.sendPacketToPlayer(as3[1], new Packet41EntityPlayerGamemode(gamemodeId))) {
                            icommandlistener.log("There's no player by that name online.");
                        } else {
                            EntityPlayerMP player = serverconfigurationmanager.getPlayerEntity(as3[1]);
                            player.setGamemode(Gamemode.gamemodesList[gamemodeId]);
                            this.sendNoticeToOps(s1, "Setting " + player.l + "'s gamemode to " + Gamemode.gamemodesList[gamemodeId].languageKey);
                        }
                    }
                }
            } else if (s2.startsWith("weather ") && (as = s2.split(" ")).length == 3) {
                int weatherId = -1;
                int dimId = -1;
                try {
                    dimId = Integer.parseInt(as[1]);
                    weatherId = Integer.parseInt(as[2]);
                }
                catch (Exception e3) {
                    icommandlistener.log("Unknown or invalid ID.");
                }
                if (weatherId != -1 && dimId != -1) {
                    if (dimId >= Dimension.dimensionList.length || Dimension.dimensionList[dimId] == null) {
                        icommandlistener.log("Unknown or invalid dimension ID.");
                    } else if (weatherId >= Weather.weatherList.length || Weather.weatherList[weatherId] == null) {
                        icommandlistener.log("Unknown or invalid weather ID.");
                    } else {
                        this.minecraftServer.worldMngr[dimId].newWeather = Weather.weatherList[weatherId];
                        this.minecraftServer.worldMngr[dimId].weatherDuration = Minecraft.DAY_LENGTH_TICKS;
                        if (this.minecraftServer.worldMngr[dimId].currentWeather == this.minecraftServer.worldMngr[dimId].dimension.worldType.defaultWeather) {
                            this.minecraftServer.worldMngr[dimId].weatherIntensity = 0.0f;
                        }
                    }
                }
            }
        }
        if (s2.toLowerCase().startsWith("setspawn ")) {
            String[] argument = s2.split(" ");
            if (argument.length == 4) {
                try {
                    int spawnX = Integer.parseInt(argument[1]);
                    int spawnY = Integer.parseInt(argument[2]);
                    int spawnZ = Integer.parseInt(argument[3]);
                    this.minecraftServer.worldMngr[0].a(new br(spawnX, spawnY, spawnZ));
                    this.sendNoticeToOps(s1, "Spawn Point set to X " + argument[1] + ", Y " + argument[2] + ", Z " + argument[3]);
                }
                catch (NumberFormatException nfe) {
                    icommandlistener.log("Could not perform command. Coordinates for spawn or dimension not given.");
                }
            } else {
                icommandlistener.log("Syntax error, please provide an X, Y and Z coordinate for spawn.");
            }
        } else {
            minecraftLogger.info("Unknown console command. Type \"help\" for help.");
        }
    }

    private void handleWhitelist(String s2, String s1, ICommandListener icommandlistener) {
        String[] as = s1.split(" ");
        if (as.length < 2) {
            return;
        }
        String s22 = as[1].toLowerCase();
        if ("on".equals(s22)) {
            this.sendNoticeToOps(s2, "Turned on white-listing");
            this.minecraftServer.propertyManagerObj.setProperty("white-list", true);
        } else if ("off".equals(s22)) {
            this.sendNoticeToOps(s2, "Turned off white-listing");
            this.minecraftServer.propertyManagerObj.setProperty("white-list", false);
        } else if ("list".equals(s22)) {
            Set set = this.minecraftServer.configManager.getWhiteListedIPs();
            String s5 = "";
            for (String s6 : set) {
                s5 = s5 + s6 + " ";
            }
            icommandlistener.log("White-listed players: " + s5);
        } else if ("add".equals(s22) && as.length == 3) {
            String s3 = as[2].toLowerCase();
            this.minecraftServer.configManager.addToWhiteList(s3);
            this.sendNoticeToOps(s2, "Added " + s3 + " to white-list");
        } else if ("remove".equals(s22) && as.length == 3) {
            String s4 = as[2].toLowerCase();
            this.minecraftServer.configManager.removeFromWhiteList(s4);
            this.sendNoticeToOps(s2, "Removed " + s4 + " from white-list");
        } else if ("reload".equals(s22)) {
            this.minecraftServer.configManager.reloadWhiteList();
            this.sendNoticeToOps(s2, "Reloaded white-list from file");
        }
    }

    private void printHelp(ICommandListener icommandlistener) {
        icommandlistener.log("To run the server without a gui, start it like this:");
        icommandlistener.log("   java -Xmx1024M -Xms1024M -jar minecraft_server.jar nogui");
        icommandlistener.log("Console commands:");
        icommandlistener.log("   help  or  ?               shows this message");
        icommandlistener.log("   kick <player>             removes a player from the server");
        icommandlistener.log("   ban <player>              bans a player from the server");
        icommandlistener.log("   pardon <player>           pardons a banned player so that they can connect again");
        icommandlistener.log("   ban-ip <ip>               bans an IP address from the server");
        icommandlistener.log("   pardon-ip <ip>            pardons a banned IP address so that they can connect again");
        icommandlistener.log("   op <player>               turns a player into an op");
        icommandlistener.log("   deop <player>             removes op status from a player");
        icommandlistener.log("   tp <player1> <player2>    moves one player to the same location as another player");
        icommandlistener.log("   give <player> <id> [num]  gives a player a resource");
        icommandlistener.log("   tell <player> <message>   sends a private message to a player");
        icommandlistener.log("   stop                      gracefully stops the server");
        icommandlistener.log("   save-all                  forces a server-wide level save");
        icommandlistener.log("   save-off                  disables terrain saving (useful for backup scripts)");
        icommandlistener.log("   save-on                   re-enables terrain saving");
        icommandlistener.log("   list                      lists all currently connected players");
        icommandlistener.log("   say <message>             broadcasts a message to all players");
        icommandlistener.log("   time <add|set> <amount>   adds to or sets the world time (0-24000)");
        icommandlistener.log("   gamemode <player> <id>   sets the target player's gamemode");
        icommandlistener.log("   setspawn <x> <y> <z>   sets the server spawn point to the given coordinates");
    }

    private void sendNoticeToOps(String s2, String s1) {
        String s22 = s2 + ": " + s1;
        this.minecraftServer.configManager.sendChatMessageToAllOps("\u00a77(" + s22 + ")");
        minecraftLogger.info(s22);
    }

    private int tryParse(String s2, int i) {
        try {
            return Integer.parseInt(s2);
        }
        catch (NumberFormatException numberformatexception) {
            return i;
        }
    }
}

