/*
 * Decompiled with CFR 0.152.
 */
public class Dimension {
    public int dimId;
    public String name;
    public Dimension homeDim;
    public WorldType worldType;
    public float worldScale;
    public int portalBlockId;
    public static final Dimension[] dimensionList = new Dimension[3];
    public static final Dimension overworld = new Dimension(0, "overworld", null, 1.0f, -1).setWorldType(WorldType.overworld);
    public static final Dimension hell = new Dimension(1, "hell", overworld, 0.125f, uu.portalNether.bn).setWorldType(WorldType.nether);
    public static final Dimension paradise = new Dimension(2, "paradise", overworld, 8.0f, uu.portalParadise.bn).setWorldType(WorldType.paradise);

    public Dimension(int dimId, String name, Dimension homeDim, float worldScale, int portalBlockId) {
        this.dimId = dimId;
        this.name = name;
        this.homeDim = homeDim;
        this.worldScale = worldScale;
        this.portalBlockId = portalBlockId;
        Dimension.dimensionList[dimId] = this;
    }

    public Dimension setWorldType(WorldType worldType) {
        this.worldType = worldType;
        return this;
    }

    public boolean canPortal(Dimension dim) {
        if (this.homeDim == null) {
            return true;
        }
        return dim == this.homeDim;
    }

    public static float getCoordScale(Dimension oldDim, Dimension newDim) {
        if (oldDim.homeDim == newDim) {
            return 1.0f / oldDim.worldScale;
        }
        if (newDim.homeDim == oldDim) {
            return newDim.worldScale;
        }
        return 1.0f;
    }

    public String getName() {
        return nh.a().b("dimension." + this.name);
    }
}

