/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.server.MinecraftServer;

public class EntityTracker {
    private Set trackedEntitySet = new HashSet();
    private jx trackedEntityHashTable = new jx();
    private MinecraftServer mcServer;
    private int maxTrackingDistanceThreshold;
    private int field_28113_e;

    public EntityTracker(MinecraftServer minecraftserver, int i) {
        this.mcServer = minecraftserver;
        this.field_28113_e = i;
        this.maxTrackingDistanceThreshold = minecraftserver.configManager.getMaxTrackingDistance();
    }

    public void trackEntity(sn entity) {
        if (entity instanceof EntityPlayerMP) {
            this.trackEntity(entity, 512, 2);
            EntityPlayerMP entityplayermp = (EntityPlayerMP)entity;
            for (EntityTrackerEntry entitytrackerentry : this.trackedEntitySet) {
                if (entitytrackerentry.trackedEntity == entityplayermp) continue;
                entitytrackerentry.updatePlayerEntity(entityplayermp);
            }
        } else if (entity instanceof lx) {
            this.trackEntity(entity, 64, 5, true);
        } else if (entity instanceof sl) {
            this.trackEntity(entity, 64, 20, false);
        } else if (entity instanceof EntityCannonball) {
            this.trackEntity(entity, 64, 10, false);
        } else if (entity instanceof cf) {
            this.trackEntity(entity, 64, 10, false);
        } else if (entity instanceof by) {
            this.trackEntity(entity, 64, 10, true);
        } else if (entity instanceof vv) {
            this.trackEntity(entity, 64, 10, true);
        } else if (entity instanceof EntityPebble) {
            this.trackEntity(entity, 64, 10, true);
        }
        if (entity instanceof hl) {
            this.trackEntity(entity, 64, 20, true);
        } else if (entity instanceof yl) {
            this.trackEntity(entity, 160, 5, true);
        } else if (entity instanceof fz) {
            this.trackEntity(entity, 160, 5, true);
        } else if (entity instanceof xt) {
            this.trackEntity(entity, 160, 3, true);
        } else if (entity instanceof IAnimals) {
            this.trackEntity(entity, 160, 3);
        } else if (entity instanceof qw) {
            this.trackEntity(entity, 160, 10, true);
        } else if (entity instanceof ju) {
            this.trackEntity(entity, 160, 20, true);
        } else if (entity instanceof qv) {
            this.trackEntity(entity, 160, Integer.MAX_VALUE, false);
        }
    }

    public void trackEntity(sn entity, int i, int j) {
        this.trackEntity(entity, i, j, false);
    }

    public void trackEntity(sn entity, int i, int j, boolean flag) {
        if (i > this.maxTrackingDistanceThreshold) {
            i = this.maxTrackingDistanceThreshold;
        }
        if (this.trackedEntityHashTable.containsItem(entity.aD)) {
            throw new IllegalStateException("Entity is already tracked!");
        }
        EntityTrackerEntry entitytrackerentry = new EntityTrackerEntry(entity, i, j, flag);
        this.trackedEntitySet.add(entitytrackerentry);
        this.trackedEntityHashTable.a(entity.aD, entitytrackerentry);
        entitytrackerentry.updatePlayerEntities(this.mcServer.getWorldManager((int)this.field_28113_e).d);
    }

    public void untrackEntity(sn entity) {
        EntityTrackerEntry entitytrackerentry;
        if (entity instanceof EntityPlayerMP) {
            EntityPlayerMP entityplayermp = (EntityPlayerMP)entity;
            for (EntityTrackerEntry entitytrackerentry1 : this.trackedEntitySet) {
                entitytrackerentry1.removeFromTrackedPlayers(entityplayermp);
            }
        }
        if ((entitytrackerentry = (EntityTrackerEntry)this.trackedEntityHashTable.b(entity.aD)) != null) {
            this.trackedEntitySet.remove(entitytrackerentry);
            entitytrackerentry.sendDestroyEntityPacketToTrackedPlayers();
        }
    }

    public void updateTrackedEntities() {
        ArrayList<EntityPlayerMP> arraylist = new ArrayList<EntityPlayerMP>();
        for (EntityTrackerEntry entitytrackerentry : this.trackedEntitySet) {
            entitytrackerentry.updatePlayerList(this.mcServer.getWorldManager((int)this.field_28113_e).d);
            if (!entitytrackerentry.playerEntitiesUpdated || !(entitytrackerentry.trackedEntity instanceof EntityPlayerMP)) continue;
            arraylist.add((EntityPlayerMP)entitytrackerentry.trackedEntity);
        }
        for (int i = 0; i < arraylist.size(); ++i) {
            EntityPlayerMP entityplayermp = (EntityPlayerMP)arraylist.get(i);
            for (EntityTrackerEntry entitytrackerentry1 : this.trackedEntitySet) {
                if (entitytrackerentry1.trackedEntity == entityplayermp) continue;
                entitytrackerentry1.updatePlayerEntity(entityplayermp);
            }
        }
    }

    public void sendPacketToTrackedPlayers(sn entity, ki packet) {
        EntityTrackerEntry entitytrackerentry = (EntityTrackerEntry)this.trackedEntityHashTable.a(entity.aD);
        if (entitytrackerentry != null) {
            entitytrackerentry.sendPacketToTrackedPlayers(packet);
        }
    }

    public void sendPacketToTrackedPlayersAndTrackedEntity(sn entity, ki packet) {
        EntityTrackerEntry entitytrackerentry = (EntityTrackerEntry)this.trackedEntityHashTable.a(entity.aD);
        if (entitytrackerentry != null) {
            entitytrackerentry.sendPacketToTrackedPlayersAndTrackedEntity(packet);
        }
    }

    public void removeTrackedPlayerSymmetric(EntityPlayerMP entityplayermp) {
        for (EntityTrackerEntry entitytrackerentry : this.trackedEntitySet) {
            entitytrackerentry.removeTrackedPlayerSymmetric(entityplayermp);
        }
    }
}

