/*
 * Decompiled with CFR 0.152.
 */
import net.minecraft.client.Minecraft;
import org.lwjgl.opengl.GL11;

public class GuiGuidebookRecipe
extends ub {
    private static bb itemRenderer = new bb();
    protected dt recipe = null;
    protected int furnaceType;
    protected int recipeId;
    protected int xPosition;
    protected int yPosition;
    protected int width = 98;
    protected int height = 54;
    protected Minecraft mc;

    public GuiGuidebookRecipe(Minecraft mc2, int x, int y, int furnaceType, int recipeId) {
        this.xPosition = x;
        this.yPosition = y;
        this.furnaceType = furnaceType;
        this.recipeId = recipeId;
    }

    public GuiGuidebookRecipe(Minecraft mc2, int x, int y, dt recipe) throws IllegalArgumentException {
        this.xPosition = x;
        this.yPosition = y;
        this.recipe = recipe;
        if (!(recipe instanceof RecipeShaped) && !(recipe instanceof RecipeShapeless)) {
            throw new IllegalArgumentException();
        }
    }

    public void draw(Minecraft minecraft) {
        GL11.glBindTexture((int)3553, (int)minecraft.p.b("/gui/guidebook.png"));
        this.b(this.xPosition, this.yPosition, 158, this.getRecipeImageYCoord(), 98, 54);
        GL11.glPushMatrix();
        GL11.glRotatef((float)120.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        u.b();
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)32826);
        this.mc = minecraft;
        for (int i2 = 0; i2 < this.slotCount(); ++i2) {
            int[] coords = this.getSlotCoords(i2);
            this.drawItemInSlot(coords[0], coords[1], this.getStackInSlot(i2));
        }
        GL11.glDisable((int)32826);
        u.a();
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2929);
    }

    private void drawItemInSlot(int x, int y, iz stack) {
        if (stack == null) {
            return;
        }
        boolean seen = this.mc.h.getGamemode() == Gamemode.creative || this.hasSeenItemWithId(stack.c);
        itemRenderer.drawItemIntoGui(this.mc.q, this.mc.p, stack.c, stack.i(), stack.b(), this.xPosition + x, this.yPosition + y, seen ? 1.0f : 0.0f, 1.0f);
        if (!seen) {
            String s2 = "?";
            GL11.glDisable((int)2896);
            GL11.glDisable((int)2929);
            this.mc.q.a("?", this.xPosition + (x + 19) - 2 - this.mc.q.a("?"), this.yPosition + y + 6 + 3, 0xFFFFFF);
            GL11.glEnable((int)2896);
            GL11.glEnable((int)2929);
        } else {
            itemRenderer.renderItemOverlayIntoGUI(this.mc.q, this.mc.p, stack, this.xPosition + x, this.yPosition + y, 1.0f);
        }
    }

    public boolean getIsMouseOverSlot(int slot, int mouseX, int mouseY) {
        int[] coords = this.getSlotCoords(slot);
        return mouseX >= coords[0] - 1 && mouseX < coords[0] + 16 + 1 && mouseY >= coords[1] - 1 && mouseY < coords[1] + 16 + 1;
    }

    protected int getRecipeImageYCoord() {
        return this.getRecipeType() * 54;
    }

    protected int getRecipeType() {
        if (this.recipe != null) {
            if (this.recipe instanceof RecipeShaped) {
                RecipeShaped r = (RecipeShaped)this.recipe;
                if (r.recipeHeight > 2 || r.recipeWidth > 2) {
                    return 1;
                }
                return 0;
            }
            if (this.recipe instanceof RecipeShapeless) {
                RecipeShapeless r = (RecipeShapeless)this.recipe;
                if (r.recipeItems.size() > 4) {
                    return 1;
                }
                return 0;
            }
        } else {
            if (this.furnaceType == 0) {
                return 2;
            }
            if (this.furnaceType == 1) {
                return 3;
            }
            return 2;
        }
        return 0;
    }

    public int[] getSlotCoords(int slot) {
        int recipeType = this.getRecipeType();
        if (recipeType == 0) {
            if (slot < 4) {
                return new int[]{13 + 18 * (slot % 2), 10 + 18 * (slot / 2)};
            }
            return new int[]{69, 20};
        }
        if (recipeType == 1) {
            if (slot < 9) {
                return new int[]{1 + 18 * (slot % 3), 1 + 18 * (slot / 3)};
            }
            return new int[]{81, 19};
        }
        if (recipeType == 2 || recipeType == 3) {
            if (slot == 0) {
                return new int[]{9, 10};
            }
            return new int[]{69, 19};
        }
        return new int[]{0, 0};
    }

    public iz getStackInSlot(int slot) {
        int recipeType = this.getRecipeType();
        if (recipeType == 0) {
            if (this.recipe instanceof RecipeShaped) {
                RecipeShaped r = (RecipeShaped)this.recipe;
                if (slot == this.slotCount() - 1) {
                    return r.recipeOutput;
                }
                int slotX = slot % 2;
                int slotY = slot / 2;
                if (slotX >= r.recipeWidth || slotY >= r.recipeHeight) {
                    return null;
                }
                return r.recipeItems[slotX + slotY * r.recipeWidth];
            }
            if (this.recipe instanceof RecipeShapeless) {
                RecipeShapeless r = (RecipeShapeless)this.recipe;
                if (slot == this.slotCount() - 1) {
                    return r.recipeOutput;
                }
                if (slot >= r.recipeItems.size()) {
                    return null;
                }
                return (iz)r.recipeItems.get(slot);
            }
        } else if (recipeType == 1) {
            if (this.recipe instanceof RecipeShaped) {
                RecipeShaped r = (RecipeShaped)this.recipe;
                if (slot == this.slotCount() - 1) {
                    return r.recipeOutput;
                }
                int slotX = slot % 3;
                int slotY = slot / 3;
                if (slotX >= r.recipeWidth || slotY >= r.recipeHeight) {
                    return null;
                }
                return r.recipeItems[slotX + slotY * r.recipeWidth];
            }
            if (this.recipe instanceof RecipeShapeless) {
                RecipeShapeless r = (RecipeShapeless)this.recipe;
                if (slot == this.slotCount() - 1) {
                    return r.recipeOutput;
                }
                if (slot > r.recipeItems.size()) {
                    return null;
                }
                return (iz)r.recipeItems.get(slot);
            }
        } else {
            if (recipeType == 2) {
                iz input = new iz(this.recipeId, 1, 0);
                iz output = RecipesFurnace.smelting().getSmeltingResult(this.recipeId);
                if (slot == 0) {
                    return input;
                }
                return output;
            }
            if (recipeType == 3) {
                iz input = new iz(this.recipeId, 1, 0);
                iz output = RecipesBlastFurnace.smelting().getSmeltingResult(this.recipeId);
                if (slot == 0) {
                    return input;
                }
                return output;
            }
        }
        return null;
    }

    public boolean hasSeenItemWithId(int id2) {
        if (id2 >= uu.m.length) {
            return this.mc.I.readStat(jl.craftedItemStats[id2]) > 0 || this.mc.I.readStat(jl.pickUpItemStats[id2]) > 0;
        }
        return this.mc.I.readStat(jl.craftedItemStats[id2]) > 0 || this.mc.I.readStat(jl.C[id2]) > 0 || this.mc.I.readStat(jl.pickUpItemStats[id2]) > 0;
    }

    public int slotCount() {
        int recipeType = this.getRecipeType();
        if (recipeType == 0) {
            return 5;
        }
        if (recipeType == 1) {
            return 10;
        }
        if (recipeType == 2 || recipeType == 3) {
            return 2;
        }
        return 0;
    }
}

