/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JComponent;
import javax.swing.Timer;

public class GuiStatsComponent
extends JComponent {
    private int[] memoryUse = new int[256];
    private int updateCounter = 0;
    private String[] displayStrings = new String[10];

    public GuiStatsComponent() {
        this.setPreferredSize(new Dimension(256, 196));
        this.setMinimumSize(new Dimension(256, 196));
        this.setMaximumSize(new Dimension(256, 196));
        new Timer(500, new GuiStatsListener(this)).start();
        this.setBackground(Color.BLACK);
    }

    private void updateStats() {
        long l = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
        System.gc();
        this.displayStrings[0] = "Memory use: " + l / 1024L / 1024L + " mb (" + Runtime.getRuntime().freeMemory() * 100L / Runtime.getRuntime().maxMemory() + "% free)";
        this.displayStrings[1] = "Threads: " + pf.b + " + " + pf.c;
        this.memoryUse[this.updateCounter++ & 0xFF] = (int)(l * 100L / Runtime.getRuntime().maxMemory());
        this.repaint();
    }

    @Override
    public void paint(Graphics g2) {
        g2.setColor(new Color(0xFFFFFF));
        g2.fillRect(0, 0, 256, 192);
        for (int i2 = 0; i2 < 256; ++i2) {
            int k = this.memoryUse[i2 + this.updateCounter & 0xFF];
            g2.setColor(new Color(k + 28 << 16));
            g2.fillRect(i2, 100 - k, 1, k);
        }
        g2.setColor(Color.BLACK);
        for (int j = 0; j < this.displayStrings.length; ++j) {
            String s2 = this.displayStrings[j];
            if (s2 == null) continue;
            g2.drawString(s2, 32, 116 + j * 16);
        }
    }

    static void update(GuiStatsComponent guistatscomponent) {
        guistatscomponent.updateStats();
    }
}

