/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.List;
import net.minecraft.shared.Minecraft;

class PlayerInstance {
    private List players;
    private int chunkX;
    private int chunkZ;
    private yy currentChunk;
    private short[] blocksToUpdate;
    private int numBlocksToUpdate;
    private int minX;
    private int maxX;
    private int minY;
    private int maxY;
    private int minZ;
    private int maxZ;
    final PlayerManager playerManager;

    public PlayerInstance(PlayerManager playermanager, int i2, int j) {
        this.playerManager = playermanager;
        this.players = new ArrayList();
        this.blocksToUpdate = new short[10];
        this.numBlocksToUpdate = 0;
        this.chunkX = i2;
        this.chunkZ = j;
        this.currentChunk = new yy(i2, j);
        playermanager.getMinecraftServer().chunkProviderServer.c(i2, j);
    }

    public void addPlayer(EntityPlayerMP entityplayermp) {
        if (this.players.contains(entityplayermp)) {
            throw new IllegalStateException("Failed to add player. " + entityplayermp + " already is in chunk " + this.chunkX + ", " + this.chunkZ);
        }
        entityplayermp.field_420_ah.add(this.currentChunk);
        entityplayermp.playerNetServerHandler.sendPacket(new se(this.currentChunk.a, this.currentChunk.b, true));
        this.players.add(entityplayermp);
        entityplayermp.loadedChunks.add(this.currentChunk);
    }

    public void removePlayer(EntityPlayerMP entityplayermp) {
        if (!this.players.contains(entityplayermp)) {
            return;
        }
        this.players.remove(entityplayermp);
        if (this.players.size() == 0) {
            long l = (long)this.chunkX + Integer.MAX_VALUE | (long)this.chunkZ + Integer.MAX_VALUE << 32;
            PlayerManager.getPlayerInstances(this.playerManager).remove(l);
            if (this.numBlocksToUpdate > 0) {
                PlayerManager.getPlayerInstancesToUpdate(this.playerManager).remove(this);
            }
            this.playerManager.getMinecraftServer().chunkProviderServer.func_35391_d(this.chunkX, this.chunkZ);
        }
        entityplayermp.loadedChunks.remove(this.currentChunk);
        if (entityplayermp.field_420_ah.contains(this.currentChunk)) {
            entityplayermp.playerNetServerHandler.sendPacket(new se(this.chunkX, this.chunkZ, false));
        }
    }

    public void markBlockNeedsUpdate(int i2, int j, int k) {
        if (this.numBlocksToUpdate == 0) {
            PlayerManager.getPlayerInstancesToUpdate(this.playerManager).add(this);
            this.minX = this.maxX = i2;
            this.minY = this.maxY = j;
            this.minZ = this.maxZ = k;
        }
        if (this.minX > i2) {
            this.minX = i2;
        }
        if (this.maxX < i2) {
            this.maxX = i2;
        }
        if (this.minY > j) {
            this.minY = j;
        }
        if (this.maxY < j) {
            this.maxY = j;
        }
        if (this.minZ > k) {
            this.minZ = k;
        }
        if (this.maxZ < k) {
            this.maxZ = k;
        }
        if (this.numBlocksToUpdate < 10) {
            short word0 = (short)(i2 << Minecraft.WORLD_HEIGHT_BITS + 4 | k << Minecraft.WORLD_HEIGHT_BITS | j);
            for (int l = 0; l < this.numBlocksToUpdate; ++l) {
                if (this.blocksToUpdate[l] != word0) continue;
                return;
            }
            this.blocksToUpdate[this.numBlocksToUpdate++] = word0;
        }
    }

    public void sendPacketToPlayersInInstance(ki packet) {
        for (int i2 = 0; i2 < this.players.size(); ++i2) {
            EntityPlayerMP entityplayermp = (EntityPlayerMP)this.players.get(i2);
            if (!entityplayermp.field_420_ah.contains(this.currentChunk)) continue;
            entityplayermp.playerNetServerHandler.sendPacket(packet);
        }
    }

    protected boolean anyFlyingPlayersInInstance() {
        boolean any = false;
        for (int i2 = 0; i2 < this.players.size(); ++i2) {
            if (!((EntityPlayerMP)this.players.get((int)i2)).gamemode.canPlayerFly) continue;
            any = true;
            break;
        }
        return any;
    }

    public void onUpdate() {
        WorldServer worldserver = this.playerManager.getMinecraftServer();
        if (this.numBlocksToUpdate == 0) {
            return;
        }
        if (this.numBlocksToUpdate == 1) {
            int i2 = this.chunkX * 16 + this.minX;
            int l = this.minY;
            int k1 = this.chunkZ * 16 + this.minZ;
            this.sendPacketToPlayersInInstance(new tv(i2, l, k1, worldserver));
            if (uu.p[worldserver.a(i2, l, k1)]) {
                this.updateTileEntity(worldserver.b(i2, l, k1));
            }
        } else if (this.numBlocksToUpdate >= 10) {
            this.minY = this.minY / 2 * 2;
            this.maxY = (this.maxY / 2 + 1) * 2;
            int minWorldX = this.minX + this.chunkX * 16;
            int minWorldY = this.minY;
            int minWorldZ = this.minZ + this.chunkZ * 16;
            int width = this.maxX - this.minX + 1;
            int height = this.maxY - this.minY + 2;
            int length = this.maxZ - this.minZ + 1;
            if (this.anyFlyingPlayersInInstance()) {
                minWorldX = this.chunkX * 16;
                minWorldY = 0;
                minWorldZ = this.chunkZ * 16;
                width = 16;
                height = Minecraft.WORLD_HEIGHT_BLOCKS;
                length = 16;
            }
            this.sendPacketToPlayersInInstance(new ef(minWorldX, minWorldY, minWorldZ, width, height, length, worldserver));
            List list = worldserver.getTileEntityList(minWorldX, minWorldY, minWorldZ, minWorldX + width, minWorldY + height, minWorldZ + length);
            for (int j3 = 0; j3 < list.size(); ++j3) {
                this.updateTileEntity((ow)list.get(j3));
            }
        } else {
            this.sendPacketToPlayersInInstance(new wu(this.chunkX, this.chunkZ, this.blocksToUpdate, this.numBlocksToUpdate, worldserver));
            for (int k = 0; k < this.numBlocksToUpdate; ++k) {
                int x = this.chunkX * 16 + (this.blocksToUpdate[k] >> 12 & 0xF);
                int y = this.blocksToUpdate[k] & 0xFF;
                int z2 = this.chunkZ * 16 + (this.blocksToUpdate[k] >> 8 & 0xF);
                if (!uu.p[worldserver.a(x, y, z2)]) continue;
                this.updateTileEntity(worldserver.b(x, y, z2));
            }
        }
        this.numBlocksToUpdate = 0;
    }

    private void updateTileEntity(ow tileentity) {
        ki packet;
        if (tileentity != null && (packet = tileentity.getDescriptionPacket()) != null) {
            this.sendPacketToPlayersInInstance(packet);
        }
    }
}

