/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.shared.Minecraft;
import net.minecraft.src.Weather;

public class Season {
    public String languageKey = "";
    public int lengthTicks = 0;
    public List<Weather> allowedWeathers = new ArrayList<Weather>();
    public Map<Weather, Float> weatherProbability = new HashMap<Weather, Float>();
    public boolean hasFallingLeaves = false;
    public boolean hasDeeperSnow = false;
    public boolean letWeatherCleanUpSnow = true;
    public boolean killFlowers = false;
    public boolean growFlowers = false;
    public float dayLength = 0.5f;
    public float cropGrowthFactor = 1.0f;
    public float mobSpawnRateModifier = 1.0f;
    public static Season[] seasonsList = new Season[16];
    public static Season surfaceSpring = new SeasonSpring(0).setLanguageKey("surfacespring").setLengthTicks(Minecraft.DAY_LENGTH_TICKS * 7).allowWeather(Weather.weatherRain, 0.3f).allowWeather(Weather.weatherFog, 0.3f).setDayLength(0.5f).setCropGrowthFactor(1.5f).setGrowFlowers();
    public static Season surfaceSummer = new SeasonSummer(1).setLanguageKey("surfacesummer").setLengthTicks(Minecraft.DAY_LENGTH_TICKS * 7).allowWeather(Weather.weatherRain, 0.1f).allowWeather(Weather.weatherStorm, 0.1f).setDayLength(0.6f);
    public static Season surfaceFall = new SeasonFall(2).setLanguageKey("surfacefall").setLengthTicks(Minecraft.DAY_LENGTH_TICKS * 7).allowWeather(Weather.weatherRain, 0.2f).allowWeather(Weather.weatherStorm, 0.05f).allowWeather(Weather.weatherFog, 0.5f).setDayLength(0.5f);
    public static Season surfaceWinter = new SeasonWinter(3).setLanguageKey("surfacewinter").setLengthTicks(Minecraft.DAY_LENGTH_TICKS * 7).allowWeather(Weather.weatherSnow, 0.5f).allowWeather(Weather.weatherFog, 0.25f).setLetWeatherCleanUpSnow(false).setDayLength(0.3f).setCropGrowthFactor(0.25f).setKillFlowers();
    public static Season surfaceHell = new SeasonOverworldHell(4).setLanguageKey("surfacehell").setLengthTicks(Minecraft.DAY_LENGTH_TICKS);

    public Season(int id2) {
        Season.seasonsList[id2] = this;
    }

    public Season(int id2, boolean hasFallingLeaves, boolean hasDeeperSnow) {
        this(id2);
        this.hasFallingLeaves = hasFallingLeaves;
        this.hasDeeperSnow = hasDeeperSnow;
    }

    public Season setLanguageKey(String name) {
        this.languageKey = name;
        return this;
    }

    public String getName() {
        return nh.a().b("season." + this.languageKey);
    }

    public Season setLengthTicks(int lengthTicks) {
        this.lengthTicks = lengthTicks;
        return this;
    }

    public Season allowWeather(Weather weather, float probability) {
        this.allowedWeathers.add((Weather)weather);
        this.weatherProbability.put((Weather)weather, Float.valueOf(probability));
        return this;
    }

    public Season setLetWeatherCleanUpSnow(boolean value) {
        this.letWeatherCleanUpSnow = value;
        return this;
    }

    public Season setDayLength(float length) {
        this.dayLength = length;
        return this;
    }

    public Season setCropGrowthFactor(float cropGrowthFactor) {
        this.cropGrowthFactor = cropGrowthFactor;
        return this;
    }

    public Season setKillFlowers() {
        this.killFlowers = true;
        return this;
    }

    public Season setGrowFlowers() {
        this.growFlowers = true;
        return this;
    }

    protected int getPeakGrassColorizer(int color) {
        return color;
    }

    protected int getPeakFoliageColorizer(int color) {
        return color;
    }

    public int modifyGrassColorizer(int color, Season otherSeason, float blendAmount) {
        int myColor = this.getPeakGrassColorizer(color);
        int otherColor = otherSeason.getPeakGrassColorizer(color);
        return Season.blendColors(myColor, otherColor, blendAmount);
    }

    public int modifyFoliageColorizer(int color, Season otherSeason, float blendAmount) {
        int myColor = this.getPeakFoliageColorizer(color);
        int otherColor = otherSeason.getPeakFoliageColorizer(color);
        return Season.blendColors(myColor, otherColor, blendAmount);
    }

    public static int blendColors(int colorA, int colorB, float blendAmount) {
        int rA = colorA >> 16 & 0xFF;
        int gA = colorA >> 8 & 0xFF;
        int bA = colorA >> 0 & 0xFF;
        int rB = colorB >> 16 & 0xFF;
        int gB = colorB >> 8 & 0xFF;
        int bB = colorB >> 0 & 0xFF;
        int dr2 = rB - rA;
        int dg2 = gB - gA;
        int db2 = bB - bA;
        int r = rA + (int)((float)dr2 * blendAmount);
        int g2 = gA + (int)((float)dg2 * blendAmount);
        int b = bA + (int)((float)db2 * blendAmount);
        return r << 16 | g2 << 8 | b << 0;
    }
}

