/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.logging.Logger;
import net.minecraft.server.MinecraftServer;

public class ServerConfigurationManager {
    public static Logger logger = Logger.getLogger("Minecraft");
    public List playerEntities = new ArrayList();
    private MinecraftServer mcServer;
    private PlayerManager[] playerManagerObj;
    private int maxPlayers;
    private Set bannedPlayers = new HashSet();
    private Set bannedIPs = new HashSet();
    private Set ops = new HashSet();
    private Set whiteListedIPs = new HashSet();
    private File bannedPlayersFile;
    private File ipBanFile;
    private File opFile;
    private File whitelistPlayersFile;
    private IPlayerFileData playerNBTManagerObj;
    private boolean whiteListEnforced;

    public ServerConfigurationManager(MinecraftServer minecraftserver) {
        this.playerManagerObj = new PlayerManager[Dimension.dimensionList.length];
        this.mcServer = minecraftserver;
        this.bannedPlayersFile = minecraftserver.getFile("banned-players.txt");
        this.ipBanFile = minecraftserver.getFile("banned-ips.txt");
        this.opFile = minecraftserver.getFile("ops.txt");
        this.whitelistPlayersFile = minecraftserver.getFile("white-list.txt");
        int i2 = minecraftserver.propertyManagerObj.getIntProperty("view-distance", 10);
        for (int q = 0; q < Dimension.dimensionList.length; ++q) {
            this.playerManagerObj[q] = new PlayerManager(minecraftserver, q, i2);
        }
        this.maxPlayers = minecraftserver.propertyManagerObj.getIntProperty("max-players", 20);
        this.whiteListEnforced = minecraftserver.propertyManagerObj.getBooleanProperty("white-list", false);
        this.readBannedPlayers();
        this.loadBannedList();
        this.loadOps();
        this.loadWhiteList();
        this.writeBannedPlayers();
        this.saveBannedList();
        this.saveOps();
        this.saveWhiteList();
    }

    public void setPlayerManager(WorldServer[] aworldserver) {
        this.playerNBTManagerObj = aworldserver[0].getSaveHandler().func_22090_d();
    }

    public void func_28172_a(EntityPlayerMP entityplayermp) {
        this.playerManagerObj[0].removePlayer(entityplayermp);
        this.playerManagerObj[1].removePlayer(entityplayermp);
        this.getPlayerManager(entityplayermp.m).addPlayer(entityplayermp);
        WorldServer worldserver = this.mcServer.getWorldManager(entityplayermp.m);
        worldserver.chunkProviderServer.c((int)entityplayermp.aM >> 4, (int)entityplayermp.aO >> 4);
    }

    public int getMaxTrackingDistance() {
        return this.playerManagerObj[0].getMaxTrackingDistance();
    }

    private PlayerManager getPlayerManager(int i2) {
        return this.playerManagerObj[i2];
    }

    public void readPlayerDataFromFile(EntityPlayerMP entityplayermp) {
        this.playerNBTManagerObj.readPlayerData(entityplayermp);
    }

    public void playerLoggedIn(EntityPlayerMP entityplayermp) {
        this.playerEntities.add(entityplayermp);
        WorldServer worldserver = this.mcServer.getWorldManager(entityplayermp.m);
        worldserver.chunkProviderServer.c((int)entityplayermp.aM >> 4, (int)entityplayermp.aO >> 4);
        while (worldserver.a((sn)entityplayermp, entityplayermp.aW).size() != 0) {
            entityplayermp.e(entityplayermp.aM, entityplayermp.aN + 1.0, entityplayermp.aO);
        }
        worldserver.b(entityplayermp);
        this.getPlayerManager(entityplayermp.m).addPlayer(entityplayermp);
    }

    public void func_613_b(EntityPlayerMP entityplayermp) {
        this.getPlayerManager(entityplayermp.m).func_543_c(entityplayermp);
    }

    public void playerLoggedOut(EntityPlayerMP entityplayermp) {
        this.playerNBTManagerObj.writePlayerData(entityplayermp);
        this.mcServer.getWorldManager(entityplayermp.m).e(entityplayermp);
        this.playerEntities.remove(entityplayermp);
        this.getPlayerManager(entityplayermp.m).removePlayer(entityplayermp);
    }

    public EntityPlayerMP login(NetLoginHandler netloginhandler, String s2) {
        if (this.bannedPlayers.contains(s2.trim().toLowerCase())) {
            netloginhandler.kickUser("You are banned from this server!");
            return null;
        }
        if (!this.isAllowedToLogin(s2)) {
            netloginhandler.kickUser("You are not white-listed on this server!");
            return null;
        }
        String s1 = netloginhandler.netManager.getRemoteAddress().toString();
        s1 = s1.substring(s1.indexOf("/") + 1);
        if (this.bannedIPs.contains(s1 = s1.substring(0, s1.indexOf(":")))) {
            netloginhandler.kickUser("Your IP address is banned from this server!");
            return null;
        }
        if (this.playerEntities.size() >= this.maxPlayers) {
            netloginhandler.kickUser("The server is full!");
            return null;
        }
        for (int i2 = 0; i2 < this.playerEntities.size(); ++i2) {
            EntityPlayerMP entityplayermp = (EntityPlayerMP)this.playerEntities.get(i2);
            if (!entityplayermp.l.equalsIgnoreCase(s2)) continue;
            entityplayermp.playerNetServerHandler.kickPlayer("You logged in from another location");
        }
        return new EntityPlayerMP(this.mcServer, this.mcServer.getWorldManager(0), s2, new ItemInWorldManager(this.mcServer.getWorldManager(0)));
    }

    public EntityPlayerMP recreatePlayerEntity(EntityPlayerMP entityplayermp, int i2) {
        this.mcServer.getEntityTracker(entityplayermp.m).removeTrackedPlayerSymmetric(entityplayermp);
        this.mcServer.getEntityTracker(entityplayermp.m).untrackEntity(entityplayermp);
        this.getPlayerManager(entityplayermp.m).removePlayer(entityplayermp);
        this.playerEntities.remove(entityplayermp);
        this.mcServer.getWorldManager(entityplayermp.m).removePlayer(entityplayermp);
        br chunkcoordinates = entityplayermp.Q();
        entityplayermp.m = i2;
        EntityPlayerMP entityplayermp1 = new EntityPlayerMP(this.mcServer, this.mcServer.getWorldManager(entityplayermp.m), entityplayermp.l, new ItemInWorldManager(this.mcServer.getWorldManager(entityplayermp.m)));
        entityplayermp1.aD = entityplayermp.aD;
        entityplayermp1.chatColour = entityplayermp.chatColour;
        entityplayermp1.playerNetServerHandler = entityplayermp.playerNetServerHandler;
        WorldServer worldserver = this.mcServer.getWorldManager(entityplayermp.m);
        Random rand = new Random();
        if (chunkcoordinates != null) {
            br chunkcoordinates1 = gs.a(this.mcServer.getWorldManager(entityplayermp.m), chunkcoordinates);
            if (chunkcoordinates1 != null) {
                entityplayermp1.c((float)chunkcoordinates1.a + 0.5f, (float)chunkcoordinates1.b + 0.1f, (float)chunkcoordinates1.c + 0.5f, 0.0f, 0.0f);
                entityplayermp1.a(chunkcoordinates);
            } else {
                entityplayermp1.playerNetServerHandler.sendPacket(new ca(0));
            }
        }
        worldserver.chunkProviderServer.c((int)entityplayermp1.aM >> 4, (int)entityplayermp1.aO >> 4);
        while (worldserver.a((sn)entityplayermp1, entityplayermp1.aW).size() != 0) {
            entityplayermp1.e(entityplayermp1.aM, entityplayermp1.aN + 1.0, entityplayermp1.aO);
        }
        entityplayermp1.playerNetServerHandler.sendPacket(new ox((byte)entityplayermp1.m));
        this.mcServer.configManager.sendPacketToPlayer(entityplayermp1.l, new Packet41EntityPlayerGamemode(entityplayermp1.gamemode.id));
        entityplayermp1.playerNetServerHandler.teleportTo(entityplayermp1.aM, entityplayermp1.aN, entityplayermp1.aO, entityplayermp1.aS, entityplayermp1.aT);
        this.func_28170_a(entityplayermp1, worldserver);
        this.getPlayerManager(entityplayermp1.m).addPlayer(entityplayermp1);
        worldserver.b(entityplayermp1);
        this.playerEntities.add(entityplayermp1);
        entityplayermp1.func_20057_k();
        entityplayermp1.func_22068_s();
        return entityplayermp1;
    }

    public void sendPlayerToOtherDimension(EntityPlayerMP entityplayermp, int targetDim) {
        WorldServer worldserver = this.mcServer.getWorldManager(entityplayermp.m);
        Dimension lastDim = Dimension.dimensionList[entityplayermp.m];
        Dimension newDim = Dimension.dimensionList[targetDim];
        entityplayermp.m = targetDim;
        WorldServer worldserver1 = this.mcServer.getWorldManager(entityplayermp.m);
        entityplayermp.playerNetServerHandler.sendPacket(new ox((byte)entityplayermp.m));
        worldserver.removePlayer(entityplayermp);
        entityplayermp.be = false;
        double d2 = entityplayermp.aM;
        double d1 = entityplayermp.aO;
        double d22 = 8.0;
        entityplayermp.c(d2 *= (double)Dimension.getCoordScale(lastDim, newDim), entityplayermp.aN, d1 *= (double)Dimension.getCoordScale(lastDim, newDim), entityplayermp.aS, entityplayermp.aT);
        if (entityplayermp.W()) {
            worldserver.a((sn)entityplayermp, false);
        }
        if (entityplayermp.W()) {
            worldserver1.b(entityplayermp);
            entityplayermp.c(d2, entityplayermp.aN, d1, entityplayermp.aS, entityplayermp.aT);
            worldserver1.a((sn)entityplayermp, false);
            worldserver1.chunkProviderServer.chunkLoadOverride = true;
            new ur().func_4107_a(worldserver1, entityplayermp, lastDim, newDim);
            worldserver1.chunkProviderServer.chunkLoadOverride = false;
        }
        this.func_28172_a(entityplayermp);
        entityplayermp.playerNetServerHandler.teleportTo(entityplayermp.aM, entityplayermp.aN, entityplayermp.aO, entityplayermp.aS, entityplayermp.aT);
        entityplayermp.playerNetServerHandler.sendPacket(new Packet41EntityPlayerGamemode(entityplayermp.getGamemode().id));
        entityplayermp.a(worldserver1);
        this.func_28170_a(entityplayermp, worldserver1);
        this.func_30008_g(entityplayermp);
    }

    public void onTick() {
        for (int i2 = 0; i2 < this.playerManagerObj.length; ++i2) {
            this.playerManagerObj[i2].updatePlayerInstances();
        }
    }

    public void markBlockNeedsUpdate(int i2, int j, int k, int l) {
        this.getPlayerManager(l).markBlockNeedsUpdate(i2, j, k);
    }

    public void sendPacketToAllPlayers(ki packet) {
        for (int i2 = 0; i2 < this.playerEntities.size(); ++i2) {
            EntityPlayerMP entityplayermp = (EntityPlayerMP)this.playerEntities.get(i2);
            entityplayermp.playerNetServerHandler.sendPacket(packet);
        }
    }

    public void sendPacketToAllPlayersInDimension(ki packet, int i2) {
        for (int j = 0; j < this.playerEntities.size(); ++j) {
            EntityPlayerMP entityplayermp = (EntityPlayerMP)this.playerEntities.get(j);
            if (entityplayermp.m != i2) continue;
            entityplayermp.playerNetServerHandler.sendPacket(packet);
        }
    }

    public String getPlayerList() {
        String s2 = "";
        for (int i2 = 0; i2 < this.playerEntities.size(); ++i2) {
            if (i2 > 0) {
                s2 = s2 + ", ";
            }
            s2 = s2 + ((EntityPlayerMP)this.playerEntities.get((int)i2)).l;
        }
        return s2;
    }

    public void banPlayer(String s2) {
        this.bannedPlayers.add(s2.toLowerCase());
        this.writeBannedPlayers();
    }

    public void pardonPlayer(String s2) {
        this.bannedPlayers.remove(s2.toLowerCase());
        this.writeBannedPlayers();
    }

    private void readBannedPlayers() {
        try {
            this.bannedPlayers.clear();
            BufferedReader bufferedreader = new BufferedReader(new FileReader(this.bannedPlayersFile));
            String s2 = "";
            while ((s2 = bufferedreader.readLine()) != null) {
                this.bannedPlayers.add(s2.trim().toLowerCase());
            }
            bufferedreader.close();
        }
        catch (Exception exception) {
            logger.warning("Failed to load ban list: " + exception);
        }
    }

    private void writeBannedPlayers() {
        try {
            PrintWriter printwriter = new PrintWriter(new FileWriter(this.bannedPlayersFile, false));
            for (String s2 : this.bannedPlayers) {
                printwriter.println(s2);
            }
            printwriter.close();
        }
        catch (Exception exception) {
            logger.warning("Failed to save ban list: " + exception);
        }
    }

    public void banIP(String s2) {
        this.bannedIPs.add(s2.toLowerCase());
        this.saveBannedList();
    }

    public void pardonIP(String s2) {
        this.bannedIPs.remove(s2.toLowerCase());
        this.saveBannedList();
    }

    private void loadBannedList() {
        try {
            this.bannedIPs.clear();
            BufferedReader bufferedreader = new BufferedReader(new FileReader(this.ipBanFile));
            String s2 = "";
            while ((s2 = bufferedreader.readLine()) != null) {
                this.bannedIPs.add(s2.trim().toLowerCase());
            }
            bufferedreader.close();
        }
        catch (Exception exception) {
            logger.warning("Failed to load ip ban list: " + exception);
        }
    }

    private void saveBannedList() {
        try {
            PrintWriter printwriter = new PrintWriter(new FileWriter(this.ipBanFile, false));
            for (String s2 : this.bannedIPs) {
                printwriter.println(s2);
            }
            printwriter.close();
        }
        catch (Exception exception) {
            logger.warning("Failed to save ip ban list: " + exception);
        }
    }

    public void opPlayer(String s2) {
        this.ops.add(s2.toLowerCase());
        this.saveOps();
    }

    public void deopPlayer(String s2) {
        this.ops.remove(s2.toLowerCase());
        this.saveOps();
    }

    private void loadOps() {
        try {
            this.ops.clear();
            BufferedReader bufferedreader = new BufferedReader(new FileReader(this.opFile));
            String s2 = "";
            while ((s2 = bufferedreader.readLine()) != null) {
                this.ops.add(s2.trim().toLowerCase());
            }
            bufferedreader.close();
        }
        catch (Exception exception) {
            logger.warning("Failed to load ip ban list: " + exception);
        }
    }

    private void saveOps() {
        try {
            PrintWriter printwriter = new PrintWriter(new FileWriter(this.opFile, false));
            for (String s2 : this.ops) {
                printwriter.println(s2);
            }
            printwriter.close();
        }
        catch (Exception exception) {
            logger.warning("Failed to save ip ban list: " + exception);
        }
    }

    private void loadWhiteList() {
        try {
            this.whiteListedIPs.clear();
            BufferedReader bufferedreader = new BufferedReader(new FileReader(this.whitelistPlayersFile));
            String s2 = "";
            while ((s2 = bufferedreader.readLine()) != null) {
                this.whiteListedIPs.add(s2.trim().toLowerCase());
            }
            bufferedreader.close();
        }
        catch (Exception exception) {
            logger.warning("Failed to load white-list: " + exception);
        }
    }

    private void saveWhiteList() {
        try {
            PrintWriter printwriter = new PrintWriter(new FileWriter(this.whitelistPlayersFile, false));
            for (String s2 : this.whiteListedIPs) {
                printwriter.println(s2);
            }
            printwriter.close();
        }
        catch (Exception exception) {
            logger.warning("Failed to save white-list: " + exception);
        }
    }

    public boolean isAllowedToLogin(String s2) {
        s2 = s2.trim().toLowerCase();
        return !this.whiteListEnforced || this.ops.contains(s2) || this.whiteListedIPs.contains(s2);
    }

    public boolean isOp(String s2) {
        return this.ops.contains(s2.trim().toLowerCase());
    }

    public EntityPlayerMP getPlayerEntity(String s2) {
        for (int i2 = 0; i2 < this.playerEntities.size(); ++i2) {
            EntityPlayerMP entityplayermp = (EntityPlayerMP)this.playerEntities.get(i2);
            if (!entityplayermp.l.equalsIgnoreCase(s2)) continue;
            return entityplayermp;
        }
        return null;
    }

    public void sendChatMessageToPlayer(String s2, String s1) {
        EntityPlayerMP entityplayermp = this.getPlayerEntity(s2);
        if (entityplayermp != null) {
            entityplayermp.playerNetServerHandler.sendPacket((ki)new pe(s1));
        }
    }

    public void sendPacketToPlayersAroundPoint(double d2, double d1, double d22, double d3, int i2, ki packet) {
        this.func_28171_a(null, d2, d1, d22, d3, i2, packet);
    }

    public void func_28171_a(gs entityplayer, double d2, double d1, double d22, double d3, int i2, ki packet) {
        for (int j = 0; j < this.playerEntities.size(); ++j) {
            double d6;
            double d5;
            double d4;
            EntityPlayerMP entityplayermp = (EntityPlayerMP)this.playerEntities.get(j);
            if (entityplayermp == entityplayer || entityplayermp.m != i2 || !((d4 = d2 - entityplayermp.aM) * d4 + (d5 = d1 - entityplayermp.aN) * d5 + (d6 = d22 - entityplayermp.aO) * d6 < d3 * d3)) continue;
            entityplayermp.playerNetServerHandler.sendPacket(packet);
        }
    }

    public void sendChatMessageToAllOps(String s2) {
        pe packet3chat = new pe(s2);
        for (int i2 = 0; i2 < this.playerEntities.size(); ++i2) {
            EntityPlayerMP entityplayermp = (EntityPlayerMP)this.playerEntities.get(i2);
            if (!this.isOp(entityplayermp.l)) continue;
            entityplayermp.playerNetServerHandler.sendPacket((ki)packet3chat);
        }
    }

    public boolean sendPacketToPlayer(String s2, ki packet) {
        EntityPlayerMP entityplayermp = this.getPlayerEntity(s2);
        if (entityplayermp != null) {
            entityplayermp.playerNetServerHandler.sendPacket(packet);
            return true;
        }
        return false;
    }

    public void savePlayerStates() {
        for (int i2 = 0; i2 < this.playerEntities.size(); ++i2) {
            this.playerNBTManagerObj.writePlayerData((gs)this.playerEntities.get(i2));
        }
    }

    public void sentTileEntityToPlayer(int i2, int j, int k, ow tileentity) {
    }

    public void addToWhiteList(String s2) {
        this.whiteListedIPs.add(s2);
        this.saveWhiteList();
    }

    public void removeFromWhiteList(String s2) {
        this.whiteListedIPs.remove(s2);
        this.saveWhiteList();
    }

    public Set getWhiteListedIPs() {
        return this.whiteListedIPs;
    }

    public void reloadWhiteList() {
        this.loadWhiteList();
    }

    public void func_28170_a(EntityPlayerMP entityplayermp, WorldServer worldserver) {
        entityplayermp.playerNetServerHandler.sendPacket(new hg(worldserver.t()));
    }

    public void func_30008_g(EntityPlayerMP entityplayermp) {
        entityplayermp.func_28017_a(entityplayermp.d);
        entityplayermp.func_30001_B();
    }
}

