/*
 * Decompiled with CFR 0.152.
 */
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;

public class TextureAnimatedFX
extends aw {
    private int[][] animationData;
    private int firstFrameIndex;
    private int frames;
    private int ticksPerFrame;
    private boolean reversed;
    private int tick;
    private int currentFrame = 0;

    public TextureAnimatedFX(Minecraft mc2, int tileImage, int drawX, int drawY, int firstFrameX, int firstFrameY, int frames, int ticksPerFrame, boolean reversed) {
        super(tileImage == 0 ? uu.texCoordToIndex(drawX, drawY) : gm.iconCoordToIndex(drawX, drawY), tileImage, mc2);
        this.firstFrameIndex = tileImage == 0 ? uu.texCoordToIndex(firstFrameX, firstFrameY) : gm.iconCoordToIndex(firstFrameX, firstFrameY);
        this.frames = frames;
        this.ticksPerFrame = ticksPerFrame;
        this.reversed = reversed;
        this.updateWidth();
    }

    @Override
    public void updateWidth() {
        super.updateWidth();
        this.animationData = new int[this.frames][];
        try {
            BufferedImage bufferedimage = ImageIO.read(this.mc.D.a.a("/terrain.png"));
            for (int i2 = 0; i2 < this.frames; ++i2) {
                int x = (this.firstFrameIndex + i2) % net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES * this.width;
                int y = (this.firstFrameIndex + i2) / net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES * this.width;
                this.animationData[i2] = new int[this.width * this.width];
                bufferedimage.getRGB(x, y, this.width, this.width, this.animationData[i2], 0, this.width);
            }
        }
        catch (IOException ioexception) {
            ioexception.printStackTrace();
        }
    }

    @Override
    public void a() {
        if (this.tick % this.ticksPerFrame == 0) {
            if (!this.reversed) {
                this.currentFrame = (this.currentFrame + 1) % this.frames;
            } else {
                this.currentFrame = (this.currentFrame - 1) % this.frames;
                if (this.currentFrame < 0) {
                    this.currentFrame += this.frames;
                }
            }
            for (int i2 = 0; i2 < this.width * this.width; ++i2) {
                int a2 = this.animationData[this.currentFrame][i2] >> 24 & 0xFF;
                int r = this.animationData[this.currentFrame][i2] >> 16 & 0xFF;
                int g2 = this.animationData[this.currentFrame][i2] >> 8 & 0xFF;
                int b = this.animationData[this.currentFrame][i2] >> 0 & 0xFF;
                this.a[i2 * 4 + 0] = (byte)r;
                this.a[i2 * 4 + 1] = (byte)g2;
                this.a[i2 * 4 + 2] = (byte)b;
                this.a[i2 * 4 + 3] = (byte)a2;
            }
        }
        this.tick = (this.tick + 1) % this.ticksPerFrame;
    }
}

