/*
 * Decompiled with CFR 0.152.
 */
import java.util.Random;

public class Weather {
    public int weatherId;
    public String languageKey;
    public boolean isPrecipitation = false;
    public String texturePath = null;
    public int subtractLightLevel = 0;
    public int precipitationType = 0;
    public boolean spawnRainParticles = false;
    public boolean doMobsSpawnInDaylight = false;
    public float fogDistance = 1.0f;
    public static Weather[] weatherList = new Weather[16];
    public static final Weather weatherClear = new WeatherClear(0).setLanguageKey("clear");
    public static final Weather weatherRain = new WeatherRain(1).setLanguageKey("rain").setPrecipitation("/environment/rain.png", 0).setSubtractLightLevel(3).setSpawnRainParticles(true).setFogDistance(0.5f);
    public static final Weather weatherSnow = new WeatherSnow(2).setLanguageKey("snow").setPrecipitation("/environment/snow.png", 1).setSubtractLightLevel(1).setFogDistance(0.5f);
    public static final Weather weatherStorm = new WeatherStorm(3).setLanguageKey("storm").setPrecipitation("/environment/rain.png", 0).setSubtractLightLevel(5).setSpawnRainParticles(true).setMobsSpawnInDaylight().setFogDistance(0.4f);
    public static final Weather weatherFog = new WeatherClear(4).setLanguageKey("fog").setFogDistance(0.125f);
    public static final Weather weatherHellClear = new WeatherClear(5).setLanguageKey("clear").setSubtractLightLevel(7);
    public static final Weather weatherWoodsClear = new WeatherClear(6).setLanguageKey("clear").setSubtractLightLevel(2);

    public Weather(int id2) {
        Weather.weatherList[id2] = this;
        this.weatherId = id2;
    }

    public Weather setLanguageKey(String key) {
        this.languageKey = key;
        return this;
    }

    public Weather setPrecipitation(String texturePath, int type) {
        this.isPrecipitation = true;
        this.texturePath = texturePath;
        this.precipitationType = type;
        return this;
    }

    public Weather setPrecipitationTexture(String texturePath) {
        this.texturePath = texturePath;
        return this;
    }

    public Weather setSubtractLightLevel(int subtractLightLevel) {
        this.subtractLightLevel = subtractLightLevel;
        return this;
    }

    public Weather setSpawnRainParticles(boolean spawnRainParticles) {
        this.spawnRainParticles = spawnRainParticles;
        return this;
    }

    public Weather setFogDistance(float f) {
        this.fogDistance = f;
        return this;
    }

    public Weather setMobsSpawnInDaylight() {
        this.doMobsSpawnInDaylight = true;
        return this;
    }

    public String getName() {
        return nh.a().b("weather." + this.languageKey);
    }

    public float[] modifyFogColor(float r, float g2, float b2, float intensity) {
        return new float[]{r, g2, b2};
    }

    public void doEnvironmentGenerate(fd world, int x, int z2) {
    }

    public void doEnvironmentUpdate(fd world, Random rand, int x, int z2) {
    }
}

