/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.src.WeightedRandomBag;

public class WeightedRandomBag<T> {
    private final List<WeightedRandomBag.Entry> entries = new ArrayList<WeightedRandomBag.Entry>();
    private double accumulatedWeight;
    private final Random rand = new Random();

    public void addEntry(T object, double weight) {
        this.accumulatedWeight += weight;
        Entry e2 = new Entry();
        e2.object = object;
        e2.accumulatedWeight = this.accumulatedWeight;
        this.entries.add((WeightedRandomBag.Entry)e2);
    }

    public T getRandom() {
        double r = this.rand.nextDouble() * this.accumulatedWeight;
        for (Entry entry : this.entries) {
            if (!(entry.accumulatedWeight >= r)) continue;
            return entry.object;
        }
        return null;
    }

    private class Entry {
        double accumulatedWeight;
        T object;

        private Entry() {
        }
    }
}

